
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Payment Message Data
 * 
 * <p>Java class for Payment_Message_WWS_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Payment_Message_WWS_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Payment_Message_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Create_Date" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="Create_Date_Sequence" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="10"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Integration_System_Reference" type="{urn:com.workday/bsvc}Integration_System__Audited_ObjectType" minOccurs="0"/>
 *         &lt;element name="Payment_Count" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="12"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Payments_Sum" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Payment_Message_Group_Data" type="{urn:com.workday/bsvc}Payment_Message_Group_WWS_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Payment_Message_WWS_DataType", propOrder = {
    "paymentMessageID",
    "createDate",
    "createDateSequence",
    "integrationSystemReference",
    "paymentCount",
    "paymentsSum",
    "paymentMessageGroupData"
})
public class PaymentMessageWWSDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Payment_Message_ID")
    protected String paymentMessageID;
    @XmlElement(name = "Create_Date")
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar createDate;
    @XmlElement(name = "Create_Date_Sequence")
    protected BigDecimal createDateSequence;
    @XmlElement(name = "Integration_System_Reference")
    protected IntegrationSystemAuditedObjectType integrationSystemReference;
    @XmlElement(name = "Payment_Count")
    protected BigDecimal paymentCount;
    @XmlElement(name = "Payments_Sum")
    protected BigDecimal paymentsSum;
    @XmlElement(name = "Payment_Message_Group_Data")
    protected List<PaymentMessageGroupWWSDataType> paymentMessageGroupData;

    /**
     * Gets the value of the paymentMessageID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPaymentMessageID() {
        return paymentMessageID;
    }

    /**
     * Sets the value of the paymentMessageID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPaymentMessageID(String value) {
        this.paymentMessageID = value;
    }

    /**
     * Gets the value of the createDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCreateDate() {
        return createDate;
    }

    /**
     * Sets the value of the createDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCreateDate(XMLGregorianCalendar value) {
        this.createDate = value;
    }

    /**
     * Gets the value of the createDateSequence property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getCreateDateSequence() {
        return createDateSequence;
    }

    /**
     * Sets the value of the createDateSequence property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setCreateDateSequence(BigDecimal value) {
        this.createDateSequence = value;
    }

    /**
     * Gets the value of the integrationSystemReference property.
     * 
     * @return
     *     possible object is
     *     {@link IntegrationSystemAuditedObjectType }
     *     
     */
    public IntegrationSystemAuditedObjectType getIntegrationSystemReference() {
        return integrationSystemReference;
    }

    /**
     * Sets the value of the integrationSystemReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link IntegrationSystemAuditedObjectType }
     *     
     */
    public void setIntegrationSystemReference(IntegrationSystemAuditedObjectType value) {
        this.integrationSystemReference = value;
    }

    /**
     * Gets the value of the paymentCount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPaymentCount() {
        return paymentCount;
    }

    /**
     * Sets the value of the paymentCount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPaymentCount(BigDecimal value) {
        this.paymentCount = value;
    }

    /**
     * Gets the value of the paymentsSum property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPaymentsSum() {
        return paymentsSum;
    }

    /**
     * Sets the value of the paymentsSum property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPaymentsSum(BigDecimal value) {
        this.paymentsSum = value;
    }

    /**
     * Gets the value of the paymentMessageGroupData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the paymentMessageGroupData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPaymentMessageGroupData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PaymentMessageGroupWWSDataType }
     * 
     * 
     */
    public List<PaymentMessageGroupWWSDataType> getPaymentMessageGroupData() {
        if (paymentMessageGroupData == null) {
            paymentMessageGroupData = new ArrayList<PaymentMessageGroupWWSDataType>();
        }
        return this.paymentMessageGroupData;
    }

    /**
     * Sets the value of the paymentMessageGroupData property.
     * 
     * @param paymentMessageGroupData
     *     allowed object is
     *     {@link PaymentMessageGroupWWSDataType }
     *     
     */
    public void setPaymentMessageGroupData(List<PaymentMessageGroupWWSDataType> paymentMessageGroupData) {
        this.paymentMessageGroupData = paymentMessageGroupData;
    }

}
