
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Get Payment Messages Request Criteria
 * 
 * <p>Java class for Payment_Message_Request_CriteriaType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Payment_Message_Request_CriteriaType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Organization_Reference" type="{urn:com.workday/bsvc}OrganizationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Bank_Account_Reference" type="{urn:com.workday/bsvc}Bank_AccountObjectType" minOccurs="0"/>
 *         &lt;element name="Created_After" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Created_Before" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Payment_Message_Request_CriteriaType", propOrder = {
    "organizationReference",
    "bankAccountReference",
    "createdAfter",
    "createdBefore"
})
public class PaymentMessageRequestCriteriaType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Organization_Reference")
    protected List<OrganizationObjectType> organizationReference;
    @XmlElement(name = "Bank_Account_Reference")
    protected BankAccountObjectType bankAccountReference;
    @XmlElement(name = "Created_After")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar createdAfter;
    @XmlElement(name = "Created_Before")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar createdBefore;

    /**
     * Gets the value of the organizationReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the organizationReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOrganizationReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OrganizationObjectType }
     * 
     * 
     */
    public List<OrganizationObjectType> getOrganizationReference() {
        if (organizationReference == null) {
            organizationReference = new ArrayList<OrganizationObjectType>();
        }
        return this.organizationReference;
    }

    /**
     * Gets the value of the bankAccountReference property.
     * 
     * @return
     *     possible object is
     *     {@link BankAccountObjectType }
     *     
     */
    public BankAccountObjectType getBankAccountReference() {
        return bankAccountReference;
    }

    /**
     * Sets the value of the bankAccountReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BankAccountObjectType }
     *     
     */
    public void setBankAccountReference(BankAccountObjectType value) {
        this.bankAccountReference = value;
    }

    /**
     * Gets the value of the createdAfter property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCreatedAfter() {
        return createdAfter;
    }

    /**
     * Sets the value of the createdAfter property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCreatedAfter(XMLGregorianCalendar value) {
        this.createdAfter = value;
    }

    /**
     * Gets the value of the createdBefore property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCreatedBefore() {
        return createdBefore;
    }

    /**
     * Sets the value of the createdBefore property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCreatedBefore(XMLGregorianCalendar value) {
        this.createdBefore = value;
    }

    /**
     * Sets the value of the organizationReference property.
     * 
     * @param organizationReference
     *     allowed object is
     *     {@link OrganizationObjectType }
     *     
     */
    public void setOrganizationReference(List<OrganizationObjectType> organizationReference) {
        this.organizationReference = organizationReference;
    }

}
