
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Payment Message Group Data
 * 
 * <p>Java class for Payment_Message_Group_WWS_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Payment_Message_Group_WWS_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Payment_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Payment_Type_Reference" type="{urn:com.workday/bsvc}Payment_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Payment_Method_Reference" type="{urn:com.workday/bsvc}Payment_MethodObjectType" minOccurs="0"/>
 *         &lt;element name="Payment_Category_Reference" type="{urn:com.workday/bsvc}Payment_CategoryObjectType" minOccurs="0"/>
 *         &lt;element name="Originating_Contact_Data" type="{urn:com.workday/bsvc}Originating_Party_WWS_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Originating_Bank_Data" type="{urn:com.workday/bsvc}Originating_Party_Bank_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Group_Payment_Count" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="12"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Group_Rejected_Payment_Count" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="12"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Group_Reprocessed_Payment_Count" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="12"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Group_Payment_Sum" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Group_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Payment_Data" type="{urn:com.workday/bsvc}Payment_WWS_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Payment_Message_Group_WWS_DataType", propOrder = {
    "paymentDate",
    "currencyReference",
    "paymentTypeReference",
    "paymentMethodReference",
    "paymentCategoryReference",
    "originatingContactData",
    "originatingBankData",
    "groupPaymentCount",
    "groupRejectedPaymentCount",
    "groupReprocessedPaymentCount",
    "groupPaymentSum",
    "groupID",
    "paymentData"
})
public class PaymentMessageGroupWWSDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Payment_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar paymentDate;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Payment_Type_Reference")
    protected PaymentTypeObjectType paymentTypeReference;
    @XmlElement(name = "Payment_Method_Reference")
    protected PaymentMethodObjectType paymentMethodReference;
    @XmlElement(name = "Payment_Category_Reference")
    protected PaymentCategoryObjectType paymentCategoryReference;
    @XmlElement(name = "Originating_Contact_Data")
    protected List<OriginatingPartyWWSDataType> originatingContactData;
    @XmlElement(name = "Originating_Bank_Data")
    protected List<OriginatingPartyBankDataType> originatingBankData;
    @XmlElement(name = "Group_Payment_Count")
    protected BigDecimal groupPaymentCount;
    @XmlElement(name = "Group_Rejected_Payment_Count")
    protected BigDecimal groupRejectedPaymentCount;
    @XmlElement(name = "Group_Reprocessed_Payment_Count")
    protected BigDecimal groupReprocessedPaymentCount;
    @XmlElement(name = "Group_Payment_Sum")
    protected BigDecimal groupPaymentSum;
    @XmlElement(name = "Group_ID")
    protected String groupID;
    @XmlElement(name = "Payment_Data")
    protected List<PaymentWWSDataType> paymentData;

    /**
     * Gets the value of the paymentDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getPaymentDate() {
        return paymentDate;
    }

    /**
     * Sets the value of the paymentDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setPaymentDate(XMLGregorianCalendar value) {
        this.paymentDate = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the paymentTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentTypeObjectType }
     *     
     */
    public PaymentTypeObjectType getPaymentTypeReference() {
        return paymentTypeReference;
    }

    /**
     * Sets the value of the paymentTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentTypeObjectType }
     *     
     */
    public void setPaymentTypeReference(PaymentTypeObjectType value) {
        this.paymentTypeReference = value;
    }

    /**
     * Gets the value of the paymentMethodReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentMethodObjectType }
     *     
     */
    public PaymentMethodObjectType getPaymentMethodReference() {
        return paymentMethodReference;
    }

    /**
     * Sets the value of the paymentMethodReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentMethodObjectType }
     *     
     */
    public void setPaymentMethodReference(PaymentMethodObjectType value) {
        this.paymentMethodReference = value;
    }

    /**
     * Gets the value of the paymentCategoryReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentCategoryObjectType }
     *     
     */
    public PaymentCategoryObjectType getPaymentCategoryReference() {
        return paymentCategoryReference;
    }

    /**
     * Sets the value of the paymentCategoryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentCategoryObjectType }
     *     
     */
    public void setPaymentCategoryReference(PaymentCategoryObjectType value) {
        this.paymentCategoryReference = value;
    }

    /**
     * Gets the value of the originatingContactData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the originatingContactData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOriginatingContactData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OriginatingPartyWWSDataType }
     * 
     * 
     */
    public List<OriginatingPartyWWSDataType> getOriginatingContactData() {
        if (originatingContactData == null) {
            originatingContactData = new ArrayList<OriginatingPartyWWSDataType>();
        }
        return this.originatingContactData;
    }

    /**
     * Gets the value of the originatingBankData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the originatingBankData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOriginatingBankData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OriginatingPartyBankDataType }
     * 
     * 
     */
    public List<OriginatingPartyBankDataType> getOriginatingBankData() {
        if (originatingBankData == null) {
            originatingBankData = new ArrayList<OriginatingPartyBankDataType>();
        }
        return this.originatingBankData;
    }

    /**
     * Gets the value of the groupPaymentCount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getGroupPaymentCount() {
        return groupPaymentCount;
    }

    /**
     * Sets the value of the groupPaymentCount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setGroupPaymentCount(BigDecimal value) {
        this.groupPaymentCount = value;
    }

    /**
     * Gets the value of the groupRejectedPaymentCount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getGroupRejectedPaymentCount() {
        return groupRejectedPaymentCount;
    }

    /**
     * Sets the value of the groupRejectedPaymentCount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setGroupRejectedPaymentCount(BigDecimal value) {
        this.groupRejectedPaymentCount = value;
    }

    /**
     * Gets the value of the groupReprocessedPaymentCount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getGroupReprocessedPaymentCount() {
        return groupReprocessedPaymentCount;
    }

    /**
     * Sets the value of the groupReprocessedPaymentCount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setGroupReprocessedPaymentCount(BigDecimal value) {
        this.groupReprocessedPaymentCount = value;
    }

    /**
     * Gets the value of the groupPaymentSum property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getGroupPaymentSum() {
        return groupPaymentSum;
    }

    /**
     * Sets the value of the groupPaymentSum property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setGroupPaymentSum(BigDecimal value) {
        this.groupPaymentSum = value;
    }

    /**
     * Gets the value of the groupID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGroupID() {
        return groupID;
    }

    /**
     * Sets the value of the groupID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGroupID(String value) {
        this.groupID = value;
    }

    /**
     * Gets the value of the paymentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the paymentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPaymentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PaymentWWSDataType }
     * 
     * 
     */
    public List<PaymentWWSDataType> getPaymentData() {
        if (paymentData == null) {
            paymentData = new ArrayList<PaymentWWSDataType>();
        }
        return this.paymentData;
    }

    /**
     * Sets the value of the originatingContactData property.
     * 
     * @param originatingContactData
     *     allowed object is
     *     {@link OriginatingPartyWWSDataType }
     *     
     */
    public void setOriginatingContactData(List<OriginatingPartyWWSDataType> originatingContactData) {
        this.originatingContactData = originatingContactData;
    }

    /**
     * Sets the value of the originatingBankData property.
     * 
     * @param originatingBankData
     *     allowed object is
     *     {@link OriginatingPartyBankDataType }
     *     
     */
    public void setOriginatingBankData(List<OriginatingPartyBankDataType> originatingBankData) {
        this.originatingBankData = originatingBankData;
    }

    /**
     * Sets the value of the paymentData property.
     * 
     * @param paymentData
     *     allowed object is
     *     {@link PaymentWWSDataType }
     *     
     */
    public void setPaymentData(List<PaymentWWSDataType> paymentData) {
        this.paymentData = paymentData;
    }

}
