
package com.workday.financial;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Common payment data that can be part identified in payment groups. Can be conditionally returned by setting the "Include Payment Group Data" grouping flag.
 * 
 * <p>Java class for Payment_Group_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Payment_Group_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Payment_Group_Reference" type="{urn:com.workday/bsvc}Payment_GroupObjectType" minOccurs="0"/>
 *         &lt;element name="Payment_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Payment_Type_Reference" type="{urn:com.workday/bsvc}Payment_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Payment_Method_Reference" type="{urn:com.workday/bsvc}Payment_MethodObjectType" minOccurs="0"/>
 *         &lt;element name="Payment_Category_Reference" type="{urn:com.workday/bsvc}Payment_CategoryObjectType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Payment_Group_DataType", propOrder = {
    "paymentGroupReference",
    "paymentDate",
    "currencyReference",
    "paymentTypeReference",
    "paymentMethodReference",
    "paymentCategoryReference"
})
public class PaymentGroupDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Payment_Group_Reference")
    protected PaymentGroupObjectType paymentGroupReference;
    @XmlElement(name = "Payment_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar paymentDate;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Payment_Type_Reference")
    protected PaymentTypeObjectType paymentTypeReference;
    @XmlElement(name = "Payment_Method_Reference")
    protected PaymentMethodObjectType paymentMethodReference;
    @XmlElement(name = "Payment_Category_Reference")
    protected PaymentCategoryObjectType paymentCategoryReference;

    /**
     * Gets the value of the paymentGroupReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentGroupObjectType }
     *     
     */
    public PaymentGroupObjectType getPaymentGroupReference() {
        return paymentGroupReference;
    }

    /**
     * Sets the value of the paymentGroupReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentGroupObjectType }
     *     
     */
    public void setPaymentGroupReference(PaymentGroupObjectType value) {
        this.paymentGroupReference = value;
    }

    /**
     * Gets the value of the paymentDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getPaymentDate() {
        return paymentDate;
    }

    /**
     * Sets the value of the paymentDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setPaymentDate(XMLGregorianCalendar value) {
        this.paymentDate = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the paymentTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentTypeObjectType }
     *     
     */
    public PaymentTypeObjectType getPaymentTypeReference() {
        return paymentTypeReference;
    }

    /**
     * Sets the value of the paymentTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentTypeObjectType }
     *     
     */
    public void setPaymentTypeReference(PaymentTypeObjectType value) {
        this.paymentTypeReference = value;
    }

    /**
     * Gets the value of the paymentMethodReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentMethodObjectType }
     *     
     */
    public PaymentMethodObjectType getPaymentMethodReference() {
        return paymentMethodReference;
    }

    /**
     * Sets the value of the paymentMethodReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentMethodObjectType }
     *     
     */
    public void setPaymentMethodReference(PaymentMethodObjectType value) {
        this.paymentMethodReference = value;
    }

    /**
     * Gets the value of the paymentCategoryReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentCategoryObjectType }
     *     
     */
    public PaymentCategoryObjectType getPaymentCategoryReference() {
        return paymentCategoryReference;
    }

    /**
     * Sets the value of the paymentCategoryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentCategoryObjectType }
     *     
     */
    public void setPaymentCategoryReference(PaymentCategoryObjectType value) {
        this.paymentCategoryReference = value;
    }

}
