
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Originating Party Bank Data. Can be conditionally returned by setting the "Include Originating Bank data" grouping flag.
 * 
 * <p>Java class for Originating_Party_Bank_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Originating_Party_Bank_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Bank_Account_Reference" type="{urn:com.workday/bsvc}Bank_AccountObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Account_Nickname" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Account_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Account_Type_Code" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Financial_Institution_Reference" type="{urn:com.workday/bsvc}Financial_InstitutionObjectType" minOccurs="0"/>
 *         &lt;element name="IBAN" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Routing_Transit_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Bank_Identification_Code" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Branch_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Branch_ID_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Country_Reference" type="{urn:com.workday/bsvc}CountryObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Bank_Account_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Check_Digit" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Roll_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Bank_Address_Data" type="{urn:com.workday/bsvc}Address_Information_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Originating_Party_Bank_DataType", propOrder = {
    "bankAccountReference",
    "accountNickname",
    "accountNumber",
    "accountTypeCode",
    "financialInstitutionReference",
    "iban",
    "routingTransitNumber",
    "bankIdentificationCode",
    "branchName",
    "branchIDNumber",
    "countryReference",
    "currencyReference",
    "bankAccountName",
    "checkDigit",
    "rollNumber",
    "bankAddressData"
})
public class OriginatingPartyBankDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Bank_Account_Reference")
    protected List<BankAccountObjectType> bankAccountReference;
    @XmlElement(name = "Account_Nickname")
    protected String accountNickname;
    @XmlElement(name = "Account_Number")
    protected String accountNumber;
    @XmlElement(name = "Account_Type_Code")
    protected String accountTypeCode;
    @XmlElement(name = "Financial_Institution_Reference")
    protected FinancialInstitutionObjectType financialInstitutionReference;
    @XmlElement(name = "IBAN")
    protected String iban;
    @XmlElement(name = "Routing_Transit_Number")
    protected String routingTransitNumber;
    @XmlElement(name = "Bank_Identification_Code")
    protected String bankIdentificationCode;
    @XmlElement(name = "Branch_Name")
    protected String branchName;
    @XmlElement(name = "Branch_ID_Number")
    protected String branchIDNumber;
    @XmlElement(name = "Country_Reference")
    protected CountryObjectType countryReference;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Bank_Account_Name")
    protected String bankAccountName;
    @XmlElement(name = "Check_Digit")
    protected String checkDigit;
    @XmlElement(name = "Roll_Number")
    protected String rollNumber;
    @XmlElement(name = "Bank_Address_Data")
    protected List<AddressInformationDataType> bankAddressData;

    /**
     * Gets the value of the bankAccountReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the bankAccountReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBankAccountReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BankAccountObjectType }
     * 
     * 
     */
    public List<BankAccountObjectType> getBankAccountReference() {
        if (bankAccountReference == null) {
            bankAccountReference = new ArrayList<BankAccountObjectType>();
        }
        return this.bankAccountReference;
    }

    /**
     * Gets the value of the accountNickname property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccountNickname() {
        return accountNickname;
    }

    /**
     * Sets the value of the accountNickname property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccountNickname(String value) {
        this.accountNickname = value;
    }

    /**
     * Gets the value of the accountNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccountNumber() {
        return accountNumber;
    }

    /**
     * Sets the value of the accountNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccountNumber(String value) {
        this.accountNumber = value;
    }

    /**
     * Gets the value of the accountTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccountTypeCode() {
        return accountTypeCode;
    }

    /**
     * Sets the value of the accountTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccountTypeCode(String value) {
        this.accountTypeCode = value;
    }

    /**
     * Gets the value of the financialInstitutionReference property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialInstitutionObjectType }
     *     
     */
    public FinancialInstitutionObjectType getFinancialInstitutionReference() {
        return financialInstitutionReference;
    }

    /**
     * Sets the value of the financialInstitutionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialInstitutionObjectType }
     *     
     */
    public void setFinancialInstitutionReference(FinancialInstitutionObjectType value) {
        this.financialInstitutionReference = value;
    }

    /**
     * Gets the value of the iban property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIBAN() {
        return iban;
    }

    /**
     * Sets the value of the iban property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIBAN(String value) {
        this.iban = value;
    }

    /**
     * Gets the value of the routingTransitNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRoutingTransitNumber() {
        return routingTransitNumber;
    }

    /**
     * Sets the value of the routingTransitNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRoutingTransitNumber(String value) {
        this.routingTransitNumber = value;
    }

    /**
     * Gets the value of the bankIdentificationCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankIdentificationCode() {
        return bankIdentificationCode;
    }

    /**
     * Sets the value of the bankIdentificationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankIdentificationCode(String value) {
        this.bankIdentificationCode = value;
    }

    /**
     * Gets the value of the branchName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBranchName() {
        return branchName;
    }

    /**
     * Sets the value of the branchName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBranchName(String value) {
        this.branchName = value;
    }

    /**
     * Gets the value of the branchIDNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBranchIDNumber() {
        return branchIDNumber;
    }

    /**
     * Sets the value of the branchIDNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBranchIDNumber(String value) {
        this.branchIDNumber = value;
    }

    /**
     * Gets the value of the countryReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryObjectType }
     *     
     */
    public CountryObjectType getCountryReference() {
        return countryReference;
    }

    /**
     * Sets the value of the countryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryObjectType }
     *     
     */
    public void setCountryReference(CountryObjectType value) {
        this.countryReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the bankAccountName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankAccountName() {
        return bankAccountName;
    }

    /**
     * Sets the value of the bankAccountName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankAccountName(String value) {
        this.bankAccountName = value;
    }

    /**
     * Gets the value of the checkDigit property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCheckDigit() {
        return checkDigit;
    }

    /**
     * Sets the value of the checkDigit property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCheckDigit(String value) {
        this.checkDigit = value;
    }

    /**
     * Gets the value of the rollNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRollNumber() {
        return rollNumber;
    }

    /**
     * Sets the value of the rollNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRollNumber(String value) {
        this.rollNumber = value;
    }

    /**
     * Gets the value of the bankAddressData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the bankAddressData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBankAddressData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressInformationDataType }
     * 
     * 
     */
    public List<AddressInformationDataType> getBankAddressData() {
        if (bankAddressData == null) {
            bankAddressData = new ArrayList<AddressInformationDataType>();
        }
        return this.bankAddressData;
    }

    /**
     * Sets the value of the bankAccountReference property.
     * 
     * @param bankAccountReference
     *     allowed object is
     *     {@link BankAccountObjectType }
     *     
     */
    public void setBankAccountReference(List<BankAccountObjectType> bankAccountReference) {
        this.bankAccountReference = bankAccountReference;
    }

    /**
     * Sets the value of the bankAddressData property.
     * 
     * @param bankAddressData
     *     allowed object is
     *     {@link AddressInformationDataType }
     *     
     */
    public void setBankAddressData(List<AddressInformationDataType> bankAddressData) {
        this.bankAddressData = bankAddressData;
    }

}
