
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Contains the detailed information about an Organization.
 * 
 * <p>Java class for Organization_Common_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Organization_Common_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Include_Organization_ID_in_Name" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Organization_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Organization_Code" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Include_Organization_Code_in_Name" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Organization_Active" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Availability_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="Organization_Visibility_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="External_URL_Reference" type="{urn:com.workday/bsvc}External_URLObjectType" minOccurs="0"/>
 *         &lt;element name="Integration_ID_Data" type="{urn:com.workday/bsvc}External_Integration_ID_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Organization_Common_DataType", propOrder = {
    "id",
    "includeOrganizationIDInName",
    "organizationName",
    "organizationCode",
    "includeOrganizationCodeInName",
    "organizationActive",
    "availabilityDate",
    "organizationVisibilityReference",
    "externalURLReference",
    "integrationIDData"
})
public class OrganizationCommonDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "ID")
    protected String id;
    @XmlElement(name = "Include_Organization_ID_in_Name")
    protected Boolean includeOrganizationIDInName;
    @XmlElement(name = "Organization_Name")
    protected String organizationName;
    @XmlElement(name = "Organization_Code")
    protected String organizationCode;
    @XmlElement(name = "Include_Organization_Code_in_Name")
    protected Boolean includeOrganizationCodeInName;
    @XmlElement(name = "Organization_Active")
    protected Boolean organizationActive;
    @XmlElement(name = "Availability_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar availabilityDate;
    @XmlElement(name = "Organization_Visibility_Reference")
    protected UniqueIdentifierObjectType organizationVisibilityReference;
    @XmlElement(name = "External_URL_Reference")
    protected ExternalURLObjectType externalURLReference;
    @XmlElement(name = "Integration_ID_Data")
    protected List<ExternalIntegrationIDDataType> integrationIDData;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setID(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the includeOrganizationIDInName property.
     * This getter has been renamed from isIncludeOrganizationIDInName() to getIncludeOrganizationIDInName() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeOrganizationIDInName() {
        return includeOrganizationIDInName;
    }

    /**
     * Sets the value of the includeOrganizationIDInName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeOrganizationIDInName(Boolean value) {
        this.includeOrganizationIDInName = value;
    }

    /**
     * Gets the value of the organizationName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrganizationName() {
        return organizationName;
    }

    /**
     * Sets the value of the organizationName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrganizationName(String value) {
        this.organizationName = value;
    }

    /**
     * Gets the value of the organizationCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrganizationCode() {
        return organizationCode;
    }

    /**
     * Sets the value of the organizationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrganizationCode(String value) {
        this.organizationCode = value;
    }

    /**
     * Gets the value of the includeOrganizationCodeInName property.
     * This getter has been renamed from isIncludeOrganizationCodeInName() to getIncludeOrganizationCodeInName() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeOrganizationCodeInName() {
        return includeOrganizationCodeInName;
    }

    /**
     * Sets the value of the includeOrganizationCodeInName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeOrganizationCodeInName(Boolean value) {
        this.includeOrganizationCodeInName = value;
    }

    /**
     * Gets the value of the organizationActive property.
     * This getter has been renamed from isOrganizationActive() to getOrganizationActive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getOrganizationActive() {
        return organizationActive;
    }

    /**
     * Sets the value of the organizationActive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setOrganizationActive(Boolean value) {
        this.organizationActive = value;
    }

    /**
     * Gets the value of the availabilityDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getAvailabilityDate() {
        return availabilityDate;
    }

    /**
     * Sets the value of the availabilityDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setAvailabilityDate(XMLGregorianCalendar value) {
        this.availabilityDate = value;
    }

    /**
     * Gets the value of the organizationVisibilityReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getOrganizationVisibilityReference() {
        return organizationVisibilityReference;
    }

    /**
     * Sets the value of the organizationVisibilityReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setOrganizationVisibilityReference(UniqueIdentifierObjectType value) {
        this.organizationVisibilityReference = value;
    }

    /**
     * Gets the value of the externalURLReference property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalURLObjectType }
     *     
     */
    public ExternalURLObjectType getExternalURLReference() {
        return externalURLReference;
    }

    /**
     * Sets the value of the externalURLReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalURLObjectType }
     *     
     */
    public void setExternalURLReference(ExternalURLObjectType value) {
        this.externalURLReference = value;
    }

    /**
     * Gets the value of the integrationIDData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the integrationIDData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIntegrationIDData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExternalIntegrationIDDataType }
     * 
     * 
     */
    public List<ExternalIntegrationIDDataType> getIntegrationIDData() {
        if (integrationIDData == null) {
            integrationIDData = new ArrayList<ExternalIntegrationIDDataType>();
        }
        return this.integrationIDData;
    }

    /**
     * Sets the value of the integrationIDData property.
     * 
     * @param integrationIDData
     *     allowed object is
     *     {@link ExternalIntegrationIDDataType }
     *     
     */
    public void setIntegrationIDData(List<ExternalIntegrationIDDataType> integrationIDData) {
        this.integrationIDData = integrationIDData;
    }

}
