
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Criteria to get Loans
 * 
 * <p>Java class for Loan_Request_CriteriaType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Loan_Request_CriteriaType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Loan_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Customer_Reference" type="{urn:com.workday/bsvc}CustomerObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Property_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Loan_Vintage_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Loan_Vintage_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="First_Referral_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="First_Referral_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Referral_Type_Reference" type="{urn:com.workday/bsvc}Loan_Referral_TypeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Investor_Type_Reference" type="{urn:com.workday/bsvc}Loan_Investor_TypeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Country_Reference" type="{urn:com.workday/bsvc}CountryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Country_Region_Reference" type="{urn:com.workday/bsvc}Country_RegionObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Loan_Request_CriteriaType", propOrder = {
    "loanNumber",
    "customerReference",
    "propertyID",
    "loanVintageStartDate",
    "loanVintageEndDate",
    "firstReferralStartDate",
    "firstReferralEndDate",
    "referralTypeReference",
    "investorTypeReference",
    "countryReference",
    "countryRegionReference",
    "inactive"
})
public class LoanRequestCriteriaType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Loan_Number")
    protected String loanNumber;
    @XmlElement(name = "Customer_Reference")
    protected List<CustomerObjectType> customerReference;
    @XmlElement(name = "Property_ID")
    protected String propertyID;
    @XmlElement(name = "Loan_Vintage_Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar loanVintageStartDate;
    @XmlElement(name = "Loan_Vintage_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar loanVintageEndDate;
    @XmlElement(name = "First_Referral_Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar firstReferralStartDate;
    @XmlElement(name = "First_Referral_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar firstReferralEndDate;
    @XmlElement(name = "Referral_Type_Reference")
    protected List<LoanReferralTypeObjectType> referralTypeReference;
    @XmlElement(name = "Investor_Type_Reference")
    protected List<LoanInvestorTypeObjectType> investorTypeReference;
    @XmlElement(name = "Country_Reference")
    protected List<CountryObjectType> countryReference;
    @XmlElement(name = "Country_Region_Reference")
    protected List<CountryRegionObjectType> countryRegionReference;
    @XmlElement(name = "Inactive")
    protected Boolean inactive;

    /**
     * Gets the value of the loanNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLoanNumber() {
        return loanNumber;
    }

    /**
     * Sets the value of the loanNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLoanNumber(String value) {
        this.loanNumber = value;
    }

    /**
     * Gets the value of the customerReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the customerReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCustomerReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CustomerObjectType }
     * 
     * 
     */
    public List<CustomerObjectType> getCustomerReference() {
        if (customerReference == null) {
            customerReference = new ArrayList<CustomerObjectType>();
        }
        return this.customerReference;
    }

    /**
     * Gets the value of the propertyID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPropertyID() {
        return propertyID;
    }

    /**
     * Sets the value of the propertyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPropertyID(String value) {
        this.propertyID = value;
    }

    /**
     * Gets the value of the loanVintageStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getLoanVintageStartDate() {
        return loanVintageStartDate;
    }

    /**
     * Sets the value of the loanVintageStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setLoanVintageStartDate(XMLGregorianCalendar value) {
        this.loanVintageStartDate = value;
    }

    /**
     * Gets the value of the loanVintageEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getLoanVintageEndDate() {
        return loanVintageEndDate;
    }

    /**
     * Sets the value of the loanVintageEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setLoanVintageEndDate(XMLGregorianCalendar value) {
        this.loanVintageEndDate = value;
    }

    /**
     * Gets the value of the firstReferralStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getFirstReferralStartDate() {
        return firstReferralStartDate;
    }

    /**
     * Sets the value of the firstReferralStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setFirstReferralStartDate(XMLGregorianCalendar value) {
        this.firstReferralStartDate = value;
    }

    /**
     * Gets the value of the firstReferralEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getFirstReferralEndDate() {
        return firstReferralEndDate;
    }

    /**
     * Sets the value of the firstReferralEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setFirstReferralEndDate(XMLGregorianCalendar value) {
        this.firstReferralEndDate = value;
    }

    /**
     * Gets the value of the referralTypeReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the referralTypeReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReferralTypeReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LoanReferralTypeObjectType }
     * 
     * 
     */
    public List<LoanReferralTypeObjectType> getReferralTypeReference() {
        if (referralTypeReference == null) {
            referralTypeReference = new ArrayList<LoanReferralTypeObjectType>();
        }
        return this.referralTypeReference;
    }

    /**
     * Gets the value of the investorTypeReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the investorTypeReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInvestorTypeReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LoanInvestorTypeObjectType }
     * 
     * 
     */
    public List<LoanInvestorTypeObjectType> getInvestorTypeReference() {
        if (investorTypeReference == null) {
            investorTypeReference = new ArrayList<LoanInvestorTypeObjectType>();
        }
        return this.investorTypeReference;
    }

    /**
     * Gets the value of the countryReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the countryReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCountryReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CountryObjectType }
     * 
     * 
     */
    public List<CountryObjectType> getCountryReference() {
        if (countryReference == null) {
            countryReference = new ArrayList<CountryObjectType>();
        }
        return this.countryReference;
    }

    /**
     * Gets the value of the countryRegionReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the countryRegionReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCountryRegionReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CountryRegionObjectType }
     * 
     * 
     */
    public List<CountryRegionObjectType> getCountryRegionReference() {
        if (countryRegionReference == null) {
            countryRegionReference = new ArrayList<CountryRegionObjectType>();
        }
        return this.countryRegionReference;
    }

    /**
     * Gets the value of the inactive property.
     * This getter has been renamed from isInactive() to getInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getInactive() {
        return inactive;
    }

    /**
     * Sets the value of the inactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInactive(Boolean value) {
        this.inactive = value;
    }

    /**
     * Sets the value of the customerReference property.
     * 
     * @param customerReference
     *     allowed object is
     *     {@link CustomerObjectType }
     *     
     */
    public void setCustomerReference(List<CustomerObjectType> customerReference) {
        this.customerReference = customerReference;
    }

    /**
     * Sets the value of the referralTypeReference property.
     * 
     * @param referralTypeReference
     *     allowed object is
     *     {@link LoanReferralTypeObjectType }
     *     
     */
    public void setReferralTypeReference(List<LoanReferralTypeObjectType> referralTypeReference) {
        this.referralTypeReference = referralTypeReference;
    }

    /**
     * Sets the value of the investorTypeReference property.
     * 
     * @param investorTypeReference
     *     allowed object is
     *     {@link LoanInvestorTypeObjectType }
     *     
     */
    public void setInvestorTypeReference(List<LoanInvestorTypeObjectType> investorTypeReference) {
        this.investorTypeReference = investorTypeReference;
    }

    /**
     * Sets the value of the countryReference property.
     * 
     * @param countryReference
     *     allowed object is
     *     {@link CountryObjectType }
     *     
     */
    public void setCountryReference(List<CountryObjectType> countryReference) {
        this.countryReference = countryReference;
    }

    /**
     * Sets the value of the countryRegionReference property.
     * 
     * @param countryRegionReference
     *     allowed object is
     *     {@link CountryRegionObjectType }
     *     
     */
    public void setCountryRegionReference(List<CountryRegionObjectType> countryRegionReference) {
        this.countryRegionReference = countryRegionReference;
    }

}
