
package com.workday.financial;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Element containing all Loan Data.
 * 
 * <p>Java class for Loan_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Loan_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Loan_Number" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Customer_Reference" type="{urn:com.workday/bsvc}CustomerObjectType" minOccurs="0"/>
 *         &lt;element name="Vintage_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="First_Referral_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Property_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Referral_Type_Reference" type="{urn:com.workday/bsvc}Loan_Referral_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Investor_Type_Reference" type="{urn:com.workday/bsvc}Loan_Investor_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Country_Reference" type="{urn:com.workday/bsvc}CountryObjectType" minOccurs="0"/>
 *         &lt;element name="Country_Region_Reference" type="{urn:com.workday/bsvc}Country_RegionObjectType" minOccurs="0"/>
 *         &lt;element name="Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Loan_DataType", propOrder = {
    "loanNumber",
    "customerReference",
    "vintageDate",
    "firstReferralDate",
    "propertyID",
    "referralTypeReference",
    "investorTypeReference",
    "countryReference",
    "countryRegionReference",
    "inactive",
    "id"
})
public class LoanDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Loan_Number", required = true)
    protected String loanNumber;
    @XmlElement(name = "Customer_Reference")
    protected CustomerObjectType customerReference;
    @XmlElement(name = "Vintage_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar vintageDate;
    @XmlElement(name = "First_Referral_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar firstReferralDate;
    @XmlElement(name = "Property_ID")
    protected String propertyID;
    @XmlElement(name = "Referral_Type_Reference")
    protected LoanReferralTypeObjectType referralTypeReference;
    @XmlElement(name = "Investor_Type_Reference")
    protected LoanInvestorTypeObjectType investorTypeReference;
    @XmlElement(name = "Country_Reference")
    protected CountryObjectType countryReference;
    @XmlElement(name = "Country_Region_Reference")
    protected CountryRegionObjectType countryRegionReference;
    @XmlElement(name = "Inactive")
    protected Boolean inactive;
    @XmlElement(name = "ID")
    protected String id;

    /**
     * Gets the value of the loanNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLoanNumber() {
        return loanNumber;
    }

    /**
     * Sets the value of the loanNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLoanNumber(String value) {
        this.loanNumber = value;
    }

    /**
     * Gets the value of the customerReference property.
     * 
     * @return
     *     possible object is
     *     {@link CustomerObjectType }
     *     
     */
    public CustomerObjectType getCustomerReference() {
        return customerReference;
    }

    /**
     * Sets the value of the customerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CustomerObjectType }
     *     
     */
    public void setCustomerReference(CustomerObjectType value) {
        this.customerReference = value;
    }

    /**
     * Gets the value of the vintageDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getVintageDate() {
        return vintageDate;
    }

    /**
     * Sets the value of the vintageDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setVintageDate(XMLGregorianCalendar value) {
        this.vintageDate = value;
    }

    /**
     * Gets the value of the firstReferralDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getFirstReferralDate() {
        return firstReferralDate;
    }

    /**
     * Sets the value of the firstReferralDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setFirstReferralDate(XMLGregorianCalendar value) {
        this.firstReferralDate = value;
    }

    /**
     * Gets the value of the propertyID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPropertyID() {
        return propertyID;
    }

    /**
     * Sets the value of the propertyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPropertyID(String value) {
        this.propertyID = value;
    }

    /**
     * Gets the value of the referralTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link LoanReferralTypeObjectType }
     *     
     */
    public LoanReferralTypeObjectType getReferralTypeReference() {
        return referralTypeReference;
    }

    /**
     * Sets the value of the referralTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LoanReferralTypeObjectType }
     *     
     */
    public void setReferralTypeReference(LoanReferralTypeObjectType value) {
        this.referralTypeReference = value;
    }

    /**
     * Gets the value of the investorTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link LoanInvestorTypeObjectType }
     *     
     */
    public LoanInvestorTypeObjectType getInvestorTypeReference() {
        return investorTypeReference;
    }

    /**
     * Sets the value of the investorTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LoanInvestorTypeObjectType }
     *     
     */
    public void setInvestorTypeReference(LoanInvestorTypeObjectType value) {
        this.investorTypeReference = value;
    }

    /**
     * Gets the value of the countryReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryObjectType }
     *     
     */
    public CountryObjectType getCountryReference() {
        return countryReference;
    }

    /**
     * Sets the value of the countryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryObjectType }
     *     
     */
    public void setCountryReference(CountryObjectType value) {
        this.countryReference = value;
    }

    /**
     * Gets the value of the countryRegionReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryRegionObjectType }
     *     
     */
    public CountryRegionObjectType getCountryRegionReference() {
        return countryRegionReference;
    }

    /**
     * Sets the value of the countryRegionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryRegionObjectType }
     *     
     */
    public void setCountryRegionReference(CountryRegionObjectType value) {
        this.countryRegionReference = value;
    }

    /**
     * Gets the value of the inactive property.
     * This getter has been renamed from isInactive() to getInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getInactive() {
        return inactive;
    }

    /**
     * Sets the value of the inactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInactive(Boolean value) {
        this.inactive = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setID(String value) {
        this.id = value;
    }

}
