
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Wrapper Element that includes Ledger Account Summary Instance and Data
 * 
 * <p>Java class for Ledger_Account_Summary_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Ledger_Account_Summary_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Ledger_Account_Summary_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Ledger_Account_Summary_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Account_Set_Reference" type="{urn:com.workday/bsvc}Account_SetObjectType"/>
 *         &lt;element name="Hierarchy_Level_Reference" type="{urn:com.workday/bsvc}Hierarchy_LevelObjectType" minOccurs="0"/>
 *         &lt;element name="Ledger_Account_Summary_Reference" type="{urn:com.workday/bsvc}Ledger_Account_SummaryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Included_Ledger_Account_Reference" type="{urn:com.workday/bsvc}Ledger_AccountObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Included_Ledger_Account_Range_Data" type="{urn:com.workday/bsvc}Ledger_Account_Range_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Ledger_Account_Summary_DataType", propOrder = {
    "ledgerAccountSummaryID",
    "ledgerAccountSummaryName",
    "accountSetReference",
    "hierarchyLevelReference",
    "ledgerAccountSummaryReference",
    "includedLedgerAccountReference",
    "includedLedgerAccountRangeData"
})
public class LedgerAccountSummaryDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Ledger_Account_Summary_ID")
    protected String ledgerAccountSummaryID;
    @XmlElement(name = "Ledger_Account_Summary_Name", required = true)
    protected String ledgerAccountSummaryName;
    @XmlElement(name = "Account_Set_Reference", required = true)
    protected AccountSetObjectType accountSetReference;
    @XmlElement(name = "Hierarchy_Level_Reference")
    protected HierarchyLevelObjectType hierarchyLevelReference;
    @XmlElement(name = "Ledger_Account_Summary_Reference")
    protected List<LedgerAccountSummaryObjectType> ledgerAccountSummaryReference;
    @XmlElement(name = "Included_Ledger_Account_Reference")
    protected List<LedgerAccountObjectType> includedLedgerAccountReference;
    @XmlElement(name = "Included_Ledger_Account_Range_Data")
    protected List<LedgerAccountRangeDataType> includedLedgerAccountRangeData;

    /**
     * Gets the value of the ledgerAccountSummaryID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLedgerAccountSummaryID() {
        return ledgerAccountSummaryID;
    }

    /**
     * Sets the value of the ledgerAccountSummaryID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLedgerAccountSummaryID(String value) {
        this.ledgerAccountSummaryID = value;
    }

    /**
     * Gets the value of the ledgerAccountSummaryName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLedgerAccountSummaryName() {
        return ledgerAccountSummaryName;
    }

    /**
     * Sets the value of the ledgerAccountSummaryName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLedgerAccountSummaryName(String value) {
        this.ledgerAccountSummaryName = value;
    }

    /**
     * Gets the value of the accountSetReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountSetObjectType }
     *     
     */
    public AccountSetObjectType getAccountSetReference() {
        return accountSetReference;
    }

    /**
     * Sets the value of the accountSetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountSetObjectType }
     *     
     */
    public void setAccountSetReference(AccountSetObjectType value) {
        this.accountSetReference = value;
    }

    /**
     * Gets the value of the hierarchyLevelReference property.
     * 
     * @return
     *     possible object is
     *     {@link HierarchyLevelObjectType }
     *     
     */
    public HierarchyLevelObjectType getHierarchyLevelReference() {
        return hierarchyLevelReference;
    }

    /**
     * Sets the value of the hierarchyLevelReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link HierarchyLevelObjectType }
     *     
     */
    public void setHierarchyLevelReference(HierarchyLevelObjectType value) {
        this.hierarchyLevelReference = value;
    }

    /**
     * Gets the value of the ledgerAccountSummaryReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the ledgerAccountSummaryReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLedgerAccountSummaryReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LedgerAccountSummaryObjectType }
     * 
     * 
     */
    public List<LedgerAccountSummaryObjectType> getLedgerAccountSummaryReference() {
        if (ledgerAccountSummaryReference == null) {
            ledgerAccountSummaryReference = new ArrayList<LedgerAccountSummaryObjectType>();
        }
        return this.ledgerAccountSummaryReference;
    }

    /**
     * Gets the value of the includedLedgerAccountReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the includedLedgerAccountReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedLedgerAccountReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LedgerAccountObjectType }
     * 
     * 
     */
    public List<LedgerAccountObjectType> getIncludedLedgerAccountReference() {
        if (includedLedgerAccountReference == null) {
            includedLedgerAccountReference = new ArrayList<LedgerAccountObjectType>();
        }
        return this.includedLedgerAccountReference;
    }

    /**
     * Gets the value of the includedLedgerAccountRangeData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the includedLedgerAccountRangeData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedLedgerAccountRangeData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LedgerAccountRangeDataType }
     * 
     * 
     */
    public List<LedgerAccountRangeDataType> getIncludedLedgerAccountRangeData() {
        if (includedLedgerAccountRangeData == null) {
            includedLedgerAccountRangeData = new ArrayList<LedgerAccountRangeDataType>();
        }
        return this.includedLedgerAccountRangeData;
    }

    /**
     * Sets the value of the ledgerAccountSummaryReference property.
     * 
     * @param ledgerAccountSummaryReference
     *     allowed object is
     *     {@link LedgerAccountSummaryObjectType }
     *     
     */
    public void setLedgerAccountSummaryReference(List<LedgerAccountSummaryObjectType> ledgerAccountSummaryReference) {
        this.ledgerAccountSummaryReference = ledgerAccountSummaryReference;
    }

    /**
     * Sets the value of the includedLedgerAccountReference property.
     * 
     * @param includedLedgerAccountReference
     *     allowed object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public void setIncludedLedgerAccountReference(List<LedgerAccountObjectType> includedLedgerAccountReference) {
        this.includedLedgerAccountReference = includedLedgerAccountReference;
    }

    /**
     * Sets the value of the includedLedgerAccountRangeData property.
     * 
     * @param includedLedgerAccountRangeData
     *     allowed object is
     *     {@link LedgerAccountRangeDataType }
     *     
     */
    public void setIncludedLedgerAccountRangeData(List<LedgerAccountRangeDataType> includedLedgerAccountRangeData) {
        this.includedLedgerAccountRangeData = includedLedgerAccountRangeData;
    }

}
