
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Utilize the following element to find journal entries in the Workday system.
 * 
 * <p>Java class for Journal_Entry_Request_CriteriaType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Journal_Entry_Request_CriteriaType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Organization_Reference" type="{urn:com.workday/bsvc}OrganizationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Accounting_From_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Accounting_To_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Journal_Source_Reference" type="{urn:com.workday/bsvc}Journal_SourceObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Updated_From_Date" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="Updated_To_Date" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="Journal_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Status_Reference" type="{urn:com.workday/bsvc}Journal_Entry_StatusObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Originated_by_Person_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Approved_by_Person_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Ledger_Account_Reference" type="{urn:com.workday/bsvc}Ledger_AccountObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Worktags_Reference" type="{urn:com.workday/bsvc}Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Book_Reference" type="{urn:com.workday/bsvc}BookObjectType" minOccurs="0"/>
 *         &lt;element name="Adjustment_Journal" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Reversed_Journal" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Recurring_Journal" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Intercompany_Journal" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Threshold_Met" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Journal_Entry_Request_CriteriaType", propOrder = {
    "organizationReference",
    "accountingFromDate",
    "accountingToDate",
    "journalSourceReference",
    "updatedFromDate",
    "updatedToDate",
    "journalNumber",
    "statusReference",
    "originatedByPersonReference",
    "approvedByPersonReference",
    "ledgerAccountReference",
    "worktagsReference",
    "bookReference",
    "adjustmentJournal",
    "reversedJournal",
    "recurringJournal",
    "intercompanyJournal",
    "thresholdMet"
})
public class JournalEntryRequestCriteriaType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Organization_Reference")
    protected List<OrganizationObjectType> organizationReference;
    @XmlElement(name = "Accounting_From_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar accountingFromDate;
    @XmlElement(name = "Accounting_To_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar accountingToDate;
    @XmlElement(name = "Journal_Source_Reference")
    protected List<JournalSourceObjectType> journalSourceReference;
    @XmlElement(name = "Updated_From_Date")
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar updatedFromDate;
    @XmlElement(name = "Updated_To_Date")
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar updatedToDate;
    @XmlElement(name = "Journal_Number")
    protected String journalNumber;
    @XmlElement(name = "Status_Reference")
    protected List<JournalEntryStatusObjectType> statusReference;
    @XmlElement(name = "Originated_by_Person_Reference")
    protected List<UniqueIdentifierObjectType> originatedByPersonReference;
    @XmlElement(name = "Approved_by_Person_Reference")
    protected List<UniqueIdentifierObjectType> approvedByPersonReference;
    @XmlElement(name = "Ledger_Account_Reference")
    protected List<LedgerAccountObjectType> ledgerAccountReference;
    @XmlElement(name = "Worktags_Reference")
    protected List<AccountingWorktagObjectType> worktagsReference;
    @XmlElement(name = "Book_Reference")
    protected BookObjectType bookReference;
    @XmlElement(name = "Adjustment_Journal")
    protected Boolean adjustmentJournal;
    @XmlElement(name = "Reversed_Journal")
    protected Boolean reversedJournal;
    @XmlElement(name = "Recurring_Journal")
    protected Boolean recurringJournal;
    @XmlElement(name = "Intercompany_Journal")
    protected Boolean intercompanyJournal;
    @XmlElement(name = "Threshold_Met")
    protected Boolean thresholdMet;

    /**
     * Gets the value of the organizationReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the organizationReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOrganizationReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OrganizationObjectType }
     * 
     * 
     */
    public List<OrganizationObjectType> getOrganizationReference() {
        if (organizationReference == null) {
            organizationReference = new ArrayList<OrganizationObjectType>();
        }
        return this.organizationReference;
    }

    /**
     * Gets the value of the accountingFromDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getAccountingFromDate() {
        return accountingFromDate;
    }

    /**
     * Sets the value of the accountingFromDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setAccountingFromDate(XMLGregorianCalendar value) {
        this.accountingFromDate = value;
    }

    /**
     * Gets the value of the accountingToDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getAccountingToDate() {
        return accountingToDate;
    }

    /**
     * Sets the value of the accountingToDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setAccountingToDate(XMLGregorianCalendar value) {
        this.accountingToDate = value;
    }

    /**
     * Gets the value of the journalSourceReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the journalSourceReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJournalSourceReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JournalSourceObjectType }
     * 
     * 
     */
    public List<JournalSourceObjectType> getJournalSourceReference() {
        if (journalSourceReference == null) {
            journalSourceReference = new ArrayList<JournalSourceObjectType>();
        }
        return this.journalSourceReference;
    }

    /**
     * Gets the value of the updatedFromDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getUpdatedFromDate() {
        return updatedFromDate;
    }

    /**
     * Sets the value of the updatedFromDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setUpdatedFromDate(XMLGregorianCalendar value) {
        this.updatedFromDate = value;
    }

    /**
     * Gets the value of the updatedToDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getUpdatedToDate() {
        return updatedToDate;
    }

    /**
     * Sets the value of the updatedToDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setUpdatedToDate(XMLGregorianCalendar value) {
        this.updatedToDate = value;
    }

    /**
     * Gets the value of the journalNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJournalNumber() {
        return journalNumber;
    }

    /**
     * Sets the value of the journalNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJournalNumber(String value) {
        this.journalNumber = value;
    }

    /**
     * Gets the value of the statusReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the statusReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getStatusReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JournalEntryStatusObjectType }
     * 
     * 
     */
    public List<JournalEntryStatusObjectType> getStatusReference() {
        if (statusReference == null) {
            statusReference = new ArrayList<JournalEntryStatusObjectType>();
        }
        return this.statusReference;
    }

    /**
     * Gets the value of the originatedByPersonReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the originatedByPersonReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOriginatedByPersonReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UniqueIdentifierObjectType }
     * 
     * 
     */
    public List<UniqueIdentifierObjectType> getOriginatedByPersonReference() {
        if (originatedByPersonReference == null) {
            originatedByPersonReference = new ArrayList<UniqueIdentifierObjectType>();
        }
        return this.originatedByPersonReference;
    }

    /**
     * Gets the value of the approvedByPersonReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the approvedByPersonReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getApprovedByPersonReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UniqueIdentifierObjectType }
     * 
     * 
     */
    public List<UniqueIdentifierObjectType> getApprovedByPersonReference() {
        if (approvedByPersonReference == null) {
            approvedByPersonReference = new ArrayList<UniqueIdentifierObjectType>();
        }
        return this.approvedByPersonReference;
    }

    /**
     * Gets the value of the ledgerAccountReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the ledgerAccountReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLedgerAccountReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LedgerAccountObjectType }
     * 
     * 
     */
    public List<LedgerAccountObjectType> getLedgerAccountReference() {
        if (ledgerAccountReference == null) {
            ledgerAccountReference = new ArrayList<LedgerAccountObjectType>();
        }
        return this.ledgerAccountReference;
    }

    /**
     * Gets the value of the worktagsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the worktagsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorktagsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagObjectType }
     * 
     * 
     */
    public List<AccountingWorktagObjectType> getWorktagsReference() {
        if (worktagsReference == null) {
            worktagsReference = new ArrayList<AccountingWorktagObjectType>();
        }
        return this.worktagsReference;
    }

    /**
     * Gets the value of the bookReference property.
     * 
     * @return
     *     possible object is
     *     {@link BookObjectType }
     *     
     */
    public BookObjectType getBookReference() {
        return bookReference;
    }

    /**
     * Sets the value of the bookReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BookObjectType }
     *     
     */
    public void setBookReference(BookObjectType value) {
        this.bookReference = value;
    }

    /**
     * Gets the value of the adjustmentJournal property.
     * This getter has been renamed from isAdjustmentJournal() to getAdjustmentJournal() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAdjustmentJournal() {
        return adjustmentJournal;
    }

    /**
     * Sets the value of the adjustmentJournal property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAdjustmentJournal(Boolean value) {
        this.adjustmentJournal = value;
    }

    /**
     * Gets the value of the reversedJournal property.
     * This getter has been renamed from isReversedJournal() to getReversedJournal() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getReversedJournal() {
        return reversedJournal;
    }

    /**
     * Sets the value of the reversedJournal property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setReversedJournal(Boolean value) {
        this.reversedJournal = value;
    }

    /**
     * Gets the value of the recurringJournal property.
     * This getter has been renamed from isRecurringJournal() to getRecurringJournal() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getRecurringJournal() {
        return recurringJournal;
    }

    /**
     * Sets the value of the recurringJournal property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRecurringJournal(Boolean value) {
        this.recurringJournal = value;
    }

    /**
     * Gets the value of the intercompanyJournal property.
     * This getter has been renamed from isIntercompanyJournal() to getIntercompanyJournal() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIntercompanyJournal() {
        return intercompanyJournal;
    }

    /**
     * Sets the value of the intercompanyJournal property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIntercompanyJournal(Boolean value) {
        this.intercompanyJournal = value;
    }

    /**
     * Gets the value of the thresholdMet property.
     * This getter has been renamed from isThresholdMet() to getThresholdMet() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getThresholdMet() {
        return thresholdMet;
    }

    /**
     * Sets the value of the thresholdMet property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setThresholdMet(Boolean value) {
        this.thresholdMet = value;
    }

    /**
     * Sets the value of the organizationReference property.
     * 
     * @param organizationReference
     *     allowed object is
     *     {@link OrganizationObjectType }
     *     
     */
    public void setOrganizationReference(List<OrganizationObjectType> organizationReference) {
        this.organizationReference = organizationReference;
    }

    /**
     * Sets the value of the journalSourceReference property.
     * 
     * @param journalSourceReference
     *     allowed object is
     *     {@link JournalSourceObjectType }
     *     
     */
    public void setJournalSourceReference(List<JournalSourceObjectType> journalSourceReference) {
        this.journalSourceReference = journalSourceReference;
    }

    /**
     * Sets the value of the statusReference property.
     * 
     * @param statusReference
     *     allowed object is
     *     {@link JournalEntryStatusObjectType }
     *     
     */
    public void setStatusReference(List<JournalEntryStatusObjectType> statusReference) {
        this.statusReference = statusReference;
    }

    /**
     * Sets the value of the originatedByPersonReference property.
     * 
     * @param originatedByPersonReference
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setOriginatedByPersonReference(List<UniqueIdentifierObjectType> originatedByPersonReference) {
        this.originatedByPersonReference = originatedByPersonReference;
    }

    /**
     * Sets the value of the approvedByPersonReference property.
     * 
     * @param approvedByPersonReference
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setApprovedByPersonReference(List<UniqueIdentifierObjectType> approvedByPersonReference) {
        this.approvedByPersonReference = approvedByPersonReference;
    }

    /**
     * Sets the value of the ledgerAccountReference property.
     * 
     * @param ledgerAccountReference
     *     allowed object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public void setLedgerAccountReference(List<LedgerAccountObjectType> ledgerAccountReference) {
        this.ledgerAccountReference = ledgerAccountReference;
    }

    /**
     * Sets the value of the worktagsReference property.
     * 
     * @param worktagsReference
     *     allowed object is
     *     {@link AccountingWorktagObjectType }
     *     
     */
    public void setWorktagsReference(List<AccountingWorktagObjectType> worktagsReference) {
        this.worktagsReference = worktagsReference;
    }

}
