
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Element containing all Journal Entry Line data
 * 
 * <p>Java class for Journal_Entry_Line_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Journal_Entry_Line_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Line_Order" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Line_Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType" minOccurs="0"/>
 *         &lt;element name="Ledger_Account_Reference" type="{urn:com.workday/bsvc}Ledger_AccountObjectType"/>
 *         &lt;element name="Debit_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Credit_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Rate" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Ledger_Debit_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="3"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Ledger_Credit_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="3"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Budget_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Worktags_Reference" type="{urn:com.workday/bsvc}Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Balancing_Worktag_Affiliate_Reference" type="{urn:com.workday/bsvc}Balancing_WorktagObjectType" minOccurs="0"/>
 *         &lt;element name="Exclude_from_Spend_Report" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Journal_Entry_Line_DataType", propOrder = {
    "lineOrder",
    "lineCompanyReference",
    "ledgerAccountReference",
    "debitAmount",
    "creditAmount",
    "currencyReference",
    "currencyRate",
    "ledgerDebitAmount",
    "ledgerCreditAmount",
    "memo",
    "budgetDate",
    "worktagsReference",
    "balancingWorktagAffiliateReference",
    "excludeFromSpendReport"
})
public class JournalEntryLineDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Line_Order")
    protected String lineOrder;
    @XmlElement(name = "Line_Company_Reference")
    protected CompanyObjectType lineCompanyReference;
    @XmlElement(name = "Ledger_Account_Reference", required = true)
    protected LedgerAccountObjectType ledgerAccountReference;
    @XmlElement(name = "Debit_Amount")
    protected BigDecimal debitAmount;
    @XmlElement(name = "Credit_Amount")
    protected BigDecimal creditAmount;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Currency_Rate")
    protected BigDecimal currencyRate;
    @XmlElement(name = "Ledger_Debit_Amount")
    protected BigDecimal ledgerDebitAmount;
    @XmlElement(name = "Ledger_Credit_Amount")
    protected BigDecimal ledgerCreditAmount;
    @XmlElement(name = "Memo")
    protected String memo;
    @XmlElement(name = "Budget_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar budgetDate;
    @XmlElement(name = "Worktags_Reference")
    protected List<AccountingWorktagObjectType> worktagsReference;
    @XmlElement(name = "Balancing_Worktag_Affiliate_Reference")
    protected BalancingWorktagObjectType balancingWorktagAffiliateReference;
    @XmlElement(name = "Exclude_from_Spend_Report")
    protected Boolean excludeFromSpendReport;

    /**
     * Gets the value of the lineOrder property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLineOrder() {
        return lineOrder;
    }

    /**
     * Sets the value of the lineOrder property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLineOrder(String value) {
        this.lineOrder = value;
    }

    /**
     * Gets the value of the lineCompanyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getLineCompanyReference() {
        return lineCompanyReference;
    }

    /**
     * Sets the value of the lineCompanyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setLineCompanyReference(CompanyObjectType value) {
        this.lineCompanyReference = value;
    }

    /**
     * Gets the value of the ledgerAccountReference property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public LedgerAccountObjectType getLedgerAccountReference() {
        return ledgerAccountReference;
    }

    /**
     * Sets the value of the ledgerAccountReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public void setLedgerAccountReference(LedgerAccountObjectType value) {
        this.ledgerAccountReference = value;
    }

    /**
     * Gets the value of the debitAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getDebitAmount() {
        return debitAmount;
    }

    /**
     * Sets the value of the debitAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setDebitAmount(BigDecimal value) {
        this.debitAmount = value;
    }

    /**
     * Gets the value of the creditAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getCreditAmount() {
        return creditAmount;
    }

    /**
     * Sets the value of the creditAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setCreditAmount(BigDecimal value) {
        this.creditAmount = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the currencyRate property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getCurrencyRate() {
        return currencyRate;
    }

    /**
     * Sets the value of the currencyRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setCurrencyRate(BigDecimal value) {
        this.currencyRate = value;
    }

    /**
     * Gets the value of the ledgerDebitAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getLedgerDebitAmount() {
        return ledgerDebitAmount;
    }

    /**
     * Sets the value of the ledgerDebitAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setLedgerDebitAmount(BigDecimal value) {
        this.ledgerDebitAmount = value;
    }

    /**
     * Gets the value of the ledgerCreditAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getLedgerCreditAmount() {
        return ledgerCreditAmount;
    }

    /**
     * Sets the value of the ledgerCreditAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setLedgerCreditAmount(BigDecimal value) {
        this.ledgerCreditAmount = value;
    }

    /**
     * Gets the value of the memo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMemo() {
        return memo;
    }

    /**
     * Sets the value of the memo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMemo(String value) {
        this.memo = value;
    }

    /**
     * Gets the value of the budgetDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getBudgetDate() {
        return budgetDate;
    }

    /**
     * Sets the value of the budgetDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setBudgetDate(XMLGregorianCalendar value) {
        this.budgetDate = value;
    }

    /**
     * Gets the value of the worktagsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the worktagsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorktagsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagObjectType }
     * 
     * 
     */
    public List<AccountingWorktagObjectType> getWorktagsReference() {
        if (worktagsReference == null) {
            worktagsReference = new ArrayList<AccountingWorktagObjectType>();
        }
        return this.worktagsReference;
    }

    /**
     * Gets the value of the balancingWorktagAffiliateReference property.
     * 
     * @return
     *     possible object is
     *     {@link BalancingWorktagObjectType }
     *     
     */
    public BalancingWorktagObjectType getBalancingWorktagAffiliateReference() {
        return balancingWorktagAffiliateReference;
    }

    /**
     * Sets the value of the balancingWorktagAffiliateReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BalancingWorktagObjectType }
     *     
     */
    public void setBalancingWorktagAffiliateReference(BalancingWorktagObjectType value) {
        this.balancingWorktagAffiliateReference = value;
    }

    /**
     * Gets the value of the excludeFromSpendReport property.
     * This getter has been renamed from isExcludeFromSpendReport() to getExcludeFromSpendReport() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeFromSpendReport() {
        return excludeFromSpendReport;
    }

    /**
     * Sets the value of the excludeFromSpendReport property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeFromSpendReport(Boolean value) {
        this.excludeFromSpendReport = value;
    }

    /**
     * Sets the value of the worktagsReference property.
     * 
     * @param worktagsReference
     *     allowed object is
     *     {@link AccountingWorktagObjectType }
     *     
     */
    public void setWorktagsReference(List<AccountingWorktagObjectType> worktagsReference) {
        this.worktagsReference = worktagsReference;
    }

}
