
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Represents details of a Journal Entry
 * 
 * <p>Java class for Journal_Entry_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Journal_Entry_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Journal_Entry_Reference" type="{urn:com.workday/bsvc}Journal_EntryObjectType" minOccurs="0"/>
 *         &lt;element name="Journal_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Journal_Status_Reference" type="{urn:com.workday/bsvc}Journal_Entry_StatusObjectType" minOccurs="0"/>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Book_Code_Reference" type="{urn:com.workday/bsvc}Book_CodeObjectType" minOccurs="0"/>
 *         &lt;element name="Ledger_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Ledger_Period_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Accounting_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Journal_Source_Reference" type="{urn:com.workday/bsvc}Journal_SourceObjectType" minOccurs="0"/>
 *         &lt;element name="Balancing_Worktag_Reference" type="{urn:com.workday/bsvc}Balancing_WorktagObjectType" minOccurs="0"/>
 *         &lt;element name="Transaction_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Operational_Transaction_Reference" type="{urn:com.workday/bsvc}Operational_TransactionObjectType" minOccurs="0"/>
 *         &lt;element name="Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Originated_By_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Approved_by_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Total_Ledger_Debits" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Total_Ledger_Credits" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Reversed_By_Journal_Entry_Reference" type="{urn:com.workday/bsvc}Journal_EntryObjectType" minOccurs="0"/>
 *         &lt;element name="Reverses_Journal_Entry_Reference" type="{urn:com.workday/bsvc}Journal_EntryObjectType" minOccurs="0"/>
 *         &lt;element name="Creation_Date" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="Last_Updated_Date" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="Journal_Entry_Line_Data" type="{urn:com.workday/bsvc}Journal_Entry_Line_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Attachment_Data" type="{urn:com.workday/bsvc}Financials_Attachment_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Journal_Entry_DataType", propOrder = {
    "journalEntryReference",
    "journalNumber",
    "journalStatusReference",
    "companyReference",
    "currencyReference",
    "bookCodeReference",
    "ledgerReference",
    "ledgerPeriodReference",
    "accountingDate",
    "journalSourceReference",
    "balancingWorktagReference",
    "transactionDate",
    "operationalTransactionReference",
    "memo",
    "originatedByReference",
    "approvedByReference",
    "totalLedgerDebits",
    "totalLedgerCredits",
    "reversedByJournalEntryReference",
    "reversesJournalEntryReference",
    "creationDate",
    "lastUpdatedDate",
    "journalEntryLineData",
    "attachmentData"
})
public class JournalEntryDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Journal_Entry_Reference")
    protected JournalEntryObjectType journalEntryReference;
    @XmlElement(name = "Journal_Number")
    protected String journalNumber;
    @XmlElement(name = "Journal_Status_Reference")
    protected JournalEntryStatusObjectType journalStatusReference;
    @XmlElement(name = "Company_Reference")
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Book_Code_Reference")
    protected BookCodeObjectType bookCodeReference;
    @XmlElement(name = "Ledger_Reference")
    protected UniqueIdentifierObjectType ledgerReference;
    @XmlElement(name = "Ledger_Period_Reference")
    protected UniqueIdentifierObjectType ledgerPeriodReference;
    @XmlElement(name = "Accounting_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar accountingDate;
    @XmlElement(name = "Journal_Source_Reference")
    protected JournalSourceObjectType journalSourceReference;
    @XmlElement(name = "Balancing_Worktag_Reference")
    protected BalancingWorktagObjectType balancingWorktagReference;
    @XmlElement(name = "Transaction_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar transactionDate;
    @XmlElement(name = "Operational_Transaction_Reference")
    protected OperationalTransactionObjectType operationalTransactionReference;
    @XmlElement(name = "Memo")
    protected String memo;
    @XmlElement(name = "Originated_By_Reference")
    protected UniqueIdentifierObjectType originatedByReference;
    @XmlElement(name = "Approved_by_Reference")
    protected List<UniqueIdentifierObjectType> approvedByReference;
    @XmlElement(name = "Total_Ledger_Debits")
    protected BigDecimal totalLedgerDebits;
    @XmlElement(name = "Total_Ledger_Credits")
    protected BigDecimal totalLedgerCredits;
    @XmlElement(name = "Reversed_By_Journal_Entry_Reference")
    protected JournalEntryObjectType reversedByJournalEntryReference;
    @XmlElement(name = "Reverses_Journal_Entry_Reference")
    protected JournalEntryObjectType reversesJournalEntryReference;
    @XmlElement(name = "Creation_Date")
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar creationDate;
    @XmlElement(name = "Last_Updated_Date")
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar lastUpdatedDate;
    @XmlElement(name = "Journal_Entry_Line_Data")
    protected List<JournalEntryLineDataType> journalEntryLineData;
    @XmlElement(name = "Attachment_Data")
    protected List<FinancialsAttachmentDataType> attachmentData;

    /**
     * Gets the value of the journalEntryReference property.
     * 
     * @return
     *     possible object is
     *     {@link JournalEntryObjectType }
     *     
     */
    public JournalEntryObjectType getJournalEntryReference() {
        return journalEntryReference;
    }

    /**
     * Sets the value of the journalEntryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JournalEntryObjectType }
     *     
     */
    public void setJournalEntryReference(JournalEntryObjectType value) {
        this.journalEntryReference = value;
    }

    /**
     * Gets the value of the journalNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJournalNumber() {
        return journalNumber;
    }

    /**
     * Sets the value of the journalNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJournalNumber(String value) {
        this.journalNumber = value;
    }

    /**
     * Gets the value of the journalStatusReference property.
     * 
     * @return
     *     possible object is
     *     {@link JournalEntryStatusObjectType }
     *     
     */
    public JournalEntryStatusObjectType getJournalStatusReference() {
        return journalStatusReference;
    }

    /**
     * Sets the value of the journalStatusReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JournalEntryStatusObjectType }
     *     
     */
    public void setJournalStatusReference(JournalEntryStatusObjectType value) {
        this.journalStatusReference = value;
    }

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the bookCodeReference property.
     * 
     * @return
     *     possible object is
     *     {@link BookCodeObjectType }
     *     
     */
    public BookCodeObjectType getBookCodeReference() {
        return bookCodeReference;
    }

    /**
     * Sets the value of the bookCodeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BookCodeObjectType }
     *     
     */
    public void setBookCodeReference(BookCodeObjectType value) {
        this.bookCodeReference = value;
    }

    /**
     * Gets the value of the ledgerReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getLedgerReference() {
        return ledgerReference;
    }

    /**
     * Sets the value of the ledgerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setLedgerReference(UniqueIdentifierObjectType value) {
        this.ledgerReference = value;
    }

    /**
     * Gets the value of the ledgerPeriodReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getLedgerPeriodReference() {
        return ledgerPeriodReference;
    }

    /**
     * Sets the value of the ledgerPeriodReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setLedgerPeriodReference(UniqueIdentifierObjectType value) {
        this.ledgerPeriodReference = value;
    }

    /**
     * Gets the value of the accountingDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getAccountingDate() {
        return accountingDate;
    }

    /**
     * Sets the value of the accountingDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setAccountingDate(XMLGregorianCalendar value) {
        this.accountingDate = value;
    }

    /**
     * Gets the value of the journalSourceReference property.
     * 
     * @return
     *     possible object is
     *     {@link JournalSourceObjectType }
     *     
     */
    public JournalSourceObjectType getJournalSourceReference() {
        return journalSourceReference;
    }

    /**
     * Sets the value of the journalSourceReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JournalSourceObjectType }
     *     
     */
    public void setJournalSourceReference(JournalSourceObjectType value) {
        this.journalSourceReference = value;
    }

    /**
     * Gets the value of the balancingWorktagReference property.
     * 
     * @return
     *     possible object is
     *     {@link BalancingWorktagObjectType }
     *     
     */
    public BalancingWorktagObjectType getBalancingWorktagReference() {
        return balancingWorktagReference;
    }

    /**
     * Sets the value of the balancingWorktagReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BalancingWorktagObjectType }
     *     
     */
    public void setBalancingWorktagReference(BalancingWorktagObjectType value) {
        this.balancingWorktagReference = value;
    }

    /**
     * Gets the value of the transactionDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getTransactionDate() {
        return transactionDate;
    }

    /**
     * Sets the value of the transactionDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setTransactionDate(XMLGregorianCalendar value) {
        this.transactionDate = value;
    }

    /**
     * Gets the value of the operationalTransactionReference property.
     * 
     * @return
     *     possible object is
     *     {@link OperationalTransactionObjectType }
     *     
     */
    public OperationalTransactionObjectType getOperationalTransactionReference() {
        return operationalTransactionReference;
    }

    /**
     * Sets the value of the operationalTransactionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link OperationalTransactionObjectType }
     *     
     */
    public void setOperationalTransactionReference(OperationalTransactionObjectType value) {
        this.operationalTransactionReference = value;
    }

    /**
     * Gets the value of the memo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMemo() {
        return memo;
    }

    /**
     * Sets the value of the memo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMemo(String value) {
        this.memo = value;
    }

    /**
     * Gets the value of the originatedByReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getOriginatedByReference() {
        return originatedByReference;
    }

    /**
     * Sets the value of the originatedByReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setOriginatedByReference(UniqueIdentifierObjectType value) {
        this.originatedByReference = value;
    }

    /**
     * Gets the value of the approvedByReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the approvedByReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getApprovedByReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UniqueIdentifierObjectType }
     * 
     * 
     */
    public List<UniqueIdentifierObjectType> getApprovedByReference() {
        if (approvedByReference == null) {
            approvedByReference = new ArrayList<UniqueIdentifierObjectType>();
        }
        return this.approvedByReference;
    }

    /**
     * Gets the value of the totalLedgerDebits property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getTotalLedgerDebits() {
        return totalLedgerDebits;
    }

    /**
     * Sets the value of the totalLedgerDebits property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setTotalLedgerDebits(BigDecimal value) {
        this.totalLedgerDebits = value;
    }

    /**
     * Gets the value of the totalLedgerCredits property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getTotalLedgerCredits() {
        return totalLedgerCredits;
    }

    /**
     * Sets the value of the totalLedgerCredits property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setTotalLedgerCredits(BigDecimal value) {
        this.totalLedgerCredits = value;
    }

    /**
     * Gets the value of the reversedByJournalEntryReference property.
     * 
     * @return
     *     possible object is
     *     {@link JournalEntryObjectType }
     *     
     */
    public JournalEntryObjectType getReversedByJournalEntryReference() {
        return reversedByJournalEntryReference;
    }

    /**
     * Sets the value of the reversedByJournalEntryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JournalEntryObjectType }
     *     
     */
    public void setReversedByJournalEntryReference(JournalEntryObjectType value) {
        this.reversedByJournalEntryReference = value;
    }

    /**
     * Gets the value of the reversesJournalEntryReference property.
     * 
     * @return
     *     possible object is
     *     {@link JournalEntryObjectType }
     *     
     */
    public JournalEntryObjectType getReversesJournalEntryReference() {
        return reversesJournalEntryReference;
    }

    /**
     * Sets the value of the reversesJournalEntryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JournalEntryObjectType }
     *     
     */
    public void setReversesJournalEntryReference(JournalEntryObjectType value) {
        this.reversesJournalEntryReference = value;
    }

    /**
     * Gets the value of the creationDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCreationDate() {
        return creationDate;
    }

    /**
     * Sets the value of the creationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCreationDate(XMLGregorianCalendar value) {
        this.creationDate = value;
    }

    /**
     * Gets the value of the lastUpdatedDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getLastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * Sets the value of the lastUpdatedDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setLastUpdatedDate(XMLGregorianCalendar value) {
        this.lastUpdatedDate = value;
    }

    /**
     * Gets the value of the journalEntryLineData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the journalEntryLineData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJournalEntryLineData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JournalEntryLineDataType }
     * 
     * 
     */
    public List<JournalEntryLineDataType> getJournalEntryLineData() {
        if (journalEntryLineData == null) {
            journalEntryLineData = new ArrayList<JournalEntryLineDataType>();
        }
        return this.journalEntryLineData;
    }

    /**
     * Gets the value of the attachmentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the attachmentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttachmentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialsAttachmentDataType }
     * 
     * 
     */
    public List<FinancialsAttachmentDataType> getAttachmentData() {
        if (attachmentData == null) {
            attachmentData = new ArrayList<FinancialsAttachmentDataType>();
        }
        return this.attachmentData;
    }

    /**
     * Sets the value of the approvedByReference property.
     * 
     * @param approvedByReference
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setApprovedByReference(List<UniqueIdentifierObjectType> approvedByReference) {
        this.approvedByReference = approvedByReference;
    }

    /**
     * Sets the value of the journalEntryLineData property.
     * 
     * @param journalEntryLineData
     *     allowed object is
     *     {@link JournalEntryLineDataType }
     *     
     */
    public void setJournalEntryLineData(List<JournalEntryLineDataType> journalEntryLineData) {
        this.journalEntryLineData = journalEntryLineData;
    }

    /**
     * Sets the value of the attachmentData property.
     * 
     * @param attachmentData
     *     allowed object is
     *     {@link FinancialsAttachmentDataType }
     *     
     */
    public void setAttachmentData(List<FinancialsAttachmentDataType> attachmentData) {
        this.attachmentData = attachmentData;
    }

}
