
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Contains data for the Investor, including ID, Name, Contact Information, Settlement Bank Account, Alternate Names, and Attachment data.
 * 
 * <p>Java class for Investor_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Investor_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Investor_Reference_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Investor_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Tax_Authority_Form_Type_Reference" type="{urn:com.workday/bsvc}Tax_Authority_Form_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Investor_Is_1099_Payee" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Investor_Taxpayer_ID_Number_Type_Reference" type="{urn:com.workday/bsvc}Taxpayer_ID_Number_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Tax_Document_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Create_Investor_from_Customer_Reference" type="{urn:com.workday/bsvc}Billable_EntityObjectType" minOccurs="0"/>
 *           &lt;element name="Create_Investor_from_Financial_Institution_Reference" type="{urn:com.workday/bsvc}Financial_InstitutionObjectType" minOccurs="0"/>
 *           &lt;element name="Create_Investor_from_Supplier_Reference" type="{urn:com.workday/bsvc}SupplierObjectType" minOccurs="0"/>
 *           &lt;element name="Create_Investor_from_Tax_Authority_Reference" type="{urn:com.workday/bsvc}Tax_AuthorityObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Default_Payment_Type_Reference" type="{urn:com.workday/bsvc}Payment_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Investor_Security_Segment_Reference" type="{urn:com.workday/bsvc}Investor_Security_SegmentObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Business_Entity_Data" type="{urn:com.workday/bsvc}Business_Entity_WWS_DataType"/>
 *         &lt;element name="Settlement_Account_Data" type="{urn:com.workday/bsvc}Settlement_Account_WWS_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Alternate_Name_Data" type="{urn:com.workday/bsvc}Business_Entity_Alternate_Name_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Attachment_Data" type="{urn:com.workday/bsvc}Financials_Attachment_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Investor_DataType", propOrder = {
    "investorReferenceID",
    "investorName",
    "taxAuthorityFormTypeReference",
    "investorIs1099Payee",
    "investorTaxpayerIDNumberTypeReference",
    "taxDocumentDate",
    "createInvestorFromCustomerReference",
    "createInvestorFromFinancialInstitutionReference",
    "createInvestorFromSupplierReference",
    "createInvestorFromTaxAuthorityReference",
    "defaultPaymentTypeReference",
    "investorSecuritySegmentReference",
    "businessEntityData",
    "settlementAccountData",
    "alternateNameData",
    "attachmentData"
})
public class InvestorDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Investor_Reference_ID")
    protected String investorReferenceID;
    @XmlElement(name = "Investor_Name", required = true)
    protected String investorName;
    @XmlElement(name = "Tax_Authority_Form_Type_Reference")
    protected TaxAuthorityFormTypeObjectType taxAuthorityFormTypeReference;
    @XmlElement(name = "Investor_Is_1099_Payee")
    protected Boolean investorIs1099Payee;
    @XmlElement(name = "Investor_Taxpayer_ID_Number_Type_Reference")
    protected TaxpayerIDNumberTypeObjectType investorTaxpayerIDNumberTypeReference;
    @XmlElement(name = "Tax_Document_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar taxDocumentDate;
    @XmlElement(name = "Create_Investor_from_Customer_Reference")
    protected BillableEntityObjectType createInvestorFromCustomerReference;
    @XmlElement(name = "Create_Investor_from_Financial_Institution_Reference")
    protected FinancialInstitutionObjectType createInvestorFromFinancialInstitutionReference;
    @XmlElement(name = "Create_Investor_from_Supplier_Reference")
    protected SupplierObjectType createInvestorFromSupplierReference;
    @XmlElement(name = "Create_Investor_from_Tax_Authority_Reference")
    protected TaxAuthorityObjectType createInvestorFromTaxAuthorityReference;
    @XmlElement(name = "Default_Payment_Type_Reference")
    protected PaymentTypeObjectType defaultPaymentTypeReference;
    @XmlElement(name = "Investor_Security_Segment_Reference")
    protected List<InvestorSecuritySegmentObjectType> investorSecuritySegmentReference;
    @XmlElement(name = "Business_Entity_Data", required = true)
    protected BusinessEntityWWSDataType businessEntityData;
    @XmlElement(name = "Settlement_Account_Data")
    protected List<SettlementAccountWWSDataType> settlementAccountData;
    @XmlElement(name = "Alternate_Name_Data")
    protected List<BusinessEntityAlternateNameDataType> alternateNameData;
    @XmlElement(name = "Attachment_Data")
    protected List<FinancialsAttachmentDataType> attachmentData;

    /**
     * Gets the value of the investorReferenceID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInvestorReferenceID() {
        return investorReferenceID;
    }

    /**
     * Sets the value of the investorReferenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInvestorReferenceID(String value) {
        this.investorReferenceID = value;
    }

    /**
     * Gets the value of the investorName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInvestorName() {
        return investorName;
    }

    /**
     * Sets the value of the investorName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInvestorName(String value) {
        this.investorName = value;
    }

    /**
     * Gets the value of the taxAuthorityFormTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link TaxAuthorityFormTypeObjectType }
     *     
     */
    public TaxAuthorityFormTypeObjectType getTaxAuthorityFormTypeReference() {
        return taxAuthorityFormTypeReference;
    }

    /**
     * Sets the value of the taxAuthorityFormTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxAuthorityFormTypeObjectType }
     *     
     */
    public void setTaxAuthorityFormTypeReference(TaxAuthorityFormTypeObjectType value) {
        this.taxAuthorityFormTypeReference = value;
    }

    /**
     * Gets the value of the investorIs1099Payee property.
     * This getter has been renamed from isInvestorIs1099Payee() to getInvestorIs1099Payee() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getInvestorIs1099Payee() {
        return investorIs1099Payee;
    }

    /**
     * Sets the value of the investorIs1099Payee property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInvestorIs1099Payee(Boolean value) {
        this.investorIs1099Payee = value;
    }

    /**
     * Gets the value of the investorTaxpayerIDNumberTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link TaxpayerIDNumberTypeObjectType }
     *     
     */
    public TaxpayerIDNumberTypeObjectType getInvestorTaxpayerIDNumberTypeReference() {
        return investorTaxpayerIDNumberTypeReference;
    }

    /**
     * Sets the value of the investorTaxpayerIDNumberTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxpayerIDNumberTypeObjectType }
     *     
     */
    public void setInvestorTaxpayerIDNumberTypeReference(TaxpayerIDNumberTypeObjectType value) {
        this.investorTaxpayerIDNumberTypeReference = value;
    }

    /**
     * Gets the value of the taxDocumentDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getTaxDocumentDate() {
        return taxDocumentDate;
    }

    /**
     * Sets the value of the taxDocumentDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setTaxDocumentDate(XMLGregorianCalendar value) {
        this.taxDocumentDate = value;
    }

    /**
     * Gets the value of the createInvestorFromCustomerReference property.
     * 
     * @return
     *     possible object is
     *     {@link BillableEntityObjectType }
     *     
     */
    public BillableEntityObjectType getCreateInvestorFromCustomerReference() {
        return createInvestorFromCustomerReference;
    }

    /**
     * Sets the value of the createInvestorFromCustomerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BillableEntityObjectType }
     *     
     */
    public void setCreateInvestorFromCustomerReference(BillableEntityObjectType value) {
        this.createInvestorFromCustomerReference = value;
    }

    /**
     * Gets the value of the createInvestorFromFinancialInstitutionReference property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialInstitutionObjectType }
     *     
     */
    public FinancialInstitutionObjectType getCreateInvestorFromFinancialInstitutionReference() {
        return createInvestorFromFinancialInstitutionReference;
    }

    /**
     * Sets the value of the createInvestorFromFinancialInstitutionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialInstitutionObjectType }
     *     
     */
    public void setCreateInvestorFromFinancialInstitutionReference(FinancialInstitutionObjectType value) {
        this.createInvestorFromFinancialInstitutionReference = value;
    }

    /**
     * Gets the value of the createInvestorFromSupplierReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupplierObjectType }
     *     
     */
    public SupplierObjectType getCreateInvestorFromSupplierReference() {
        return createInvestorFromSupplierReference;
    }

    /**
     * Sets the value of the createInvestorFromSupplierReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplierObjectType }
     *     
     */
    public void setCreateInvestorFromSupplierReference(SupplierObjectType value) {
        this.createInvestorFromSupplierReference = value;
    }

    /**
     * Gets the value of the createInvestorFromTaxAuthorityReference property.
     * 
     * @return
     *     possible object is
     *     {@link TaxAuthorityObjectType }
     *     
     */
    public TaxAuthorityObjectType getCreateInvestorFromTaxAuthorityReference() {
        return createInvestorFromTaxAuthorityReference;
    }

    /**
     * Sets the value of the createInvestorFromTaxAuthorityReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxAuthorityObjectType }
     *     
     */
    public void setCreateInvestorFromTaxAuthorityReference(TaxAuthorityObjectType value) {
        this.createInvestorFromTaxAuthorityReference = value;
    }

    /**
     * Gets the value of the defaultPaymentTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentTypeObjectType }
     *     
     */
    public PaymentTypeObjectType getDefaultPaymentTypeReference() {
        return defaultPaymentTypeReference;
    }

    /**
     * Sets the value of the defaultPaymentTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentTypeObjectType }
     *     
     */
    public void setDefaultPaymentTypeReference(PaymentTypeObjectType value) {
        this.defaultPaymentTypeReference = value;
    }

    /**
     * Gets the value of the investorSecuritySegmentReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the investorSecuritySegmentReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInvestorSecuritySegmentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link InvestorSecuritySegmentObjectType }
     * 
     * 
     */
    public List<InvestorSecuritySegmentObjectType> getInvestorSecuritySegmentReference() {
        if (investorSecuritySegmentReference == null) {
            investorSecuritySegmentReference = new ArrayList<InvestorSecuritySegmentObjectType>();
        }
        return this.investorSecuritySegmentReference;
    }

    /**
     * Gets the value of the businessEntityData property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessEntityWWSDataType }
     *     
     */
    public BusinessEntityWWSDataType getBusinessEntityData() {
        return businessEntityData;
    }

    /**
     * Sets the value of the businessEntityData property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessEntityWWSDataType }
     *     
     */
    public void setBusinessEntityData(BusinessEntityWWSDataType value) {
        this.businessEntityData = value;
    }

    /**
     * Gets the value of the settlementAccountData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the settlementAccountData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSettlementAccountData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SettlementAccountWWSDataType }
     * 
     * 
     */
    public List<SettlementAccountWWSDataType> getSettlementAccountData() {
        if (settlementAccountData == null) {
            settlementAccountData = new ArrayList<SettlementAccountWWSDataType>();
        }
        return this.settlementAccountData;
    }

    /**
     * Gets the value of the alternateNameData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the alternateNameData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAlternateNameData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BusinessEntityAlternateNameDataType }
     * 
     * 
     */
    public List<BusinessEntityAlternateNameDataType> getAlternateNameData() {
        if (alternateNameData == null) {
            alternateNameData = new ArrayList<BusinessEntityAlternateNameDataType>();
        }
        return this.alternateNameData;
    }

    /**
     * Gets the value of the attachmentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the attachmentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttachmentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialsAttachmentDataType }
     * 
     * 
     */
    public List<FinancialsAttachmentDataType> getAttachmentData() {
        if (attachmentData == null) {
            attachmentData = new ArrayList<FinancialsAttachmentDataType>();
        }
        return this.attachmentData;
    }

    /**
     * Sets the value of the investorSecuritySegmentReference property.
     * 
     * @param investorSecuritySegmentReference
     *     allowed object is
     *     {@link InvestorSecuritySegmentObjectType }
     *     
     */
    public void setInvestorSecuritySegmentReference(List<InvestorSecuritySegmentObjectType> investorSecuritySegmentReference) {
        this.investorSecuritySegmentReference = investorSecuritySegmentReference;
    }

    /**
     * Sets the value of the settlementAccountData property.
     * 
     * @param settlementAccountData
     *     allowed object is
     *     {@link SettlementAccountWWSDataType }
     *     
     */
    public void setSettlementAccountData(List<SettlementAccountWWSDataType> settlementAccountData) {
        this.settlementAccountData = settlementAccountData;
    }

    /**
     * Sets the value of the alternateNameData property.
     * 
     * @param alternateNameData
     *     allowed object is
     *     {@link BusinessEntityAlternateNameDataType }
     *     
     */
    public void setAlternateNameData(List<BusinessEntityAlternateNameDataType> alternateNameData) {
        this.alternateNameData = alternateNameData;
    }

    /**
     * Sets the value of the attachmentData property.
     * 
     * @param attachmentData
     *     allowed object is
     *     {@link FinancialsAttachmentDataType }
     *     
     */
    public void setAttachmentData(List<FinancialsAttachmentDataType> attachmentData) {
        this.attachmentData = attachmentData;
    }

}
