
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Income Distribution Amount Rule Data.
 * 
 * <p>Java class for Income_Distribution_Amount_Rule_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Income_Distribution_Amount_Rule_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Order" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *               &lt;maxLength value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Worktag_Reference" type="{urn:com.workday/bsvc}Audited_Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Income_Distribution_Amount_Rule_DataType", propOrder = {
    "order",
    "amount",
    "worktagReference"
})
public class IncomeDistributionAmountRuleDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Order")
    protected String order;
    @XmlElement(name = "Amount")
    protected BigDecimal amount;
    @XmlElement(name = "Worktag_Reference")
    protected List<AuditedAccountingWorktagObjectType> worktagReference;

    /**
     * Gets the value of the order property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrder() {
        return order;
    }

    /**
     * Sets the value of the order property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrder(String value) {
        this.order = value;
    }

    /**
     * Gets the value of the amount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /**
     * Sets the value of the amount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    /**
     * Gets the value of the worktagReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the worktagReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorktagReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AuditedAccountingWorktagObjectType }
     * 
     * 
     */
    public List<AuditedAccountingWorktagObjectType> getWorktagReference() {
        if (worktagReference == null) {
            worktagReference = new ArrayList<AuditedAccountingWorktagObjectType>();
        }
        return this.worktagReference;
    }

    /**
     * Sets the value of the worktagReference property.
     * 
     * @param worktagReference
     *     allowed object is
     *     {@link AuditedAccountingWorktagObjectType }
     *     
     */
    public void setWorktagReference(List<AuditedAccountingWorktagObjectType> worktagReference) {
        this.worktagReference = worktagReference;
    }

}
