
package com.workday.financial;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains data for creating or updating Budget Details, also called the Budget Entry data.  A unique instance of the Budget Details is identified by the Reference ID or the Budget Period.  A Budget period is identified by the Budget (Budget type and the Company) and the Fiscal Period (Fiscal Year and Company's Fiscal Schedule and Fiscal Posting Interval ie: 2009-Jan).
 * 
 * <p>Java class for Import_Budget_Details_RequestType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Import_Budget_Details_RequestType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Budget_Details_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Budget_Details_Data" type="{urn:com.workday/bsvc}Budget_Details__HV__DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="Add_Only" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       &lt;attribute ref="{urn:com.workday/bsvc}version"/>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Import_Budget_Details_RequestType", propOrder = {
    "budgetDetailsReference",
    "budgetDetailsData"
})
public class ImportBudgetDetailsRequestType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Budget_Details_Reference")
    protected UniqueIdentifierObjectType budgetDetailsReference;
    @XmlElement(name = "Budget_Details_Data")
    protected BudgetDetailsHVDataType budgetDetailsData;
    @XmlAttribute(name = "Add_Only", namespace = "urn:com.workday/bsvc")
    protected Boolean addOnly;
    @XmlAttribute(name = "version", namespace = "urn:com.workday/bsvc")
    protected String version;

    /**
     * Gets the value of the budgetDetailsReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getBudgetDetailsReference() {
        return budgetDetailsReference;
    }

    /**
     * Sets the value of the budgetDetailsReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setBudgetDetailsReference(UniqueIdentifierObjectType value) {
        this.budgetDetailsReference = value;
    }

    /**
     * Gets the value of the budgetDetailsData property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetDetailsHVDataType }
     *     
     */
    public BudgetDetailsHVDataType getBudgetDetailsData() {
        return budgetDetailsData;
    }

    /**
     * Sets the value of the budgetDetailsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetDetailsHVDataType }
     *     
     */
    public void setBudgetDetailsData(BudgetDetailsHVDataType value) {
        this.budgetDetailsData = value;
    }

    /**
     * Gets the value of the addOnly property.
     * This getter has been renamed from isAddOnly() to getAddOnly() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAddOnly() {
        return addOnly;
    }

    /**
     * Sets the value of the addOnly property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAddOnly(Boolean value) {
        this.addOnly = value;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

}
