
package com.workday.financial;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains data for creating a Accounting Journal and submitting for business processing
 * 
 * <p>Java class for Import_Accounting_Journal_RequestType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Import_Accounting_Journal_RequestType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Accounting_Journal_Reference" type="{urn:com.workday/bsvc}Accounting_JournalObjectType" minOccurs="0"/>
 *         &lt;element name="Business_Process_Parameters" type="{urn:com.workday/bsvc}Financials_Business_Process_ParametersType" minOccurs="0"/>
 *         &lt;element name="Accounting_Journal_Data" type="{urn:com.workday/bsvc}Accounting_Journal__HV__DataType"/>
 *       &lt;/sequence>
 *       &lt;attribute name="Add_Only" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       &lt;attribute name="Create_Journal_with_Errors" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       &lt;attribute ref="{urn:com.workday/bsvc}version"/>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Import_Accounting_Journal_RequestType", propOrder = {
    "accountingJournalReference",
    "businessProcessParameters",
    "accountingJournalData"
})
public class ImportAccountingJournalRequestType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Accounting_Journal_Reference")
    protected AccountingJournalObjectType accountingJournalReference;
    @XmlElement(name = "Business_Process_Parameters")
    protected FinancialsBusinessProcessParametersType businessProcessParameters;
    @XmlElement(name = "Accounting_Journal_Data", required = true)
    protected AccountingJournalHVDataType accountingJournalData;
    @XmlAttribute(name = "Add_Only", namespace = "urn:com.workday/bsvc")
    protected Boolean addOnly;
    @XmlAttribute(name = "Create_Journal_with_Errors", namespace = "urn:com.workday/bsvc")
    protected Boolean createJournalWithErrors;
    @XmlAttribute(name = "version", namespace = "urn:com.workday/bsvc")
    protected String version;

    /**
     * Gets the value of the accountingJournalReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountingJournalObjectType }
     *     
     */
    public AccountingJournalObjectType getAccountingJournalReference() {
        return accountingJournalReference;
    }

    /**
     * Sets the value of the accountingJournalReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountingJournalObjectType }
     *     
     */
    public void setAccountingJournalReference(AccountingJournalObjectType value) {
        this.accountingJournalReference = value;
    }

    /**
     * Gets the value of the businessProcessParameters property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialsBusinessProcessParametersType }
     *     
     */
    public FinancialsBusinessProcessParametersType getBusinessProcessParameters() {
        return businessProcessParameters;
    }

    /**
     * Sets the value of the businessProcessParameters property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialsBusinessProcessParametersType }
     *     
     */
    public void setBusinessProcessParameters(FinancialsBusinessProcessParametersType value) {
        this.businessProcessParameters = value;
    }

    /**
     * Gets the value of the accountingJournalData property.
     * 
     * @return
     *     possible object is
     *     {@link AccountingJournalHVDataType }
     *     
     */
    public AccountingJournalHVDataType getAccountingJournalData() {
        return accountingJournalData;
    }

    /**
     * Sets the value of the accountingJournalData property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountingJournalHVDataType }
     *     
     */
    public void setAccountingJournalData(AccountingJournalHVDataType value) {
        this.accountingJournalData = value;
    }

    /**
     * Gets the value of the addOnly property.
     * This getter has been renamed from isAddOnly() to getAddOnly() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAddOnly() {
        return addOnly;
    }

    /**
     * Sets the value of the addOnly property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAddOnly(Boolean value) {
        this.addOnly = value;
    }

    /**
     * Gets the value of the createJournalWithErrors property.
     * This getter has been renamed from isCreateJournalWithErrors() to getCreateJournalWithErrors() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getCreateJournalWithErrors() {
        return createJournalWithErrors;
    }

    /**
     * Sets the value of the createJournalWithErrors property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCreateJournalWithErrors(Boolean value) {
        this.createJournalWithErrors = value;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

}
