
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Grant Hierarchy data. Allows for grant hierarchy name and relevant information to be added
 * 
 * <p>Java class for Grant_Hierarchy_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Grant_Hierarchy_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Grant_Hierarchy_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Grant_Hierarchy_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Include_Grant_Hierarchy_ID_in_Name" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Grant_Hierarchy_is_Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Organization_Subtype_Reference" type="{urn:com.workday/bsvc}Organization_SubtypeObjectType" minOccurs="0"/>
 *         &lt;element name="Superior_Grant_Hierarchy_Reference" type="{urn:com.workday/bsvc}Grant_HierarchyObjectType" minOccurs="0"/>
 *         &lt;element name="Included_Grant_Reference" type="{urn:com.workday/bsvc}GrantObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Grant_Hierarchy_DataType", propOrder = {
    "grantHierarchyID",
    "grantHierarchyName",
    "includeGrantHierarchyIDInName",
    "grantHierarchyIsInactive",
    "organizationSubtypeReference",
    "superiorGrantHierarchyReference",
    "includedGrantReference"
})
public class GrantHierarchyDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Grant_Hierarchy_ID")
    protected String grantHierarchyID;
    @XmlElement(name = "Grant_Hierarchy_Name", required = true)
    protected String grantHierarchyName;
    @XmlElement(name = "Include_Grant_Hierarchy_ID_in_Name")
    protected Boolean includeGrantHierarchyIDInName;
    @XmlElement(name = "Grant_Hierarchy_is_Inactive")
    protected Boolean grantHierarchyIsInactive;
    @XmlElement(name = "Organization_Subtype_Reference")
    protected OrganizationSubtypeObjectType organizationSubtypeReference;
    @XmlElement(name = "Superior_Grant_Hierarchy_Reference")
    protected GrantHierarchyObjectType superiorGrantHierarchyReference;
    @XmlElement(name = "Included_Grant_Reference")
    protected List<GrantObjectType> includedGrantReference;

    /**
     * Gets the value of the grantHierarchyID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGrantHierarchyID() {
        return grantHierarchyID;
    }

    /**
     * Sets the value of the grantHierarchyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGrantHierarchyID(String value) {
        this.grantHierarchyID = value;
    }

    /**
     * Gets the value of the grantHierarchyName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGrantHierarchyName() {
        return grantHierarchyName;
    }

    /**
     * Sets the value of the grantHierarchyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGrantHierarchyName(String value) {
        this.grantHierarchyName = value;
    }

    /**
     * Gets the value of the includeGrantHierarchyIDInName property.
     * This getter has been renamed from isIncludeGrantHierarchyIDInName() to getIncludeGrantHierarchyIDInName() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeGrantHierarchyIDInName() {
        return includeGrantHierarchyIDInName;
    }

    /**
     * Sets the value of the includeGrantHierarchyIDInName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeGrantHierarchyIDInName(Boolean value) {
        this.includeGrantHierarchyIDInName = value;
    }

    /**
     * Gets the value of the grantHierarchyIsInactive property.
     * This getter has been renamed from isGrantHierarchyIsInactive() to getGrantHierarchyIsInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getGrantHierarchyIsInactive() {
        return grantHierarchyIsInactive;
    }

    /**
     * Sets the value of the grantHierarchyIsInactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setGrantHierarchyIsInactive(Boolean value) {
        this.grantHierarchyIsInactive = value;
    }

    /**
     * Gets the value of the organizationSubtypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public OrganizationSubtypeObjectType getOrganizationSubtypeReference() {
        return organizationSubtypeReference;
    }

    /**
     * Sets the value of the organizationSubtypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public void setOrganizationSubtypeReference(OrganizationSubtypeObjectType value) {
        this.organizationSubtypeReference = value;
    }

    /**
     * Gets the value of the superiorGrantHierarchyReference property.
     * 
     * @return
     *     possible object is
     *     {@link GrantHierarchyObjectType }
     *     
     */
    public GrantHierarchyObjectType getSuperiorGrantHierarchyReference() {
        return superiorGrantHierarchyReference;
    }

    /**
     * Sets the value of the superiorGrantHierarchyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link GrantHierarchyObjectType }
     *     
     */
    public void setSuperiorGrantHierarchyReference(GrantHierarchyObjectType value) {
        this.superiorGrantHierarchyReference = value;
    }

    /**
     * Gets the value of the includedGrantReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the includedGrantReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedGrantReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GrantObjectType }
     * 
     * 
     */
    public List<GrantObjectType> getIncludedGrantReference() {
        if (includedGrantReference == null) {
            includedGrantReference = new ArrayList<GrantObjectType>();
        }
        return this.includedGrantReference;
    }

    /**
     * Sets the value of the includedGrantReference property.
     * 
     * @param includedGrantReference
     *     allowed object is
     *     {@link GrantObjectType }
     *     
     */
    public void setIncludedGrantReference(List<GrantObjectType> includedGrantReference) {
        this.includedGrantReference = includedGrantReference;
    }

}
