
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Wrapper Element that includes Gift Hierarchy and Data
 * 
 * <p>Java class for Gift_Hierarchy_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Gift_Hierarchy_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Include_Gift_Hierarchy_ID_in_Name" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Organization_Subtype_Reference" type="{urn:com.workday/bsvc}Organization_SubtypeObjectType" minOccurs="0"/>
 *         &lt;element name="Superior_Gift_Hierarchy_Reference" type="{urn:com.workday/bsvc}Gift_HierarchyObjectType" minOccurs="0"/>
 *         &lt;element name="Gift_Reference" type="{urn:com.workday/bsvc}GiftObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Gift_Hierarchy_DataType", propOrder = {
    "id",
    "name",
    "includeGiftHierarchyIDInName",
    "inactive",
    "organizationSubtypeReference",
    "superiorGiftHierarchyReference",
    "giftReference"
})
public class GiftHierarchyDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "ID")
    protected String id;
    @XmlElement(name = "Name", required = true)
    protected String name;
    @XmlElement(name = "Include_Gift_Hierarchy_ID_in_Name")
    protected Boolean includeGiftHierarchyIDInName;
    @XmlElement(name = "Inactive")
    protected Boolean inactive;
    @XmlElement(name = "Organization_Subtype_Reference")
    protected OrganizationSubtypeObjectType organizationSubtypeReference;
    @XmlElement(name = "Superior_Gift_Hierarchy_Reference")
    protected GiftHierarchyObjectType superiorGiftHierarchyReference;
    @XmlElement(name = "Gift_Reference")
    protected List<GiftObjectType> giftReference;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setID(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the includeGiftHierarchyIDInName property.
     * This getter has been renamed from isIncludeGiftHierarchyIDInName() to getIncludeGiftHierarchyIDInName() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeGiftHierarchyIDInName() {
        return includeGiftHierarchyIDInName;
    }

    /**
     * Sets the value of the includeGiftHierarchyIDInName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeGiftHierarchyIDInName(Boolean value) {
        this.includeGiftHierarchyIDInName = value;
    }

    /**
     * Gets the value of the inactive property.
     * This getter has been renamed from isInactive() to getInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getInactive() {
        return inactive;
    }

    /**
     * Sets the value of the inactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInactive(Boolean value) {
        this.inactive = value;
    }

    /**
     * Gets the value of the organizationSubtypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public OrganizationSubtypeObjectType getOrganizationSubtypeReference() {
        return organizationSubtypeReference;
    }

    /**
     * Sets the value of the organizationSubtypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public void setOrganizationSubtypeReference(OrganizationSubtypeObjectType value) {
        this.organizationSubtypeReference = value;
    }

    /**
     * Gets the value of the superiorGiftHierarchyReference property.
     * 
     * @return
     *     possible object is
     *     {@link GiftHierarchyObjectType }
     *     
     */
    public GiftHierarchyObjectType getSuperiorGiftHierarchyReference() {
        return superiorGiftHierarchyReference;
    }

    /**
     * Sets the value of the superiorGiftHierarchyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link GiftHierarchyObjectType }
     *     
     */
    public void setSuperiorGiftHierarchyReference(GiftHierarchyObjectType value) {
        this.superiorGiftHierarchyReference = value;
    }

    /**
     * Gets the value of the giftReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the giftReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGiftReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GiftObjectType }
     * 
     * 
     */
    public List<GiftObjectType> getGiftReference() {
        if (giftReference == null) {
            giftReference = new ArrayList<GiftObjectType>();
        }
        return this.giftReference;
    }

    /**
     * Sets the value of the giftReference property.
     * 
     * @param giftReference
     *     allowed object is
     *     {@link GiftObjectType }
     *     
     */
    public void setGiftReference(List<GiftObjectType> giftReference) {
        this.giftReference = giftReference;
    }

}
