
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Element containing all Gift Data.
 * 
 * <p>Java class for Gift_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Gift_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Submit" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Gift_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Include_Gift_ID_in_Name" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Investment_Pool_Reference" type="{urn:com.workday/bsvc}Investment_PoolObjectType"/>
 *         &lt;element name="Gift_Type_Reference" type="{urn:com.workday/bsvc}Gift_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Gift_Purpose_Reference" type="{urn:com.workday/bsvc}Gift_PurposeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Administrative_Fee_Applies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Restriction_Description" type="{urn:com.workday/bsvc}RichText" minOccurs="0"/>
 *         &lt;element name="Related_Worktag_Reference" type="{urn:com.workday/bsvc}Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Purchase_Worktag_Reference" type="{urn:com.workday/bsvc}Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Reinvestment_Worktag_Reference" type="{urn:com.workday/bsvc}Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Mandatory_Reinvestment" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Reinvestment_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Reinvestment_Percent" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Until_Principal_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Until_Reinvestment_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Income_Distribution_Rule_Data" type="{urn:com.workday/bsvc}Income_Distribution_Rule_DataType" minOccurs="0"/>
 *         &lt;element name="Attachment_Data" type="{urn:com.workday/bsvc}Financials_Attachment_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Gift_DataType", propOrder = {
    "id",
    "submit",
    "giftName",
    "includeGiftIDInName",
    "investmentPoolReference",
    "giftTypeReference",
    "giftPurposeReference",
    "administrativeFeeApplies",
    "restrictionDescription",
    "relatedWorktagReference",
    "purchaseWorktagReference",
    "reinvestmentWorktagReference",
    "mandatoryReinvestment",
    "reinvestmentAmount",
    "reinvestmentPercent",
    "untilPrincipalAmount",
    "untilReinvestmentDate",
    "incomeDistributionRuleData",
    "attachmentData"
})
public class GiftDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "ID")
    protected String id;
    @XmlElement(name = "Submit")
    protected Boolean submit;
    @XmlElement(name = "Gift_Name", required = true)
    protected String giftName;
    @XmlElement(name = "Include_Gift_ID_in_Name")
    protected Boolean includeGiftIDInName;
    @XmlElement(name = "Investment_Pool_Reference", required = true)
    protected InvestmentPoolObjectType investmentPoolReference;
    @XmlElement(name = "Gift_Type_Reference")
    protected GiftTypeObjectType giftTypeReference;
    @XmlElement(name = "Gift_Purpose_Reference")
    protected List<GiftPurposeObjectType> giftPurposeReference;
    @XmlElement(name = "Administrative_Fee_Applies")
    protected Boolean administrativeFeeApplies;
    @XmlElement(name = "Restriction_Description")
    protected String restrictionDescription;
    @XmlElement(name = "Related_Worktag_Reference")
    protected List<AccountingWorktagObjectType> relatedWorktagReference;
    @XmlElement(name = "Purchase_Worktag_Reference")
    protected List<AccountingWorktagObjectType> purchaseWorktagReference;
    @XmlElement(name = "Reinvestment_Worktag_Reference")
    protected List<AccountingWorktagObjectType> reinvestmentWorktagReference;
    @XmlElement(name = "Mandatory_Reinvestment")
    protected Boolean mandatoryReinvestment;
    @XmlElement(name = "Reinvestment_Amount")
    protected BigDecimal reinvestmentAmount;
    @XmlElement(name = "Reinvestment_Percent")
    protected BigDecimal reinvestmentPercent;
    @XmlElement(name = "Until_Principal_Amount")
    protected BigDecimal untilPrincipalAmount;
    @XmlElement(name = "Until_Reinvestment_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar untilReinvestmentDate;
    @XmlElement(name = "Income_Distribution_Rule_Data")
    protected IncomeDistributionRuleDataType incomeDistributionRuleData;
    @XmlElement(name = "Attachment_Data")
    protected List<FinancialsAttachmentDataType> attachmentData;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setID(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the submit property.
     * This getter has been renamed from isSubmit() to getSubmit() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getSubmit() {
        return submit;
    }

    /**
     * Sets the value of the submit property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setSubmit(Boolean value) {
        this.submit = value;
    }

    /**
     * Gets the value of the giftName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGiftName() {
        return giftName;
    }

    /**
     * Sets the value of the giftName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGiftName(String value) {
        this.giftName = value;
    }

    /**
     * Gets the value of the includeGiftIDInName property.
     * This getter has been renamed from isIncludeGiftIDInName() to getIncludeGiftIDInName() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeGiftIDInName() {
        return includeGiftIDInName;
    }

    /**
     * Sets the value of the includeGiftIDInName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeGiftIDInName(Boolean value) {
        this.includeGiftIDInName = value;
    }

    /**
     * Gets the value of the investmentPoolReference property.
     * 
     * @return
     *     possible object is
     *     {@link InvestmentPoolObjectType }
     *     
     */
    public InvestmentPoolObjectType getInvestmentPoolReference() {
        return investmentPoolReference;
    }

    /**
     * Sets the value of the investmentPoolReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link InvestmentPoolObjectType }
     *     
     */
    public void setInvestmentPoolReference(InvestmentPoolObjectType value) {
        this.investmentPoolReference = value;
    }

    /**
     * Gets the value of the giftTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link GiftTypeObjectType }
     *     
     */
    public GiftTypeObjectType getGiftTypeReference() {
        return giftTypeReference;
    }

    /**
     * Sets the value of the giftTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link GiftTypeObjectType }
     *     
     */
    public void setGiftTypeReference(GiftTypeObjectType value) {
        this.giftTypeReference = value;
    }

    /**
     * Gets the value of the giftPurposeReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the giftPurposeReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGiftPurposeReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GiftPurposeObjectType }
     * 
     * 
     */
    public List<GiftPurposeObjectType> getGiftPurposeReference() {
        if (giftPurposeReference == null) {
            giftPurposeReference = new ArrayList<GiftPurposeObjectType>();
        }
        return this.giftPurposeReference;
    }

    /**
     * Gets the value of the administrativeFeeApplies property.
     * This getter has been renamed from isAdministrativeFeeApplies() to getAdministrativeFeeApplies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAdministrativeFeeApplies() {
        return administrativeFeeApplies;
    }

    /**
     * Sets the value of the administrativeFeeApplies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAdministrativeFeeApplies(Boolean value) {
        this.administrativeFeeApplies = value;
    }

    /**
     * Gets the value of the restrictionDescription property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRestrictionDescription() {
        return restrictionDescription;
    }

    /**
     * Sets the value of the restrictionDescription property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRestrictionDescription(String value) {
        this.restrictionDescription = value;
    }

    /**
     * Gets the value of the relatedWorktagReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the relatedWorktagReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRelatedWorktagReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagObjectType }
     * 
     * 
     */
    public List<AccountingWorktagObjectType> getRelatedWorktagReference() {
        if (relatedWorktagReference == null) {
            relatedWorktagReference = new ArrayList<AccountingWorktagObjectType>();
        }
        return this.relatedWorktagReference;
    }

    /**
     * Gets the value of the purchaseWorktagReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the purchaseWorktagReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPurchaseWorktagReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagObjectType }
     * 
     * 
     */
    public List<AccountingWorktagObjectType> getPurchaseWorktagReference() {
        if (purchaseWorktagReference == null) {
            purchaseWorktagReference = new ArrayList<AccountingWorktagObjectType>();
        }
        return this.purchaseWorktagReference;
    }

    /**
     * Gets the value of the reinvestmentWorktagReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the reinvestmentWorktagReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReinvestmentWorktagReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagObjectType }
     * 
     * 
     */
    public List<AccountingWorktagObjectType> getReinvestmentWorktagReference() {
        if (reinvestmentWorktagReference == null) {
            reinvestmentWorktagReference = new ArrayList<AccountingWorktagObjectType>();
        }
        return this.reinvestmentWorktagReference;
    }

    /**
     * Gets the value of the mandatoryReinvestment property.
     * This getter has been renamed from isMandatoryReinvestment() to getMandatoryReinvestment() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getMandatoryReinvestment() {
        return mandatoryReinvestment;
    }

    /**
     * Sets the value of the mandatoryReinvestment property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setMandatoryReinvestment(Boolean value) {
        this.mandatoryReinvestment = value;
    }

    /**
     * Gets the value of the reinvestmentAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getReinvestmentAmount() {
        return reinvestmentAmount;
    }

    /**
     * Sets the value of the reinvestmentAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setReinvestmentAmount(BigDecimal value) {
        this.reinvestmentAmount = value;
    }

    /**
     * Gets the value of the reinvestmentPercent property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getReinvestmentPercent() {
        return reinvestmentPercent;
    }

    /**
     * Sets the value of the reinvestmentPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setReinvestmentPercent(BigDecimal value) {
        this.reinvestmentPercent = value;
    }

    /**
     * Gets the value of the untilPrincipalAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getUntilPrincipalAmount() {
        return untilPrincipalAmount;
    }

    /**
     * Sets the value of the untilPrincipalAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setUntilPrincipalAmount(BigDecimal value) {
        this.untilPrincipalAmount = value;
    }

    /**
     * Gets the value of the untilReinvestmentDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getUntilReinvestmentDate() {
        return untilReinvestmentDate;
    }

    /**
     * Sets the value of the untilReinvestmentDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setUntilReinvestmentDate(XMLGregorianCalendar value) {
        this.untilReinvestmentDate = value;
    }

    /**
     * Gets the value of the incomeDistributionRuleData property.
     * 
     * @return
     *     possible object is
     *     {@link IncomeDistributionRuleDataType }
     *     
     */
    public IncomeDistributionRuleDataType getIncomeDistributionRuleData() {
        return incomeDistributionRuleData;
    }

    /**
     * Sets the value of the incomeDistributionRuleData property.
     * 
     * @param value
     *     allowed object is
     *     {@link IncomeDistributionRuleDataType }
     *     
     */
    public void setIncomeDistributionRuleData(IncomeDistributionRuleDataType value) {
        this.incomeDistributionRuleData = value;
    }

    /**
     * Gets the value of the attachmentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the attachmentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttachmentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialsAttachmentDataType }
     * 
     * 
     */
    public List<FinancialsAttachmentDataType> getAttachmentData() {
        if (attachmentData == null) {
            attachmentData = new ArrayList<FinancialsAttachmentDataType>();
        }
        return this.attachmentData;
    }

    /**
     * Sets the value of the giftPurposeReference property.
     * 
     * @param giftPurposeReference
     *     allowed object is
     *     {@link GiftPurposeObjectType }
     *     
     */
    public void setGiftPurposeReference(List<GiftPurposeObjectType> giftPurposeReference) {
        this.giftPurposeReference = giftPurposeReference;
    }

    /**
     * Sets the value of the relatedWorktagReference property.
     * 
     * @param relatedWorktagReference
     *     allowed object is
     *     {@link AccountingWorktagObjectType }
     *     
     */
    public void setRelatedWorktagReference(List<AccountingWorktagObjectType> relatedWorktagReference) {
        this.relatedWorktagReference = relatedWorktagReference;
    }

    /**
     * Sets the value of the purchaseWorktagReference property.
     * 
     * @param purchaseWorktagReference
     *     allowed object is
     *     {@link AccountingWorktagObjectType }
     *     
     */
    public void setPurchaseWorktagReference(List<AccountingWorktagObjectType> purchaseWorktagReference) {
        this.purchaseWorktagReference = purchaseWorktagReference;
    }

    /**
     * Sets the value of the reinvestmentWorktagReference property.
     * 
     * @param reinvestmentWorktagReference
     *     allowed object is
     *     {@link AccountingWorktagObjectType }
     *     
     */
    public void setReinvestmentWorktagReference(List<AccountingWorktagObjectType> reinvestmentWorktagReference) {
        this.reinvestmentWorktagReference = reinvestmentWorktagReference;
    }

    /**
     * Sets the value of the attachmentData property.
     * 
     * @param attachmentData
     *     allowed object is
     *     {@link FinancialsAttachmentDataType }
     *     
     */
    public void setAttachmentData(List<FinancialsAttachmentDataType> attachmentData) {
        this.attachmentData = attachmentData;
    }

}
