
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains request reference, criteria, filter and response group for getting Object Class Set data
 * 
 * <p>Java class for Get_Object_Class_Sets_RequestType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Get_Object_Class_Sets_RequestType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;choice>
 *           &lt;element name="Request_References" type="{urn:com.workday/bsvc}Object_Class_Set_Request_ReferencesType" maxOccurs="unbounded" minOccurs="0"/>
 *           &lt;element name="Request_Criteria" type="{urn:com.workday/bsvc}Object_Class_Set_Request_CriteriaType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Response_Filter" type="{urn:com.workday/bsvc}Response_FilterType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute ref="{urn:com.workday/bsvc}version"/>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Get_Object_Class_Sets_RequestType", propOrder = {
    "requestReferences",
    "requestCriteria",
    "responseFilter"
})
public class GetObjectClassSetsRequestType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Request_References")
    protected List<ObjectClassSetRequestReferencesType> requestReferences;
    @XmlElement(name = "Request_Criteria")
    protected List<ObjectClassSetRequestCriteriaType> requestCriteria;
    @XmlElement(name = "Response_Filter")
    protected List<ResponseFilterType> responseFilter;
    @XmlAttribute(name = "version", namespace = "urn:com.workday/bsvc")
    protected String version;

    /**
     * Gets the value of the requestReferences property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the requestReferences property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRequestReferences().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ObjectClassSetRequestReferencesType }
     * 
     * 
     */
    public List<ObjectClassSetRequestReferencesType> getRequestReferences() {
        if (requestReferences == null) {
            requestReferences = new ArrayList<ObjectClassSetRequestReferencesType>();
        }
        return this.requestReferences;
    }

    /**
     * Gets the value of the requestCriteria property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the requestCriteria property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRequestCriteria().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ObjectClassSetRequestCriteriaType }
     * 
     * 
     */
    public List<ObjectClassSetRequestCriteriaType> getRequestCriteria() {
        if (requestCriteria == null) {
            requestCriteria = new ArrayList<ObjectClassSetRequestCriteriaType>();
        }
        return this.requestCriteria;
    }

    /**
     * Gets the value of the responseFilter property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the responseFilter property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getResponseFilter().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResponseFilterType }
     * 
     * 
     */
    public List<ResponseFilterType> getResponseFilter() {
        if (responseFilter == null) {
            responseFilter = new ArrayList<ResponseFilterType>();
        }
        return this.responseFilter;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

    /**
     * Sets the value of the requestReferences property.
     * 
     * @param requestReferences
     *     allowed object is
     *     {@link ObjectClassSetRequestReferencesType }
     *     
     */
    public void setRequestReferences(List<ObjectClassSetRequestReferencesType> requestReferences) {
        this.requestReferences = requestReferences;
    }

    /**
     * Sets the value of the requestCriteria property.
     * 
     * @param requestCriteria
     *     allowed object is
     *     {@link ObjectClassSetRequestCriteriaType }
     *     
     */
    public void setRequestCriteria(List<ObjectClassSetRequestCriteriaType> requestCriteria) {
        this.requestCriteria = requestCriteria;
    }

    /**
     * Sets the value of the responseFilter property.
     * 
     * @param responseFilter
     *     allowed object is
     *     {@link ResponseFilterType }
     *     
     */
    public void setResponseFilter(List<ResponseFilterType> responseFilter) {
        this.responseFilter = responseFilter;
    }

}
