
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * General Payment Search Criteria
 * 
 * <p>Java class for General_Payment_CriteriaType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="General_Payment_CriteriaType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}OrganizationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Bank_Account_Reference" type="{urn:com.workday/bsvc}Financial_AccountObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Payment_Category_Reference" type="{urn:com.workday/bsvc}Payment_CategoryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Payee_Reference" type="{urn:com.workday/bsvc}PayeeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Payee_Hierarchy_Reference" type="{urn:com.workday/bsvc}HierarchyObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Payment_Type_Reference" type="{urn:com.workday/bsvc}Payment_TypeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Payment_Status_Reference" type="{urn:com.workday/bsvc}Payment_StatusObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Customer_Supplier_Status_Reference" type="{urn:com.workday/bsvc}Business_Entity_Status_ValueObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Payment_Date_on_Date_Or_After" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Payment_Date_on_Date_Or_Before" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Transaction_Reference_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Settlement_Run_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Settlement_Run_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Settlement_Run_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Created_by_Worker_Reference" type="{urn:com.workday/bsvc}WorkerObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Payment_Amount_Equal_To" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Payment_Amount_Greater_Than" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Payment_Amount_Less_Than" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Expense_Payee_Type_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Transaction_Is_Intercompany" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Company_Receiving_Payment_Reference" type="{urn:com.workday/bsvc}CompanyObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Periods_Reference" type="{urn:com.workday/bsvc}PeriodObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Pay_Run_Groups_and_or_Pay_Groups_Reference" type="{urn:com.workday/bsvc}Pay_Run_Group_SelectionObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="EFT_Payment_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Reconciliation_Status_Reference" type="{urn:com.workday/bsvc}Reconciliation_StatusObjectType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "General_Payment_CriteriaType", propOrder = {
    "companyReference",
    "bankAccountReference",
    "paymentCategoryReference",
    "payeeReference",
    "payeeHierarchyReference",
    "paymentTypeReference",
    "paymentStatusReference",
    "customerSupplierStatusReference",
    "currencyReference",
    "paymentDateOnDateOrAfter",
    "paymentDateOnDateOrBefore",
    "transactionReferenceNumber",
    "settlementRunReference",
    "settlementRunNumber",
    "settlementRunName",
    "createdByWorkerReference",
    "paymentAmountEqualTo",
    "paymentAmountGreaterThan",
    "paymentAmountLessThan",
    "expensePayeeTypeReference",
    "transactionIsIntercompany",
    "companyReceivingPaymentReference",
    "periodsReference",
    "payRunGroupsAndOrPayGroupsReference",
    "eftPaymentID",
    "reconciliationStatusReference"
})
public class GeneralPaymentCriteriaType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Company_Reference")
    protected List<OrganizationObjectType> companyReference;
    @XmlElement(name = "Bank_Account_Reference")
    protected List<FinancialAccountObjectType> bankAccountReference;
    @XmlElement(name = "Payment_Category_Reference")
    protected List<PaymentCategoryObjectType> paymentCategoryReference;
    @XmlElement(name = "Payee_Reference")
    protected List<PayeeObjectType> payeeReference;
    @XmlElement(name = "Payee_Hierarchy_Reference")
    protected List<HierarchyObjectType> payeeHierarchyReference;
    @XmlElement(name = "Payment_Type_Reference")
    protected List<PaymentTypeObjectType> paymentTypeReference;
    @XmlElement(name = "Payment_Status_Reference")
    protected List<PaymentStatusObjectType> paymentStatusReference;
    @XmlElement(name = "Customer_Supplier_Status_Reference")
    protected List<BusinessEntityStatusValueObjectType> customerSupplierStatusReference;
    @XmlElement(name = "Currency_Reference")
    protected List<CurrencyObjectType> currencyReference;
    @XmlElement(name = "Payment_Date_on_Date_Or_After")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar paymentDateOnDateOrAfter;
    @XmlElement(name = "Payment_Date_on_Date_Or_Before")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar paymentDateOnDateOrBefore;
    @XmlElement(name = "Transaction_Reference_Number")
    protected String transactionReferenceNumber;
    @XmlElement(name = "Settlement_Run_Reference")
    protected List<UniqueIdentifierObjectType> settlementRunReference;
    @XmlElement(name = "Settlement_Run_Number")
    protected String settlementRunNumber;
    @XmlElement(name = "Settlement_Run_Name")
    protected String settlementRunName;
    @XmlElement(name = "Created_by_Worker_Reference")
    protected List<WorkerObjectType> createdByWorkerReference;
    @XmlElement(name = "Payment_Amount_Equal_To")
    protected BigDecimal paymentAmountEqualTo;
    @XmlElement(name = "Payment_Amount_Greater_Than")
    protected BigDecimal paymentAmountGreaterThan;
    @XmlElement(name = "Payment_Amount_Less_Than")
    protected BigDecimal paymentAmountLessThan;
    @XmlElement(name = "Expense_Payee_Type_Reference")
    protected List<UniqueIdentifierObjectType> expensePayeeTypeReference;
    @XmlElement(name = "Transaction_Is_Intercompany")
    protected Boolean transactionIsIntercompany;
    @XmlElement(name = "Company_Receiving_Payment_Reference")
    protected List<CompanyObjectType> companyReceivingPaymentReference;
    @XmlElement(name = "Periods_Reference")
    protected List<PeriodObjectType> periodsReference;
    @XmlElement(name = "Pay_Run_Groups_and_or_Pay_Groups_Reference")
    protected List<PayRunGroupSelectionObjectType> payRunGroupsAndOrPayGroupsReference;
    @XmlElement(name = "EFT_Payment_ID")
    protected String eftPaymentID;
    @XmlElement(name = "Reconciliation_Status_Reference")
    protected ReconciliationStatusObjectType reconciliationStatusReference;

    /**
     * Gets the value of the companyReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the companyReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCompanyReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OrganizationObjectType }
     * 
     * 
     */
    public List<OrganizationObjectType> getCompanyReference() {
        if (companyReference == null) {
            companyReference = new ArrayList<OrganizationObjectType>();
        }
        return this.companyReference;
    }

    /**
     * Gets the value of the bankAccountReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the bankAccountReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBankAccountReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialAccountObjectType }
     * 
     * 
     */
    public List<FinancialAccountObjectType> getBankAccountReference() {
        if (bankAccountReference == null) {
            bankAccountReference = new ArrayList<FinancialAccountObjectType>();
        }
        return this.bankAccountReference;
    }

    /**
     * Gets the value of the paymentCategoryReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the paymentCategoryReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPaymentCategoryReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PaymentCategoryObjectType }
     * 
     * 
     */
    public List<PaymentCategoryObjectType> getPaymentCategoryReference() {
        if (paymentCategoryReference == null) {
            paymentCategoryReference = new ArrayList<PaymentCategoryObjectType>();
        }
        return this.paymentCategoryReference;
    }

    /**
     * Gets the value of the payeeReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the payeeReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayeeReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayeeObjectType }
     * 
     * 
     */
    public List<PayeeObjectType> getPayeeReference() {
        if (payeeReference == null) {
            payeeReference = new ArrayList<PayeeObjectType>();
        }
        return this.payeeReference;
    }

    /**
     * Gets the value of the payeeHierarchyReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the payeeHierarchyReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayeeHierarchyReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link HierarchyObjectType }
     * 
     * 
     */
    public List<HierarchyObjectType> getPayeeHierarchyReference() {
        if (payeeHierarchyReference == null) {
            payeeHierarchyReference = new ArrayList<HierarchyObjectType>();
        }
        return this.payeeHierarchyReference;
    }

    /**
     * Gets the value of the paymentTypeReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the paymentTypeReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPaymentTypeReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PaymentTypeObjectType }
     * 
     * 
     */
    public List<PaymentTypeObjectType> getPaymentTypeReference() {
        if (paymentTypeReference == null) {
            paymentTypeReference = new ArrayList<PaymentTypeObjectType>();
        }
        return this.paymentTypeReference;
    }

    /**
     * Gets the value of the paymentStatusReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the paymentStatusReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPaymentStatusReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PaymentStatusObjectType }
     * 
     * 
     */
    public List<PaymentStatusObjectType> getPaymentStatusReference() {
        if (paymentStatusReference == null) {
            paymentStatusReference = new ArrayList<PaymentStatusObjectType>();
        }
        return this.paymentStatusReference;
    }

    /**
     * Gets the value of the customerSupplierStatusReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the customerSupplierStatusReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCustomerSupplierStatusReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BusinessEntityStatusValueObjectType }
     * 
     * 
     */
    public List<BusinessEntityStatusValueObjectType> getCustomerSupplierStatusReference() {
        if (customerSupplierStatusReference == null) {
            customerSupplierStatusReference = new ArrayList<BusinessEntityStatusValueObjectType>();
        }
        return this.customerSupplierStatusReference;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the currencyReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCurrencyReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CurrencyObjectType }
     * 
     * 
     */
    public List<CurrencyObjectType> getCurrencyReference() {
        if (currencyReference == null) {
            currencyReference = new ArrayList<CurrencyObjectType>();
        }
        return this.currencyReference;
    }

    /**
     * Gets the value of the paymentDateOnDateOrAfter property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getPaymentDateOnDateOrAfter() {
        return paymentDateOnDateOrAfter;
    }

    /**
     * Sets the value of the paymentDateOnDateOrAfter property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setPaymentDateOnDateOrAfter(XMLGregorianCalendar value) {
        this.paymentDateOnDateOrAfter = value;
    }

    /**
     * Gets the value of the paymentDateOnDateOrBefore property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getPaymentDateOnDateOrBefore() {
        return paymentDateOnDateOrBefore;
    }

    /**
     * Sets the value of the paymentDateOnDateOrBefore property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setPaymentDateOnDateOrBefore(XMLGregorianCalendar value) {
        this.paymentDateOnDateOrBefore = value;
    }

    /**
     * Gets the value of the transactionReferenceNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTransactionReferenceNumber() {
        return transactionReferenceNumber;
    }

    /**
     * Sets the value of the transactionReferenceNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTransactionReferenceNumber(String value) {
        this.transactionReferenceNumber = value;
    }

    /**
     * Gets the value of the settlementRunReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the settlementRunReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSettlementRunReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UniqueIdentifierObjectType }
     * 
     * 
     */
    public List<UniqueIdentifierObjectType> getSettlementRunReference() {
        if (settlementRunReference == null) {
            settlementRunReference = new ArrayList<UniqueIdentifierObjectType>();
        }
        return this.settlementRunReference;
    }

    /**
     * Gets the value of the settlementRunNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSettlementRunNumber() {
        return settlementRunNumber;
    }

    /**
     * Sets the value of the settlementRunNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSettlementRunNumber(String value) {
        this.settlementRunNumber = value;
    }

    /**
     * Gets the value of the settlementRunName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSettlementRunName() {
        return settlementRunName;
    }

    /**
     * Sets the value of the settlementRunName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSettlementRunName(String value) {
        this.settlementRunName = value;
    }

    /**
     * Gets the value of the createdByWorkerReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the createdByWorkerReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCreatedByWorkerReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkerObjectType }
     * 
     * 
     */
    public List<WorkerObjectType> getCreatedByWorkerReference() {
        if (createdByWorkerReference == null) {
            createdByWorkerReference = new ArrayList<WorkerObjectType>();
        }
        return this.createdByWorkerReference;
    }

    /**
     * Gets the value of the paymentAmountEqualTo property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPaymentAmountEqualTo() {
        return paymentAmountEqualTo;
    }

    /**
     * Sets the value of the paymentAmountEqualTo property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPaymentAmountEqualTo(BigDecimal value) {
        this.paymentAmountEqualTo = value;
    }

    /**
     * Gets the value of the paymentAmountGreaterThan property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPaymentAmountGreaterThan() {
        return paymentAmountGreaterThan;
    }

    /**
     * Sets the value of the paymentAmountGreaterThan property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPaymentAmountGreaterThan(BigDecimal value) {
        this.paymentAmountGreaterThan = value;
    }

    /**
     * Gets the value of the paymentAmountLessThan property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPaymentAmountLessThan() {
        return paymentAmountLessThan;
    }

    /**
     * Sets the value of the paymentAmountLessThan property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPaymentAmountLessThan(BigDecimal value) {
        this.paymentAmountLessThan = value;
    }

    /**
     * Gets the value of the expensePayeeTypeReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the expensePayeeTypeReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExpensePayeeTypeReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UniqueIdentifierObjectType }
     * 
     * 
     */
    public List<UniqueIdentifierObjectType> getExpensePayeeTypeReference() {
        if (expensePayeeTypeReference == null) {
            expensePayeeTypeReference = new ArrayList<UniqueIdentifierObjectType>();
        }
        return this.expensePayeeTypeReference;
    }

    /**
     * Gets the value of the transactionIsIntercompany property.
     * This getter has been renamed from isTransactionIsIntercompany() to getTransactionIsIntercompany() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getTransactionIsIntercompany() {
        return transactionIsIntercompany;
    }

    /**
     * Sets the value of the transactionIsIntercompany property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setTransactionIsIntercompany(Boolean value) {
        this.transactionIsIntercompany = value;
    }

    /**
     * Gets the value of the companyReceivingPaymentReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the companyReceivingPaymentReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCompanyReceivingPaymentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CompanyObjectType }
     * 
     * 
     */
    public List<CompanyObjectType> getCompanyReceivingPaymentReference() {
        if (companyReceivingPaymentReference == null) {
            companyReceivingPaymentReference = new ArrayList<CompanyObjectType>();
        }
        return this.companyReceivingPaymentReference;
    }

    /**
     * Gets the value of the periodsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the periodsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPeriodsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PeriodObjectType }
     * 
     * 
     */
    public List<PeriodObjectType> getPeriodsReference() {
        if (periodsReference == null) {
            periodsReference = new ArrayList<PeriodObjectType>();
        }
        return this.periodsReference;
    }

    /**
     * Gets the value of the payRunGroupsAndOrPayGroupsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the payRunGroupsAndOrPayGroupsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayRunGroupsAndOrPayGroupsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayRunGroupSelectionObjectType }
     * 
     * 
     */
    public List<PayRunGroupSelectionObjectType> getPayRunGroupsAndOrPayGroupsReference() {
        if (payRunGroupsAndOrPayGroupsReference == null) {
            payRunGroupsAndOrPayGroupsReference = new ArrayList<PayRunGroupSelectionObjectType>();
        }
        return this.payRunGroupsAndOrPayGroupsReference;
    }

    /**
     * Gets the value of the eftPaymentID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEFTPaymentID() {
        return eftPaymentID;
    }

    /**
     * Sets the value of the eftPaymentID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEFTPaymentID(String value) {
        this.eftPaymentID = value;
    }

    /**
     * Gets the value of the reconciliationStatusReference property.
     * 
     * @return
     *     possible object is
     *     {@link ReconciliationStatusObjectType }
     *     
     */
    public ReconciliationStatusObjectType getReconciliationStatusReference() {
        return reconciliationStatusReference;
    }

    /**
     * Sets the value of the reconciliationStatusReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReconciliationStatusObjectType }
     *     
     */
    public void setReconciliationStatusReference(ReconciliationStatusObjectType value) {
        this.reconciliationStatusReference = value;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param companyReference
     *     allowed object is
     *     {@link OrganizationObjectType }
     *     
     */
    public void setCompanyReference(List<OrganizationObjectType> companyReference) {
        this.companyReference = companyReference;
    }

    /**
     * Sets the value of the bankAccountReference property.
     * 
     * @param bankAccountReference
     *     allowed object is
     *     {@link FinancialAccountObjectType }
     *     
     */
    public void setBankAccountReference(List<FinancialAccountObjectType> bankAccountReference) {
        this.bankAccountReference = bankAccountReference;
    }

    /**
     * Sets the value of the paymentCategoryReference property.
     * 
     * @param paymentCategoryReference
     *     allowed object is
     *     {@link PaymentCategoryObjectType }
     *     
     */
    public void setPaymentCategoryReference(List<PaymentCategoryObjectType> paymentCategoryReference) {
        this.paymentCategoryReference = paymentCategoryReference;
    }

    /**
     * Sets the value of the payeeReference property.
     * 
     * @param payeeReference
     *     allowed object is
     *     {@link PayeeObjectType }
     *     
     */
    public void setPayeeReference(List<PayeeObjectType> payeeReference) {
        this.payeeReference = payeeReference;
    }

    /**
     * Sets the value of the payeeHierarchyReference property.
     * 
     * @param payeeHierarchyReference
     *     allowed object is
     *     {@link HierarchyObjectType }
     *     
     */
    public void setPayeeHierarchyReference(List<HierarchyObjectType> payeeHierarchyReference) {
        this.payeeHierarchyReference = payeeHierarchyReference;
    }

    /**
     * Sets the value of the paymentTypeReference property.
     * 
     * @param paymentTypeReference
     *     allowed object is
     *     {@link PaymentTypeObjectType }
     *     
     */
    public void setPaymentTypeReference(List<PaymentTypeObjectType> paymentTypeReference) {
        this.paymentTypeReference = paymentTypeReference;
    }

    /**
     * Sets the value of the paymentStatusReference property.
     * 
     * @param paymentStatusReference
     *     allowed object is
     *     {@link PaymentStatusObjectType }
     *     
     */
    public void setPaymentStatusReference(List<PaymentStatusObjectType> paymentStatusReference) {
        this.paymentStatusReference = paymentStatusReference;
    }

    /**
     * Sets the value of the customerSupplierStatusReference property.
     * 
     * @param customerSupplierStatusReference
     *     allowed object is
     *     {@link BusinessEntityStatusValueObjectType }
     *     
     */
    public void setCustomerSupplierStatusReference(List<BusinessEntityStatusValueObjectType> customerSupplierStatusReference) {
        this.customerSupplierStatusReference = customerSupplierStatusReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param currencyReference
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(List<CurrencyObjectType> currencyReference) {
        this.currencyReference = currencyReference;
    }

    /**
     * Sets the value of the settlementRunReference property.
     * 
     * @param settlementRunReference
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setSettlementRunReference(List<UniqueIdentifierObjectType> settlementRunReference) {
        this.settlementRunReference = settlementRunReference;
    }

    /**
     * Sets the value of the createdByWorkerReference property.
     * 
     * @param createdByWorkerReference
     *     allowed object is
     *     {@link WorkerObjectType }
     *     
     */
    public void setCreatedByWorkerReference(List<WorkerObjectType> createdByWorkerReference) {
        this.createdByWorkerReference = createdByWorkerReference;
    }

    /**
     * Sets the value of the expensePayeeTypeReference property.
     * 
     * @param expensePayeeTypeReference
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setExpensePayeeTypeReference(List<UniqueIdentifierObjectType> expensePayeeTypeReference) {
        this.expensePayeeTypeReference = expensePayeeTypeReference;
    }

    /**
     * Sets the value of the companyReceivingPaymentReference property.
     * 
     * @param companyReceivingPaymentReference
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReceivingPaymentReference(List<CompanyObjectType> companyReceivingPaymentReference) {
        this.companyReceivingPaymentReference = companyReceivingPaymentReference;
    }

    /**
     * Sets the value of the periodsReference property.
     * 
     * @param periodsReference
     *     allowed object is
     *     {@link PeriodObjectType }
     *     
     */
    public void setPeriodsReference(List<PeriodObjectType> periodsReference) {
        this.periodsReference = periodsReference;
    }

    /**
     * Sets the value of the payRunGroupsAndOrPayGroupsReference property.
     * 
     * @param payRunGroupsAndOrPayGroupsReference
     *     allowed object is
     *     {@link PayRunGroupSelectionObjectType }
     *     
     */
    public void setPayRunGroupsAndOrPayGroupsReference(List<PayRunGroupSelectionObjectType> payRunGroupsAndOrPayGroupsReference) {
        this.payRunGroupsAndOrPayGroupsReference = payRunGroupsAndOrPayGroupsReference;
    }

}
