
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Fund Hierarchy data
 * 
 * <p>Java class for Fund_Hierarchy_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Fund_Hierarchy_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Fund_Hierarchy_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Fund_Hierarchy_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Include_Fund_Hierarchy_ID_in_Name" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Fund_Hierarchy_is_Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Organization_Subtype_Reference" type="{urn:com.workday/bsvc}Organization_SubtypeObjectType" minOccurs="0"/>
 *         &lt;element name="Parent_Fund_Hierarchy_Reference" type="{urn:com.workday/bsvc}Fund_HierarchyObjectType" minOccurs="0"/>
 *         &lt;element name="Contains_Funds_Reference" type="{urn:com.workday/bsvc}FundObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Fund_Hierarchy_DataType", propOrder = {
    "fundHierarchyID",
    "fundHierarchyName",
    "includeFundHierarchyIDInName",
    "fundHierarchyIsInactive",
    "organizationSubtypeReference",
    "parentFundHierarchyReference",
    "containsFundsReference"
})
public class FundHierarchyDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Fund_Hierarchy_ID")
    protected String fundHierarchyID;
    @XmlElement(name = "Fund_Hierarchy_Name", required = true)
    protected String fundHierarchyName;
    @XmlElement(name = "Include_Fund_Hierarchy_ID_in_Name")
    protected Boolean includeFundHierarchyIDInName;
    @XmlElement(name = "Fund_Hierarchy_is_Inactive")
    protected Boolean fundHierarchyIsInactive;
    @XmlElement(name = "Organization_Subtype_Reference")
    protected OrganizationSubtypeObjectType organizationSubtypeReference;
    @XmlElement(name = "Parent_Fund_Hierarchy_Reference")
    protected FundHierarchyObjectType parentFundHierarchyReference;
    @XmlElement(name = "Contains_Funds_Reference")
    protected List<FundObjectType> containsFundsReference;

    /**
     * Gets the value of the fundHierarchyID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFundHierarchyID() {
        return fundHierarchyID;
    }

    /**
     * Sets the value of the fundHierarchyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFundHierarchyID(String value) {
        this.fundHierarchyID = value;
    }

    /**
     * Gets the value of the fundHierarchyName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFundHierarchyName() {
        return fundHierarchyName;
    }

    /**
     * Sets the value of the fundHierarchyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFundHierarchyName(String value) {
        this.fundHierarchyName = value;
    }

    /**
     * Gets the value of the includeFundHierarchyIDInName property.
     * This getter has been renamed from isIncludeFundHierarchyIDInName() to getIncludeFundHierarchyIDInName() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeFundHierarchyIDInName() {
        return includeFundHierarchyIDInName;
    }

    /**
     * Sets the value of the includeFundHierarchyIDInName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeFundHierarchyIDInName(Boolean value) {
        this.includeFundHierarchyIDInName = value;
    }

    /**
     * Gets the value of the fundHierarchyIsInactive property.
     * This getter has been renamed from isFundHierarchyIsInactive() to getFundHierarchyIsInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getFundHierarchyIsInactive() {
        return fundHierarchyIsInactive;
    }

    /**
     * Sets the value of the fundHierarchyIsInactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setFundHierarchyIsInactive(Boolean value) {
        this.fundHierarchyIsInactive = value;
    }

    /**
     * Gets the value of the organizationSubtypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public OrganizationSubtypeObjectType getOrganizationSubtypeReference() {
        return organizationSubtypeReference;
    }

    /**
     * Sets the value of the organizationSubtypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public void setOrganizationSubtypeReference(OrganizationSubtypeObjectType value) {
        this.organizationSubtypeReference = value;
    }

    /**
     * Gets the value of the parentFundHierarchyReference property.
     * 
     * @return
     *     possible object is
     *     {@link FundHierarchyObjectType }
     *     
     */
    public FundHierarchyObjectType getParentFundHierarchyReference() {
        return parentFundHierarchyReference;
    }

    /**
     * Sets the value of the parentFundHierarchyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FundHierarchyObjectType }
     *     
     */
    public void setParentFundHierarchyReference(FundHierarchyObjectType value) {
        this.parentFundHierarchyReference = value;
    }

    /**
     * Gets the value of the containsFundsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the containsFundsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContainsFundsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FundObjectType }
     * 
     * 
     */
    public List<FundObjectType> getContainsFundsReference() {
        if (containsFundsReference == null) {
            containsFundsReference = new ArrayList<FundObjectType>();
        }
        return this.containsFundsReference;
    }

    /**
     * Sets the value of the containsFundsReference property.
     * 
     * @param containsFundsReference
     *     allowed object is
     *     {@link FundObjectType }
     *     
     */
    public void setContainsFundsReference(List<FundObjectType> containsFundsReference) {
        this.containsFundsReference = containsFundsReference;
    }

}
