package com.workday.financial;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;

/**
 * The Financial Management Web Service contains operations that expose Workday Financials data. It includes data relative to Accounts, Accounting, Business Plans, Financial Reporting, Tax and more.
 *
 * This class was generated by Apache CXF 2.5.1
 * 2014-12-12T19:00:40.795-03:00
 * Generated source version: 2.5.1
 * 
 */
@WebService(targetNamespace = "urn:com.workday/bsvc/Financial_Management", name = "Financial_ManagementPort")
@XmlSeeAlso({ObjectFactory.class})
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
public interface FinancialManagementPort {

    /**
     * This service operation will get Beginning Balance Journals for the specified criteria. Beginning Balance Journal data includes Company the journal is form, journal Currency, Currency Rate Type, Ledger Year, a Memo, Journal Source, Book Code and Journal Entry Line data.  Journal Entry Line data includes Inter Company Affiliate, Ledger Account, Debit Amount, Credit Amount, Currency, Currency Rate, Ledger Debit Amount, Ledger Credit Amount, Line Memo, and Worktags.  The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Beginning_Balance_Journals_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Beginning_Balance_Journals")
    public GetBeginningBalanceJournalsResponseType getBeginningBalanceJournals(
        @WebParam(partName = "body", name = "Get_Beginning_Balance_Journals_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBeginningBalanceJournalsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Regions for the specified criteria.  Region Data include Effective Date, Organization Data, Organization Subtype and Organization Container.
     * Organization Data include Id, Organization Name, Organization Code, Include Organization Code in Name, Organization Active, Availability Date, Organization Visibility, External URL and Integration ID Data.
     * Integration ID Data include ID
     * ID Include System Id and External ID
     * The request criteria can be for a single Region based on Reference or all Regions if no criteria is specified.
     */
    @WebResult(name = "Get_Regions_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Regions")
    public GetRegionsResponseType getRegions(
        @WebParam(partName = "body", name = "Get_Regions_Request", targetNamespace = "urn:com.workday/bsvc")
        GetRegionsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Effort Certification Change Reason Codes.
     */
    @WebResult(name = "Put_Effort_Certification_Change_Reason_Code_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Effort_Certification_Change_Reason_Code")
    public PutEffortCertificationChangeReasonCodeResponseType putEffortCertificationChangeReasonCode(
        @WebParam(partName = "body", name = "Put_Effort_Certification_Change_Reason_Code_Request", targetNamespace = "urn:com.workday/bsvc")
        PutEffortCertificationChangeReasonCodeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update the Custom Worktags for the Custom Worktag Configuration.  Custom Worktags are user-defined values that can be used to tag transactions with data that is not represented by the Workday-delivered transaction Worktags.  Custom Worktags must be enabled and mapped to a Custom Worktag Configuration.  Custom Worktag data includes the Configuration Reference, the Worktags Reference ID and Value for that Configuration.
     */
    @WebResult(name = "Put_Custom_Worktag_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Custom_Worktag")
    public PutCustomWorktagResponseType putCustomWorktag(
        @WebParam(partName = "body", name = "Put_Custom_Worktag_Request", targetNamespace = "urn:com.workday/bsvc")
        PutCustomWorktagRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation with add or update Surveys. You may only update a Survey currently in the system if it has no Survey Responses to the questions. If you wish to update a Survey that has been responded to, please make a new Survey.
     */
    @WebResult(name = "Put_Survey_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Survey")
    public PutSurveyResponseType putSurvey(
        @WebParam(partName = "body", name = "Put_Survey_Request", targetNamespace = "urn:com.workday/bsvc")
        PutSurveyRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will update existing Budgets asynchronously. Budget data includes the Company the Budget is for, the Budget Type and the Budget Year data. Budget Year data includes the Budget Fiscal Year, the Year Status and the Budget Period. The Budget Period includes the Period status, and the Fiscal Period.
     */
    @WebResult(name = "Put_Import_Process_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Import_Budget_Details_Incremental")
    public PutImportProcessResponseType importBudgetDetailsIncremental(
        @WebParam(partName = "body", name = "Import_Budget_Details_Incremental_High_Volume_Request", targetNamespace = "urn:com.workday/bsvc")
        ImportBudgetDetailsIncrementalHighVolumeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Currency Rate Types for the specified criteria.  Currency Rate Type data includes the Currency Rate Type ID, Description, and if it is the Default Rate Type. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Currency_Rate_Types_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Currency_Rate_Types")
    public GetCurrencyRateTypesResponseType getCurrencyRateTypes(
        @WebParam(partName = "body", name = "Get_Currency_Rate_Types_Request", targetNamespace = "urn:com.workday/bsvc")
        GetCurrencyRateTypesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Spend Categories.  Spend Categories are a classification for items and services that drives the accounting in Workday. Whenever an accounting entry is made, Workday looks first at the spend category. All items���expense items, purchase items���and services are associated with a Spend Category. Sales items are associated with its analog: Revenue Category. This service returns the spend categories that are applied to every business asset���that is, expense item, purchase item, and service���in Workday. You can define categories to fit your enterprise's needs. You can also followed a standard like the UN/SPSC coding hierarchy.   Spend Category data for this service includes Spend Category ID, Spend Category Name, Procurement Usage flag, Expense Usage flag, Track Items flag, Accounting Treatment, Depreciation Profile, and UNSPSC Code Range.
     * 
     * Business Asset and Resource are synonymous and refer to the same business object.
     * Spend Category and Resource Category are synonymous and refer to the same business object.
     */
    @WebResult(name = "Put_Resource_Category_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Resource_Category")
    public PutResourceCategoryResponseType putResourceCategory(
        @WebParam(partName = "body", name = "Put_Resource_Category_Request", targetNamespace = "urn:com.workday/bsvc")
        PutResourceCategoryRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Projects used as worktag values only. Basic Project data includes Project ID, Project Name, Inactive status. These basic projects can only be used as worktag values and will not be usable from many financial transactions such as Customer Invoices, Project Time Sheets. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Basic_Projects_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Basic_Projects")
    public GetBasicProjectsResponseType getBasicProjects(
        @WebParam(partName = "body", name = "Get_Basic_Projects_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBasicProjectsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Loan Referral Types. This service will return the Loan Referral type and its associated information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Loan_Referral_Types_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Loan_Referral_Types")
    public GetLoanReferralTypesResponseType getLoanReferralTypes(
        @WebParam(partName = "body", name = "Get_Loan_Referral_Types_Request", targetNamespace = "urn:com.workday/bsvc")
        GetLoanReferralTypesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service returns data for 1042-S Income Codes.  Income Code for 1042-S data includes Withholding Spend Categories or Spend Category Hierarchies for all Income Codes, plus: Income Code, Description, Spend Categories or Spend Category Hierarchies. A single Investor can be returned by supplying a reference ID or Income Code, a number of Income codes by providing Spend Categories and/or Hierarchies or all 1042-S Income Codes can be returned if no criteria is provided.
     */
    @WebResult(name = "Get_1042-S_Income_Codes_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_1042-S_Income_Codes")
    public Get1042SIncomeCodesResponseType get1042SIncomeCodes(
        @WebParam(partName = "body", name = "Get_1042-S_Income_Codes_Request", targetNamespace = "urn:com.workday/bsvc")
        Get1042SIncomeCodesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Payment Messages for the specified criteria. The request criteria can be for a single payment message based on Reference, or all payment messages for the specified criteria.
     */
    @WebResult(name = "Get_Payment_Messages_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Payment_Messages")
    public GetPaymentMessagesResponseType getPaymentMessages(
        @WebParam(partName = "body", name = "Get_Payment_Messages_Request", targetNamespace = "urn:com.workday/bsvc")
        GetPaymentMessagesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Spend Categories for the specified criteria.  Spend Categories are a classification for items and services that drives the accounting in Workday. Whenever an accounting entry is made, Workday looks first at the spend category. All items���expense items, purchase items���and services are associated with a Spend Category. Sales items are associated with its analog: Revenue Category.  Spend Category data for this service includes Spend Category ID, Spend Category Name, Procurement Usage flag, Expense Usage flag, Track Items flag, Accounting Treatment, Depreciation Profile, and UNSPSC Code Range. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     * 
     * Spend Category and Resource Category are synonymous and refer to the same business object.
     */
    @WebResult(name = "Get_Resource_Categories_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Resource_Categories")
    public GetResourceCategoriesResponseType getResourceCategories(
        @WebParam(partName = "body", name = "Get_Resource_Categories_Request", targetNamespace = "urn:com.workday/bsvc")
        GetResourceCategoriesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Statistics for the specified criteria.  Statistics data includes the Statistic Definition, Fiscal Period, Memo, reference to the Statistics line values (Company, Worktags and Line Value), and file attachment. The request criteria can be for a single object based on Reference, or all data will be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Statistics_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Statistics")
    public GetStatisticsResponseType getStatistics(
        @WebParam(partName = "body", name = "Get_Statistics_Request", targetNamespace = "urn:com.workday/bsvc")
        GetStatisticsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will retrieve a specified Effort Certifying Text (if specified) or will return all Effort Certifying Texts.
     */
    @WebResult(name = "Get_Effort_Certifying_Texts_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Effort_Certifying_Texts")
    public GetEffortCertifyingTextsResponseType getEffortCertifyingTexts(
        @WebParam(partName = "body", name = "Get_Effort_Certifying_Texts_Request", targetNamespace = "urn:com.workday/bsvc")
        GetEffortCertifyingTextsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Sales Items used as worktag values only. Basic Sales Item data includes  Sales Item ID, Item Name, Inactive status. These basic sales items can only be used as worktag values and will not be usable from many financial transactions such as Customer Invoices, Customer Contracts, Expense Reports, or Cash Sale transactions. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Basic_Sales_Items_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Basic_Sales_Items")
    public GetBasicSalesItemsResponseType getBasicSalesItems(
        @WebParam(partName = "body", name = "Get_Basic_Sales_Items_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBasicSalesItemsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update a Payment Term. Data includes Payment Terms ID, Payment Terms Name, Due Days, Payment Discount Days, Payment Discount Percent, and Grace Days.
     */
    @WebResult(name = "Put_Payment_Term_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Payment_Term")
    public PutPaymentTermResponseType putPaymentTerm(
        @WebParam(partName = "body", name = "Put_Payment_Term_Request", targetNamespace = "urn:com.workday/bsvc")
        PutPaymentTermRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service operation will add or update Custom Validation Rule. A Custom Validation Rule contains a Label and Classification. Each Custom Valiation Rule can contain many Condition Rules, which are made up of Condition Items that make up the logic used in the Custom Validations for each Rule type.
     */
    @WebResult(name = "Put_Custom_Validation_Rule_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Custom_Validation_Rule")
    public PutCustomValidationRuleResponseType putCustomValidationRule(
        @WebParam(partName = "body", name = "Put_Custom_Validation_Rule_Request", targetNamespace = "urn:com.workday/bsvc")
        PutCustomValidationRuleRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Tax Categories for the specified criteria. Tax Category data includes Tax Category ID and Name. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Tax_Categories_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Tax_Categories")
    public GetTaxCategoriesResponseType getTaxCategories(
        @WebParam(partName = "body", name = "Get_Tax_Categories_Request", targetNamespace = "urn:com.workday/bsvc")
        GetTaxCategoriesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get basic Customers that can be used as worktags only. Basic Customer data includes Reference ID, Customer Name, and Inactive boolean. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified. 
     * Basic Customers can not be used on financial transactions such as Customer Invoices, Customer Contracts, or billing transactions. Use the Get Customers web service for retrieving complete Customer definitions used by Financial transactions.
     */
    @WebResult(name = "Get_Basic_Customers_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Basic_Customers")
    public GetBasicCustomersResponseType getBasicCustomers(
        @WebParam(partName = "body", name = "Get_Basic_Customers_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBasicCustomersRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns only non-basic Grants and their associated information. The request criteria can be for a single transaction based on the Reference ID. If a Reference ID is not specified, the operation retrieves all transactions.
     */
    @WebResult(name = "Get_Grants_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Grants")
    public GetGrantsResponseType getGrants(
        @WebParam(partName = "body", name = "Get_Grants_Request", targetNamespace = "urn:com.workday/bsvc")
        GetGrantsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Payment Type data for the specified criteria. Data includes ID, Payment Type Name, and Payment Method. The request criteria can be for a specific Payment Type based on reference(s), Payment Type Name (partial match ok), and Payment Method criteria.
     * 
     * If no criteria are specified, all Payment Types will be retrieved.
     */
    @WebResult(name = "Get_Payment_Types_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Payment_Types")
    public GetPaymentTypesResponseType getPaymentTypes(
        @WebParam(partName = "body", name = "Get_Payment_Types_Request", targetNamespace = "urn:com.workday/bsvc")
        GetPaymentTypesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get all the Custom Worktags and the Custom Worktag Configuration.  Custom Worktags are user-defined values that can be used to tag transaction with data that is not represented by the Workday delivered transaction Worktags.  Custom Worktags must be enabled and mapped to a Custom Worktag Configuration.  Custom Worktag data includes the Configuration Reference, the Worktags Reference ID and Value for that Configuration.
     */
    @WebResult(name = "Get_Custom_Worktags_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Custom_Worktags")
    public GetCustomWorktagsResponseType getCustomWorktags(
        @WebParam(partName = "body", name = "Get_Custom_Worktags_Request", targetNamespace = "urn:com.workday/bsvc")
        GetCustomWorktagsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Statistic Definitions. Data includes: Name of the definition, Description, Fiscal Schedule, Required Dimensions, a boolean attribute that indicates whether or not the definition requires Company, Statistic Type and whether or not the definition is Inactive.
     */
    @WebResult(name = "Put_Statistic_Definition_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Statistic_Definition")
    public PutStatisticDefinitionResponseType putStatisticDefinition(
        @WebParam(partName = "body", name = "Put_Statistic_Definition_Request", targetNamespace = "urn:com.workday/bsvc")
        PutStatisticDefinitionRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Program Hierarchies.  This operation will allow the addition of an existing Program Hierarchy as the superior and the addition of existing Programs as subordinates.
     */
    @WebResult(name = "Put_Program_Hierarchy_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Program_Hierarchy")
    public PutProgramHierarchyResponseType putProgramHierarchy(
        @WebParam(partName = "body", name = "Put_Program_Hierarchy_Request", targetNamespace = "urn:com.workday/bsvc")
        PutProgramHierarchyRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will submit Business Plan Amendment Requests.
     */
    @WebResult(name = "Submit_Business_Plan_Amendment_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Submit_Business_Plan_Amendment")
    public SubmitBusinessPlanAmendmentResponseType submitBusinessPlanAmendment(
        @WebParam(partName = "body", name = "Submit_Business_Plan_Amendment_Request", targetNamespace = "urn:com.workday/bsvc")
        SubmitBusinessPlanAmendmentRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates Grants used as worktag values only.  To add or update a complete Grant definition, use the Put Grant web service.
     */
    @WebResult(name = "Put_Basic_Grant_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Basic_Grant")
    public PutBasicGrantResponseType putBasicGrant(
        @WebParam(partName = "body", name = "Put_Basic_Grant_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBasicGrantRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Task to get all or some Gift Hierarchies
     */
    @WebResult(name = "Get_Gift_Hierarchies_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Gift_Hierarchies")
    public GetGiftHierarchiesResponseType getGiftHierarchies(
        @WebParam(partName = "body", name = "Get_Gift_Hierarchies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetGiftHierarchiesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Programs. The Program data includes a Name, ID, Include Program ID in Name, Program Type and the ability to create an Inactive Program.
     */
    @WebResult(name = "Put_Program_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Program")
    public PutProgramResponseType putProgram(
        @WebParam(partName = "body", name = "Put_Program_Request", targetNamespace = "urn:com.workday/bsvc")
        PutProgramRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates 1099 MISC Adjustments and submits them to the 1099 MISC Adjustment business process.  1099 MISC Adjustment Data contains Company, 1099 Payee, Adjustment Date, Memo, and Line Data. Line data includes the Spend Category, amount, and memo.
     */
    @WebResult(name = "Submit_1099_MISC_Adjustment_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Submit_1099_MISC_Adjustment")
    public Submit1099MISCAdjustmentResponseType submit1099MISCAdjustment(
        @WebParam(partName = "body", name = "Submit_1099_MISC_Adjustment_Request", targetNamespace = "urn:com.workday/bsvc")
        Submit1099MISCAdjustmentRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * For Third Party Tax Services to persist calculated tax information on Customer Invoice
     */
    @WebResult(name = "Put_Third_Party_Calculated_Tax_Information_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Third_Party_Calculated_Tax_Information")
    public PutThirdPartyCalculatedTaxInformationResponseType putThirdPartyCalculatedTaxInformation(
        @WebParam(partName = "body", name = "Put_Third_Party_Calculated_Tax_Information_Request", targetNamespace = "urn:com.workday/bsvc")
        PutThirdPartyCalculatedTaxInformationRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will modify an existing Effort Certification Text (if a valid ID is provided) or will create a new Effort Certification Text.
     */
    @WebResult(name = "Put_Effort_Certifying_Text_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Effort_Certifying_Text")
    public PutEffortCertifyingTextResponseType putEffortCertifyingText(
        @WebParam(partName = "body", name = "Put_Effort_Certifying_Text_Request", targetNamespace = "urn:com.workday/bsvc")
        PutEffortCertifyingTextRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Business Units. This service will return the Business Unit and its associated information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Business_Units_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Business_Units")
    public GetBusinessUnitsResponseType getBusinessUnits(
        @WebParam(partName = "body", name = "Get_Business_Units_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBusinessUnitsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Business Unit Hierarchies.  This operation will allow the addition of an existing Business Unit Hierarchy as the superior and the addition of existing Funds as subordinates.
     */
    @WebResult(name = "Put_Business_Unit_Hierarchy_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Business_Unit_Hierarchy")
    public PutBusinessUnitHierarchyResponseType putBusinessUnitHierarchy(
        @WebParam(partName = "body", name = "Put_Business_Unit_Hierarchy_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBusinessUnitHierarchyRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service operation is designed to get an instance or return all Effort Certification Eligibility Rules (Condition Rules) without dependencies.
     */
    @WebResult(name = "Get_Effort_Certification_Eligibility_Rules_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Effort_Certification_Eligibility_Rules_without_Dependencies")
    public GetEffortCertificationEligibilityRulesResponseType getEffortCertificationEligibilityRulesWithoutDependencies(
        @WebParam(partName = "body", name = "Get_Effort_Certification_Eligibility_Rules_without_Dependencies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetEffortCertificationEligibilityRulesWithoutDependenciesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Journal Entries for the specified criteria. Journal data includes the Journal Entry Reference, Journal Entry Status, Company, Currency, Ledger Period, Accounting Date, Journal Source, Transaction Date, Operational Transaction, Memo, Book Code, Journal Entry Line data and Attachment Data. Journal Entry Line data includes Inter Company Affiliate, Ledger Account, Debit Amount, Credit Amount, Currency, Ledger Debit Amount, Ledger Credit Amount, Memo, and Worktags. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Journals_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Journals")
    public GetJournalsResponseType getJournals(
        @WebParam(partName = "body", name = "Get_Journals_Request", targetNamespace = "urn:com.workday/bsvc")
        GetJournalsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get loans. This service will return the Loan and its associated information. The request criteria can be for a single instance based on Reference, or all instances of loans can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Loans_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Loans")
    public GetLoansResponseType getLoans(
        @WebParam(partName = "body", name = "Get_Loans_Request", targetNamespace = "urn:com.workday/bsvc")
        GetLoansRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will modify an existing Effort Certification Type (if a valid ID is provided) or will create a new Effort Certification Type.
     */
    @WebResult(name = "Put_Effort_Certification_Type_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Effort_Certification_Type")
    public PutEffortCertificationTypeResponseType putEffortCertificationType(
        @WebParam(partName = "body", name = "Put_Effort_Certification_Type_Request", targetNamespace = "urn:com.workday/bsvc")
        PutEffortCertificationTypeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Fund Hierarchies. This service will return the Fund Hierarchies and its associated information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Fund_Hierarchies_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Fund_Hierarchies")
    public GetFundHierarchiesResponseType getFundHierarchies(
        @WebParam(partName = "body", name = "Get_Fund_Hierarchies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetFundHierarchiesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This operation will get information for search settings.
     */
    @WebResult(name = "Get_Search_Settings_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Search_Settings")
    public GetSearchSettingsResponseType getSearchSettings(
        @WebParam(partName = "body", name = "Get_Search_Settings_Request", targetNamespace = "urn:com.workday/bsvc")
        GetSearchSettingsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Statistics. Data includes: reference to the related Statistic Definition, Fiscal Period, Memo, the Statistics line values (Company, Worktags and Line Value), and optional file attachment.
     */
    @WebResult(name = "Put_Statistic_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Statistic")
    public PutStatisticResponseType putStatistic(
        @WebParam(partName = "body", name = "Put_Statistic_Request", targetNamespace = "urn:com.workday/bsvc")
        PutStatisticRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Sales Items used as worktag values only.  Basic Sales Item data includes  Sales Item ID, Item Name,  and optional Inactive attribute.
     * Use the Put Sales Item web service to add or update Sales Items used for any type of financial transaction.
     */
    @WebResult(name = "Put_Sales_Item_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Basic_Sales_Item")
    public PutSalesItemResponseType putBasicSalesItem(
        @WebParam(partName = "body", name = "Put_Basic_Sales_Item_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBasicSalesItemRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Programs. This service will return the Program and its associated information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Programs_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Programs")
    public GetProgramsResponseType getPrograms(
        @WebParam(partName = "body", name = "Get_Programs_Request", targetNamespace = "urn:com.workday/bsvc")
        GetProgramsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This operation will put search configurations into workday.
     */
    @WebResult(name = "Put_Search_Settings_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Search_Settings")
    public PutSearchSettingsResponseType putSearchSettings(
        @WebParam(partName = "body", name = "Put_Search_Settings_Request", targetNamespace = "urn:com.workday/bsvc")
        PutSearchSettingsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Gifts. The Fund data includes a Name, ID, Include Gift ID in Name, Gift Type, Gift Purpose, and the ability to create an Inactive Gift.
     */
    @WebResult(name = "Submit_Gift_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Submit_Gift")
    public SubmitGiftResponseType submitGift(
        @WebParam(partName = "body", name = "Submit_Gift_Request", targetNamespace = "urn:com.workday/bsvc")
        SubmitGiftRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This Web Service will put Ledger Account Summaries or Ledger Accounts for a specified Ledger Account Summary
     */
    @WebResult(name = "Put_Ledger_Account_Summary_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Ledger_Account_Summary")
    public PutLedgerAccountSummaryResponseType putLedgerAccountSummary(
        @WebParam(partName = "body", name = "Put_Ledger_Account_Summary_Request", targetNamespace = "urn:com.workday/bsvc")
        PutLedgerAccountSummaryRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Currency Rate Type.  Currency Rate Type data includes the Currency Rate Type ID, Description, and if it is the Default Rate Type.
     */
    @WebResult(name = "Put_Currency_Rate_Type_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Currency_Rate_Type")
    public PutCurrencyRateTypeResponseType putCurrencyRateType(
        @WebParam(partName = "body", name = "Put_Currency_Rate_Type_Request", targetNamespace = "urn:com.workday/bsvc")
        PutCurrencyRateTypeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Recurring Journal Templates for the specified criteria.  Recurring Journal Templates allow you to create a journal template that can be used later to manually periodically create journals based off that template.  Recurring Journal Template data includes Recurring Journal Template ID, Template Name, Currency, Currency Rate Type, Ledger Reference, Template Start Date, Template End Date, flag indicating if journals created from a template should be automatically submitted, control total amount, journal source, company, and Journal Line Data. Journal Line Data includes Line Ordering, inter-company affiliate, ledger account, debit amount, credit amount, currency, ledger debit amount, ledger credit amount, memo and worktags.
     */
    @WebResult(name = "Get_Recurring_Journal_Templates_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Recurring_Journal_Templates")
    public GetRecurringJournalTemplatesResponseType getRecurringJournalTemplates(
        @WebParam(partName = "body", name = "Get_Recurring_Journal_Templates_Request", targetNamespace = "urn:com.workday/bsvc")
        GetRecurringJournalTemplatesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This Web Service will return Ledger Account Summaries, included Ledger Accounts and indirectly included accounts depending on Response Group setting. To Return All Ledger Accounts (indirectly included) set the Response Group 'Include All Ledger Account Data'
     */
    @WebResult(name = "Get_Ledger_Account_Summaries_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Ledger_Account_Summaries")
    public GetLedgerAccountSummariesResponseType getLedgerAccountSummaries(
        @WebParam(partName = "body", name = "Get_Ledger_Account_Summary_Request", targetNamespace = "urn:com.workday/bsvc")
        GetLedgerAccountSummaryRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will retrieve a specified Effort Certification Change Reason Code (if specified) or will return all Effort Certification Change Reason Codes.
     */
    @WebResult(name = "Get_Effort_Certification_Change_Reason_Codes_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Effort_Certification_Change_Reason_Codes")
    public GetEffortCertificationChangeReasonCodesResponseType getEffortCertificationChangeReasonCodes(
        @WebParam(partName = "body", name = "Get_Effort_Certification_Change_Reason_Codes_Request", targetNamespace = "urn:com.workday/bsvc")
        GetEffortCertificationChangeReasonCodesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Customer Category.  Customer Category includes the Customer Category ID and Customer Category Name.   Customer categories are used to help determine accounting for transactions beyond what is defined in the posting rules. When processing a transaction, Workday finds the category on a customer and applies the accounting based on the category. You can't override this category for individual transactions.  You can also use customer categories when selecting or searching for customers. Each customer must have one customer category. You assign a customer to customer categories when creating or editing a customer.
     */
    @WebResult(name = "Put_Customer_Category_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Customer_Category")
    public PutCustomerCategoryResponseType putCustomerCategory(
        @WebParam(partName = "body", name = "Put_Customer_Category_Request", targetNamespace = "urn:com.workday/bsvc")
        PutCustomerCategoryRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Get Business Entity Contacts for the specified criteria.  The data includes the Business Entity Contact ID, the Business Entity the Contact is for (Supplier, Customer, Financial Institution or Tax Authority), the Personal Data including Name Detail data and Contact Information data.  Name Detail data includes formatted Name, Country, Prefix, First Name, Middle Name, Last Name, Secondary Last Name, and Name Suffix.  Contact Information data includes Address, Phone, Email, Instance Messenger and Web Address data. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Business_Entity_Contacts_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Business_Entity_Contacts")
    public GetBusinessEntityContactsResponseType getBusinessEntityContacts(
        @WebParam(partName = "body", name = "Get_Business_Entity_Contacts_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBusinessEntityContactsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates Grant Hierarchies.  In addition, this operation allows adding an existing Grant Hierarchy as the superior and adding existing Grants as subordinates.
     */
    @WebResult(name = "Put_Grant_Hierarchy_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Grant_Hierarchy")
    public PutGrantHierarchyResponseType putGrantHierarchy(
        @WebParam(partName = "body", name = "Put_Grant_Hierarchy_Request", targetNamespace = "urn:com.workday/bsvc")
        PutGrantHierarchyRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates Gift Hierarchy.  To add or update a complete Gift definition, use the Submit Gift web service.
     */
    @WebResult(name = "Put_Gift_Hierarchy_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Gift_Hierarchy")
    public PutGiftHierarchyResponseType putGiftHierarchy(
        @WebParam(partName = "body", name = "Put_Gift_Hierarchy_Request", targetNamespace = "urn:com.workday/bsvc")
        PutGiftHierarchyRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Program Hierarchies. This service will return the Program Hierarchies and its associated information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Program_Hierarchies_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Program_Hierarchies")
    public GetProgramHierarchiesResponseType getProgramHierarchies(
        @WebParam(partName = "body", name = "Get_Program_Hierarchies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetProgramHierarchiesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Fund Types. This service will return the Fund Type and its associated information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Fund_Types_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Fund_Types")
    public GetFundTypesResponseType getFundTypes(
        @WebParam(partName = "body", name = "Get_Fund_Types_Request", targetNamespace = "urn:com.workday/bsvc")
        GetFundTypesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates an Accounting Journal and submits it to the Accounting Journals business process. This import is asynchronous and the response will only be an acknowledgement or receipt. Use the Get Import Processes web service operation to determine the status of the journal process, and the Get Import Process Messages web service operation for status, completion, and error messages. You'll find those operations in the Integrations web service.
     * 
     * Journals can be entered for month end adjustments, depreciation, or to record accrued liability for purchase items that have been received but not paid for. Journal entries for accruals can automatically be reversed. Workday creates journals behind the scenes for operational transactions, and uses posting rules to interpret the business events into debits and credits and accounts. Journal entries are posted to a ledger defined for each company.  Accounting Journal data includes Add Only option, Business Processing options, Accounting Journal ID, Submit for Approval flag, Locked in Workday flag,  Closed Period flag, Journal Number, Company, Currency, Ledger Type, Accounting Date, Journal Source, Memo, Adjustment Journal flag, Create Reversal flag, Control Total Amount, Currency Rate Type, Book Code, Journal Entry Line data and Attachment data. Journal Entry Line data includes Inter Company Affiliate, Ledger Account, Debit Amount, Credit Amount, Currency, Currency Rate, Ledger Debit Amount, Ledger Credit Amount, Line Memo, and Worktags.  The Get Journals web service operation will return both Accounting and Operational Journals.
     */
    @WebResult(name = "Put_Import_Process_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Import_Accounting_Journal")
    public PutImportProcessResponseType importAccountingJournal(
        @WebParam(partName = "body", name = "Import_Accounting_Journal_Request", targetNamespace = "urn:com.workday/bsvc")
        ImportAccountingJournalRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Loan Investor types.
     */
    @WebResult(name = "Put_Loan_Investor_Type_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Loan_Investor_Type")
    public PutLoanInvestorTypeResponseType putLoanInvestorType(
        @WebParam(partName = "body", name = "Put_Loan_Investor_Type_Request", targetNamespace = "urn:com.workday/bsvc")
        PutLoanInvestorTypeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service returns data for Investors. Investor data includes Name, ID, Default Payment Type, Contact Information, Contacts, Attachments, Alternate Names. A single Investor can be returned by supplying a reference ID, or all Investors can be returned if no criteria is provided.
     */
    @WebResult(name = "Get_Investors_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Investors")
    public GetInvestorsResponseType getInvestors(
        @WebParam(partName = "body", name = "Get_Investors_Request", targetNamespace = "urn:com.workday/bsvc")
        GetInvestorsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Supplier Categories for the specified criteria. Supplier Category data includes the Supplier Category ID and the Supplier Category Name. Supplier Categories are used to maintain suppliers and apply accounting rules to procurement transactions.   You can also use Supplier categories when selecting or searching for Suppliers. All Suppliers must have one and only one category.  The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Supplier_Categories_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Supplier_Categories")
    public GetSupplierCategoriesResponseType getSupplierCategories(
        @WebParam(partName = "body", name = "Get_Supplier_Categories_Request", targetNamespace = "urn:com.workday/bsvc")
        GetSupplierCategoriesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Retrieves 1099 MISC Adjustments for the specified criteria.  1099 MISC Adjustment Data contains Company, 1099 Payee, Adjustment Date, and additional Line Data, which includes the adjustment Spend Category, adjustment amount, and memo.  The request criteria can limit the retrieved data to a single transaction based on Reference, Company or Company Hierarchy, Start and End Dates. If no request criteria is specified, then the operation retrieves all transactions.
     */
    @WebResult(name = "Get_1099_MISC_Adjustments_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_1099_MISC_Adjustments")
    public Get1099MISCAdjustmentsResponseType get1099MISCAdjustments(
        @WebParam(partName = "body", name = "Get_1099_MISC_Adjustments_Request", targetNamespace = "urn:com.workday/bsvc")
        Get1099MISCAdjustmentsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Receivable Writeoff Categories. Receivable Writeoff Categories allow you to designate categories to describe receivables that you write off.  Receivable Writeoff Category data includes the Receivable Writeoff Category ID and the Receivable Writeoff Category Name.
     * 
     * In v14, Receivable Writeoff Category was renamed to Receivable Writeoff Reason. This name change is only reflected in the Workday application. The web service API still uses the name Receivable Writeoff Category.
     */
    @WebResult(name = "Put_Receivable_Writeoff_Category_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Receivable_Writeoff_Category")
    public PutReceivableWriteoffCategoryResponseType putReceivableWriteoffCategory(
        @WebParam(partName = "body", name = "Put_Receivable_Writeoff_Category_Request", targetNamespace = "urn:com.workday/bsvc")
        PutReceivableWriteoffCategoryRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Award Personnel Responsibilities.
     */
    @WebResult(name = "Put_Award_Personnel_Responsibility_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Award_Personnel_Responsibility")
    public PutAwardPersonnelResponsibilityResponseType putAwardPersonnelResponsibility(
        @WebParam(partName = "body", name = "Put_Award_Personnel_Responsibility_Request", targetNamespace = "urn:com.workday/bsvc")
        PutAwardPersonnelResponsibilityRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * DEPRECATED: This operation has been replaced by Get Workday Companies. 
     * This service operation will get  Companies for the specified criteria. Company data includes the Company Name, Business Entity Tax ID and Address Data. Address Data includes Country, Date Last Changed, Address Lines, Municipality, Submunicipality, Region, Subregion, Postal Code, Usage Data (Public, Usage Type, Use For and Comments) and Effective Date.  The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Companies_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Companies")
    public GetCompaniesResponseType getCompanies(
        @WebParam(partName = "body", name = "Get_Companies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetCompaniesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Cost Centers for the specified criteria.  Cost Center Data include Effective Date, Organization Data, Organization Subtype, Organization Container and Worktags.
     * Organization Data include Id, Organization Name, Organization Code, Include Organization Code in Name, Organization Active, Availability Date, Organization Visibility, External URL and Integration ID Data.
     * Integration ID Data include ID
     * ID Include System Id and External ID
     * The request criteria can be for a single Cost Center based on Reference or all Cost Centers if no criteria is specified.
     */
    @WebResult(name = "Get_Cost_Centers_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Cost_Centers")
    public GetCostCentersResponseType getCostCenters(
        @WebParam(partName = "body", name = "Get_Cost_Centers_Request", targetNamespace = "urn:com.workday/bsvc")
        GetCostCentersRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Tax Applicability data for the specified criteria. Data includes Tax ID, Tax Applicability Code, Taxable, and Recoverable. The request criteria can be for a specific Tax Applicability based on reference(s), Tax Applicability Code (partial match ok), Taxable?, and Recoverable? criteria.
     * 
     * If no criteria are specified, all Tax Applicabilities will be retrieved.
     */
    @WebResult(name = "Get_Tax_Applicabilities_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Tax_Applicabilities")
    public GetTaxApplicabilitiesResponseType getTaxApplicabilities(
        @WebParam(partName = "body", name = "Get_Tax_Applicabilities_Request", targetNamespace = "urn:com.workday/bsvc")
        GetTaxApplicabilitiesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Object Class Sets.  This operation will allow creation of  object classes as part of the Object Class Set. An Object Class Set and Object Class have to be unique and an Object Class cannot repeat within a Object Class Set or be part of multiple Object Class Sets.
     */
    @WebResult(name = "Put_Object_Class_Set_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Object_Class_Set")
    public PutObjectClassSetResponseType putObjectClassSet(
        @WebParam(partName = "body", name = "Put_Object_Class_Set_Request", targetNamespace = "urn:com.workday/bsvc")
        PutObjectClassSetRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Fund Hierarchies.  This operation will allow the addition of an existing Fund Hierarchy as the superior and the addition of existing Funds as subordinates.
     */
    @WebResult(name = "Put_Fund_Hierarchy_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Fund_Hierarchy")
    public PutFundHierarchyResponseType putFundHierarchy(
        @WebParam(partName = "body", name = "Put_Fund_Hierarchy_Request", targetNamespace = "urn:com.workday/bsvc")
        PutFundHierarchyRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates Gifts used as worktag values only.  To add or update a complete Gift definition, use the Submit Gift web service.
     */
    @WebResult(name = "Put_Basic_Gift_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Basic_Gift")
    public PutBasicGiftResponseType putBasicGift(
        @WebParam(partName = "body", name = "Put_Basic_Gift_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBasicGiftRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service will get 1099 Misc data.  The web service can either references to specific 1099 Misc instances or a reference to 1099 Electronic Filing Run and Company which will then return all related 1099 Misc instances.
     */
    @WebResult(name = "Get_1099_Miscs_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_1099_MISCs")
    public Get1099MiscsResponseType get1099MISCs(
        @WebParam(partName = "body", name = "Get_1099_Miscs_Request", targetNamespace = "urn:com.workday/bsvc")
        Get1099MiscsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will retrieve a specified Effort Certification Type (if specified) or will return all Effort Certification Types.
     */
    @WebResult(name = "Get_Effort_Certification_Types_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Effort_Certification_Types")
    public GetEffortCertificationTypesResponseType getEffortCertificationTypes(
        @WebParam(partName = "body", name = "Get_Effort_Certification_Types_Request", targetNamespace = "urn:com.workday/bsvc")
        GetEffortCertificationTypesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service allows you to add or update 1042-S Income Codes as well as Withholding Spend Categories or Hierarchies. Income Code for 1042-S data includes Withholding Spend Categories or Spend Category Hierarchies for all Income Codes, plus: Income Code, Description, Spend Categories or Spend Category Hierarchies.
     */
    @WebResult(name = "Put_1042-S_Income_Code_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_1042-S_Income_Code")
    public Put1042SIncomeCodeResponseType put1042SIncomeCode(
        @WebParam(partName = "body", name = "Put_1042-S_Income_Code_Request", targetNamespace = "urn:com.workday/bsvc")
        Put1042SIncomeCodeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Cancel Accounting Journal - This will kick off the Unpost Journal Business Process and once that is complete, it will automatically cancel the journal.
     */
    @WebResult(name = "Cancel_Accounting_Journal_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Cancel_Accounting_Journal")
    public CancelAccountingJournalResponseType cancelAccountingJournal(
        @WebParam(partName = "body", name = "Cancel_Accounting_Journal_Request", targetNamespace = "urn:com.workday/bsvc")
        CancelAccountingJournalRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Supplier Categories.  Supplier Category data includes the Supplier Category ID and the Supplier Category Name. Supplier Categories are used to maintain suppliers and apply accounting rules to procurement transactions.   You can also use Supplier categories when selecting or searching for Suppliers. All Suppliers must have one and only one category.
     */
    @WebResult(name = "Put_Supplier_Category_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Supplier_Category")
    public PutSupplierCategoryResponseType putSupplierCategory(
        @WebParam(partName = "body", name = "Put_Supplier_Category_Request", targetNamespace = "urn:com.workday/bsvc")
        PutSupplierCategoryRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Retrieves Gifts when they are used as worktag values only. Basic Grant data includes Gift ID, Gift Name, Include Gift ID in Name, Gift Type, Gift Purpose, Related Worktags, and Inactive status. The request criteria can be for a single transaction based on Reference ID. If no criteria is specified, the operation retrieves all transactions.
     */
    @WebResult(name = "Get_Basic_Gifts_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Basic_Gifts")
    public GetBasicGiftsResponseType getBasicGifts(
        @WebParam(partName = "body", name = "Get_Basic_Gifts_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBasicGiftsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Tax Codes for the specified criteria. Tax codes group together multiple tax rates. For example, you could create a tax code for San Francisco, and include city, state, and county sales tax rates. Tax Code data includes the Tax Code ID, Tax Code Name, and the Tax Rate.  The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Tax_Codes_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Tax_Codes")
    public GetTaxCodesResponseType getTaxCodes(
        @WebParam(partName = "body", name = "Get_Tax_Codes_Request", targetNamespace = "urn:com.workday/bsvc")
        GetTaxCodesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Budget Details, also referred to as Business Plan Details or Business Plan Entries.  Budget data includes the Company the Budget is for, the Budget Type and the Budget Year data.   Budget Year data includes the Budget Fiscal Year, the Year Status and the Budget Period. The Budget Period includes the Period status, and the Fiscal Period.
     */
    @WebResult(name = "Put_Business_Plan_Details_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Business_Plan_Details")
    public PutBusinessPlanDetailsResponseType putBusinessPlanDetails(
        @WebParam(partName = "body", name = "Put_Business_Plan_Details_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBusinessPlanDetailsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Gifts. This service will return the Gift and its associated information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Gifts_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Gifts")
    public GetGiftsResponseType getGifts(
        @WebParam(partName = "body", name = "Get_Gifts_Request", targetNamespace = "urn:com.workday/bsvc")
        GetGiftsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Payment Type.  Data includes ID, Payment Type Name, and Payment Method.
     */
    @WebResult(name = "Put_Payment_Type_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Payment_Type")
    public PutPaymentTypeResponseType putPaymentType(
        @WebParam(partName = "body", name = "Put_Payment_Type_Request", targetNamespace = "urn:com.workday/bsvc")
        PutPaymentTypeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update  Beginning Balance Journals.  Beginning Balance Journal data includes Company the journal is from, journal Currency, Currency Rate Type, Ledger Year, a Memo, Journal Source, Book Code and Journal Entry Line data.  Journal Entry Line data includes Inter Company Affiliate, Ledger Account, Debit Amount, Credit Amount, Currency, Currency Rate, Ledger Debit Amount, Ledger Credit Amount, Line Memo, and Worktags.  The Beginning Balance journal will be created for the first period of the Ledger Year provided.
     */
    @WebResult(name = "Put_Beginning_Balance_Journal_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Beginning_Balance_Journal")
    public PutBeginningBalanceJournalResponseType putBeginningBalanceJournal(
        @WebParam(partName = "body", name = "Put_Beginning_Balance_Journal_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBeginningBalanceJournalRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service will get 1099 Misc data for a reference to 1099 Electronic Filing Run.  It will return data for that entire 1099 Electronic Filing Run, which includes summary information by Payor.
     */
    @WebResult(name = "Get_1099_Electronic_Filing_Run_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Company_1099_MISC_Data")
    public Get1099ElectronicFilingRunResponseType getCompany1099MISCData(
        @WebParam(partName = "body", name = "Get_1099_Data_Request", targetNamespace = "urn:com.workday/bsvc")
        Get1099DataRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Tax Authorities. This service operation will get Tax Authorities for the specified criteria.  Tax Authorities are business entities.  Create a tax authority to pay sales taxes collected from customers. Tax Authority data includes Tax Authority ID, Tax Authority Reference ID, Tax Authority Name, and Business Entity data.  Business Entity data includes Name, Tax ID, External ID, Contact Information data, and Business Entity Logo. Contact Information data includes Address, Phone, Email, Instant Messenger and Web Address data.
     */
    @WebResult(name = "Put_Tax_Authority_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Tax_Authority")
    public PutTaxAuthorityResponseType putTaxAuthority(
        @WebParam(partName = "body", name = "Put_Tax_Authority_Request", targetNamespace = "urn:com.workday/bsvc")
        PutTaxAuthorityRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Spend Category Hierarchies for the specified criteria.  The request criteria can be for a single Spend Category Hierarchy based on Reference, Spend Category Hierarchy Name, or all Hierarchies can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Spend_Category_Hierarchies_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Spend_Category_Hierarchies")
    public GetSpendCategoryHierarchiesResponseType getSpendCategoryHierarchies(
        @WebParam(partName = "body", name = "Get_Spend_Category_Hierarchies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetSpendCategoryHierarchiesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service operation is designed to get or return all Effort Certification Eligibility Rules (Condition Rules) and dependencies.
     */
    @WebResult(name = "Get_Effort_Certification_Eligibility_Rules_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Effort_Certification_Eligibility_Rules")
    public GetEffortCertificationEligibilityRulesResponseType getEffortCertificationEligibilityRules(
        @WebParam(partName = "body", name = "Get_Effort_Certification_Eligibility_Rules_Request", targetNamespace = "urn:com.workday/bsvc")
        GetEffortCertificationEligibilityRulesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Retrieves Grants when they are used as worktag values only. Basic Grant data includes Grant ID, Grant Name, and Inactive status. The request criteria can be for a single transaction based on Reference ID. If no criteria is specified, the operation retrieves all transactions.
     */
    @WebResult(name = "Get_Basic_Grants_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Basic_Grants")
    public GetBasicGrantsResponseType getBasicGrants(
        @WebParam(partName = "body", name = "Get_Basic_Grants_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBasicGrantsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns Revenue Category Hierarchies according to its reference id, name, or all of them should no search criteria be provided.
     */
    @WebResult(name = "Get_Revenue_Category_Hierarchies_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Revenue_Category_Hierarchies")
    public GetRevenueCategoryHierarchiesResponseType getRevenueCategoryHierarchies(
        @WebParam(partName = "body", name = "Get_Revenue_Category_Hierarchies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetRevenueCategoryHierarchiesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns Grant Hierarchies and its associated information. The request criteria can be for a single transaction based on Reference ID. If a Reference ID is not specified, the operation retrieves all transactions.
     */
    @WebResult(name = "Get_Grant_Hierarchies_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Grant_Hierarchies")
    public GetGrantHierarchiesResponseType getGrantHierarchies(
        @WebParam(partName = "body", name = "Get_Grant_Hierarchies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetGrantHierarchiesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Budget Details asynchronously.  Budget data includes the Company the Budget is for, the Budget Type and the Budget Year data.   Budget Year data includes the Budget Fiscal Year, the Year Status and the Budget Period. The Budget Period includes the Period status, and the Fiscal Period.
     */
    @WebResult(name = "Put_Import_Process_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Import_Budget_Details")
    public PutImportProcessResponseType importBudgetDetails(
        @WebParam(partName = "body", name = "Import_Budget_Details_Request", targetNamespace = "urn:com.workday/bsvc")
        ImportBudgetDetailsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Funds. The Fund data includes a Name, ID, Include Fund ID in Name, Fund Type and the ability to create an Inactive Fund.
     */
    @WebResult(name = "Put_Fund_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Fund")
    public PutFundResponseType putFund(
        @WebParam(partName = "body", name = "Put_Fund_Request", targetNamespace = "urn:com.workday/bsvc")
        PutFundRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Statistic Definitions for the specified criteria.  Statistics Definition data includes the Name of the definition, Description, Fiscal Schedule, Required Dimensions, whether or not the definition requires Company, Statistic Type and whether or not the definition is Inactive. The request criteria can be for a single object based on Reference, or all data will be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Statistic_Definitions_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Statistic_Definitions")
    public GetStatisticDefinitionsResponseType getStatisticDefinitions(
        @WebParam(partName = "body", name = "Get_Statistic_Definitions_Request", targetNamespace = "urn:com.workday/bsvc")
        GetStatisticDefinitionsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Funds. This service will return the Fund and its associated information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Funds_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Funds")
    public GetFundsResponseType getFunds(
        @WebParam(partName = "body", name = "Get_Funds_Request", targetNamespace = "urn:com.workday/bsvc")
        GetFundsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Tax Codes.  Tax codes group together multiple tax rates. For example, you could create a tax code for San Francisco, and include city, state, and county sales tax rates. Tax Code data includes the Tax Code ID, Tax Code Name, and the Tax Rate.
     */
    @WebResult(name = "Put_Tax_Code_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Tax_Code")
    public PutTaxCodeResponseType putTaxCode(
        @WebParam(partName = "body", name = "Put_Tax_Code_Request", targetNamespace = "urn:com.workday/bsvc")
        PutTaxCodeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Payment Terms data for the specified criteria. Data includes Payment Terms ID, Payment Terms Name, Due Days, Payment Discount Days, Payment Discount Percent, and Grace Days. The request criteria can be for specific Payment Terms based on reference(s), or Payment Terms Name (partial match ok) search criteria.
     * 
     * If no criteria are specified, all Payment Terms will be retrieved.
     */
    @WebResult(name = "Get_Payment_Terms_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Payment_Terms")
    public GetPaymentTermsResponseType getPaymentTerms(
        @WebParam(partName = "body", name = "Get_Payment_Terms_Request", targetNamespace = "urn:com.workday/bsvc")
        GetPaymentTermsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Web Service to get position budgets created for Company, Business Plan Structure, Fiscal Year, Position, Employee and Version Status. The web service will return all business plan entry lines from the previous versions of the position budget requested. If no Position Budget Reference or Request Criteria is entered, the web service will return all latest Approved, Draft or In Progress position budgets. If a request criteria is entered, web service will return all position budgets matching the criteria. If a Position Budget reference is entered, web service will return the single instance of position budget requested.
     */
    @WebResult(name = "Get_Position_Budgets_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Position_Budgets")
    public GetPositionBudgetsResponseType getPositionBudgets(
        @WebParam(partName = "body", name = "Get_Position_Budgets_Request", targetNamespace = "urn:com.workday/bsvc")
        GetPositionBudgetsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will update existing Budgets, also referred to as Budget Entries. Budget data includes the Company the Budget is for, the Budget Type and the Budget Year data. Budget Year data includes the Budget Fiscal Year, the Year Status and the Budget Period. The Budget Period includes the Period status, and the Fiscal Period.
     */
    @WebResult(name = "Put_Budget_Incremental_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Budget_Incremental")
    public PutBudgetIncrementalResponseType putBudgetIncremental(
        @WebParam(partName = "body", name = "Put_Budget_Incremental_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBudgetIncrementalRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Tax Rates.  This service operation will get Tax Rates for the specified criteria. Tax Rates designate a tax percentage to apply to a tax authority and tax category. For example, you can establish a rate for California State sales tax of 6%.   Tax Rate data includes Tax Rate ID, Tax Rate Name, Tax Rate, Tax Authority and Tax Category.
     */
    @WebResult(name = "Put_Tax_Rate_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Tax_Rate")
    public PutTaxRateResponseType putTaxRate(
        @WebParam(partName = "body", name = "Put_Tax_Rate_Request", targetNamespace = "urn:com.workday/bsvc")
        PutTaxRateRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Fund Types. The Fund Type data includes a Name, ID, Include Fund Type ID in Name, Inactive Fund Type flag and a Fund Restriction.
     */
    @WebResult(name = "Put_Fund_Type_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Fund_Type")
    public PutFundTypeResponseType putFundType(
        @WebParam(partName = "body", name = "Put_Fund_Type_Request", targetNamespace = "urn:com.workday/bsvc")
        PutFundTypeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Accounting Journals and submit to the Accounting Journals business process.  Journals can be entered for month end adjustments, depreciation, or to record accrued liability for purchase items that have been received but not paid for. Journal entries for accruals can automatically be reversed. Workday creates journals behind the scenes for operational transactions, and uses posting rules to interpret the business events into debits and credits and accounts. Journal entries are posted to a ledger defined for each company.  Accounting Journal data includes Add Only option, Business Processing options, Accounting Journal ID, Submit for Approval flag, Locked in Workday flag,  Closed Period flag, Journal Number, Company, Currency, Ledger Type, Accounting Date, Journal Source, Memo, Adjustment Journal flag, Create Reversal flag, Control Total Amount, Currency Rate Type, Book Code, Journal Entry Line data and Attachment data. Journal Entry Line data includes Inter Company Affiliate, Ledger Account, Debit Amount, Credit Amount, Currency, Currency Rate, Ledger Debit Amount, Ledger Credit Amount, Line Memo, and Worktags.  The Get Journals web service operation will return both Accounting and Operational Journals.
     */
    @WebResult(name = "Submit_Accounting_Journal_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Submit_Accounting_Journal")
    public SubmitAccountingJournalResponseType submitAccountingJournal(
        @WebParam(partName = "body", name = "Submit_Accounting_Journal_Request", targetNamespace = "urn:com.workday/bsvc")
        SubmitAccountingJournalRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Used to get a Survey from the Workday system.
     */
    @WebResult(name = "Get_Surveys_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Surveys")
    public GetSurveysResponseType getSurveys(
        @WebParam(partName = "body", name = "Get_Surveys_Request", targetNamespace = "urn:com.workday/bsvc")
        GetSurveysRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update basic Customers that can be used as worktags only.  Basic Customer data includes reference ID, Name and an Inactive boolean.   Basic customers will be available as worktags, but can not be used on many financial transactions such as Customer Invoices that require fully configured customer. Use the Get Customers and Put Customers web services for maintaining full customer information.
     */
    @WebResult(name = "Put_Customer_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Basic_Customer")
    public PutCustomerResponseType putBasicCustomer(
        @WebParam(partName = "body", name = "Put_Basic_Customer_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBasicCustomerRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Payments for the specified criteria. The request criteria can be for a single payment based on Reference, or all payments for a specified company.
     */
    @WebResult(name = "Get_Payments_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Payments")
    public GetPaymentsResponseType getPayments(
        @WebParam(partName = "body", name = "Get_Payments_Request", targetNamespace = "urn:com.workday/bsvc")
        GetPaymentsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service will kick off the business process to unpost an accounting journal.
     */
    @WebResult(name = "Cancel_Accounting_Journal_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Unpost_Accounting_Journal")
    public CancelAccountingJournalResponseType unpostAccountingJournal(
        @WebParam(partName = "body", name = "Unpost_Accounting_Journal_Request", targetNamespace = "urn:com.workday/bsvc")
        UnpostAccountingJournalRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Account Sets for the specified criteria. This service will return the Account Set, the Ledger Accounts included in the Account Set, any included Account Sets, and the Chart of Accounts designation. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Account_Sets_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Account_Sets")
    public GetAccountSetsResponseType getAccountSets(
        @WebParam(partName = "body", name = "Get_Account_Sets_Request", targetNamespace = "urn:com.workday/bsvc")
        GetAccountSetsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get  Business Plan Details for the specified criteria.  Business Plan data includes the Company the Business Plan is form, the Business Plan Type and the Business Plan Year data.   Business Plan Year data includes the Business Plan Fiscal Year, the Year Status and the Business Plan Period. The Business Plan Period includes the Period status, and the Fiscal Period.  The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Business_Plan_Details_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Business_Plan_Details")
    public GetBusinessPlanDetailsResponseType getBusinessPlanDetails(
        @WebParam(partName = "body", name = "Get_Business_Plan_Details_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBusinessPlanDetailsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get basic Suppliers that can be used as worktags only. Basic Supplier data includes a Reference ID, Supplier Name, and Inactive boolean. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     * Basic Suppliers can not be used on financial transactions such as Supplier Invoices or Supplier Payments. Use the Get Suppliers web service for retrieving complete supplier definitions used by financial transactions.
     */
    @WebResult(name = "Get_Basic_Suppliers_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Basic_Suppliers")
    public GetBasicSuppliersResponseType getBasicSuppliers(
        @WebParam(partName = "body", name = "Get_Basic_Suppliers_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBasicSuppliersRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Account Sets.  This operation will allow creation of  ledger accounts, and organize them into sets of accounts. You can include one account set in another account set. You can also designate an account set as a chart of accounts.
     */
    @WebResult(name = "Put_Account_Set_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Account_Set")
    public PutAccountSetResponseType putAccountSet(
        @WebParam(partName = "body", name = "Put_Account_Set_Request", targetNamespace = "urn:com.workday/bsvc")
        PutAccountSetRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service operation will retrieve instances of Custom Validation Context. The response contains the reference to the Custom Validation Context returned, the Label, and Classification. Each Custom Valdiation Context can contain many Custom Validations,, which are made up of Condition Items that make up the logic used in the Custom Validations for each Rule type. On the web service request, you can specify a specific reference to a Custom Validation Context to return.
     */
    @WebResult(name = "Get_Custom_Validation_Rules_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Custom_Validation_Rules")
    public GetCustomValidationRulesResponseType getCustomValidationRules(
        @WebParam(partName = "body", name = "Get_Custom_Validation_Rules_Request", targetNamespace = "urn:com.workday/bsvc")
        GetCustomValidationRulesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Spend Category Hierarchies. This operation will allow for the addition of an existing Spend Category Hierarchies as the superiors/subordinates and addition of existing Spend Categories as subordinates.
     */
    @WebResult(name = "Put_Spend_Category_Hierarchy_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Spend_Category_Hierarchy")
    public PutSpendCategoryHierarchyResponseType putSpendCategoryHierarchy(
        @WebParam(partName = "body", name = "Put_Spend_Category_Hierarchy_Request", targetNamespace = "urn:com.workday/bsvc")
        PutSpendCategoryHierarchyRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Loan Investor Types. This service will return the Loan Investor type and its associated information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Loan_Investor_Types_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Loan_Investor_Types")
    public GetLoanInvestorTypesResponseType getLoanInvestorTypes(
        @WebParam(partName = "body", name = "Get_Loan_Investor_Types_Request", targetNamespace = "urn:com.workday/bsvc")
        GetLoanInvestorTypesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Revenue Categories. Revenue Category data includes Revenue Category ID, Name and Tax Applicability.
     */
    @WebResult(name = "Put_Revenue_Category_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Revenue_Category")
    public PutRevenueCategoryResponseType putRevenueCategory(
        @WebParam(partName = "body", name = "Put_Revenue_Category_Request", targetNamespace = "urn:com.workday/bsvc")
        PutRevenueCategoryRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Revenue Categories for the specified criteria. Revenue Category data includes Revenue Category ID, Name and Tax Applicability.  The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Revenue_Categories_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Revenue_Categories")
    public GetRevenueCategoriesResponseType getRevenueCategories(
        @WebParam(partName = "body", name = "Get_Revenue_Categories_Request", targetNamespace = "urn:com.workday/bsvc")
        GetRevenueCategoriesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add Translated Beginning Balance Amounts for the Beginning Balance Journal resolved from the criteria of: Company, Fiscal Year, Ledger Type. The Currency specified determines which amounts will be updated. 
     * 
     * The Beginning Balance Translation Amount Line Replacement Data updates values for lines that match the combination of Ledger Account, and Worktags. The Lines replace all lines defined for the beginning balance journal for the Currency that is specified on the request.
     */
    @WebResult(name = "Put_Beginning_Balance_Translation_Amounts_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Beginning_Balance_Translation_Amounts")
    public PutBeginningBalanceTranslationAmountsResponseType putBeginningBalanceTranslationAmounts(
        @WebParam(partName = "body", name = "Put_Beginning_Balance_Translation_Amounts_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBeginningBalanceTranslationAmountsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Tax Authorities for the specified criteria.  Tax Authorities are business entities.  Create a tax authority to pay sales taxes collected from customers. Tax Authority data includes Tax Authority ID, Tax Authority Reference ID, Tax Authority Name, and Business Entity data.  Business Entity data includes Name, Tax ID, External ID, Contact Information data, and Business Entity Logo. Contact Information data includes Address, Phone, Email, Instant Messenger and Web Address data.  The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Tax_Authorities_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Tax_Authorities")
    public GetTaxAuthoritiesResponseType getTaxAuthorities(
        @WebParam(partName = "body", name = "Get_Tax_Authorities_Request", targetNamespace = "urn:com.workday/bsvc")
        GetTaxAuthoritiesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Currency Conversion Rate.  Currency Conversion Rate data includes the Effective Timestamp, the From and Target Currencies, the Rate Type, and the Currency Rate.
     */
    @WebResult(name = "Put_Currency_Conversion_Rate_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Currency_Conversion_Rate")
    public PutCurrencyConversionRateResponseType putCurrencyConversionRate(
        @WebParam(partName = "body", name = "Put_Currency_Conversion_Rate_Request", targetNamespace = "urn:com.workday/bsvc")
        PutCurrencyConversionRateRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Allows the entry of Revenue Category Hierarchies which embody Revenue Categories and a can contain child Revenue Category Hierarchies.
     */
    @WebResult(name = "Put_Revenue_Category_Hierarchy_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Revenue_Category_Hierarchy")
    public PutRevenueCategoryHierarchyResponseType putRevenueCategoryHierarchy(
        @WebParam(partName = "body", name = "Put_Revenue_Category_Hierarchy_Request", targetNamespace = "urn:com.workday/bsvc")
        PutRevenueCategoryHierarchyRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Loan Referral types.
     */
    @WebResult(name = "Put_Loan_Referral_Type_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Loan_Referral_Type")
    public PutLoanReferralTypeResponseType putLoanReferralType(
        @WebParam(partName = "body", name = "Put_Loan_Referral_Type_Request", targetNamespace = "urn:com.workday/bsvc")
        PutLoanReferralTypeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Business Units. The Business Unit data includes a Name, ID, Include Business Unit ID in Name and the ability to create an Inactive Business Unit.
     */
    @WebResult(name = "Put_Business_Unit_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Business_Unit")
    public PutBusinessUnitResponseType putBusinessUnit(
        @WebParam(partName = "body", name = "Put_Business_Unit_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBusinessUnitRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Projects used as worktag values only.  
     * Use the Submit Workday Project web service to add or update complete Project definitions.
     */
    @WebResult(name = "Put_Project_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Basic_Project")
    public PutProjectResponseType putBasicProject(
        @WebParam(partName = "body", name = "Put_Basic_Project_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBasicProjectRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Business Entity Contacts.  The data includes the Business Entity Contact ID, the Business Entity the Contact is for (Supplier, Customer, Financial Institution or Tax Authority), the Personal Data including Name Detail data and Contact Information data.  Name Detail data includes formatted Name, Country, Prefix, First Name, Middle Name, Last Name, Secondary Last Name, and Name Suffix.  Contact Information data includes Address, Phone, Email, Instance Messenger and Web Address data.
     */
    @WebResult(name = "Put_Business_Entity_Contact_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Business_Entity_Contact")
    public PutBusinessEntityContactResponseType putBusinessEntityContact(
        @WebParam(partName = "body", name = "Put_Business_Entity_Contact_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBusinessEntityContactRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns organization information for a type of organization. If the request does not specify an organization, the operation returns information for all organizations.
     */
    @WebResult(name = "Get_Organizations_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Organizations")
    public GetOrganizationsResponseType getOrganizations(
        @WebParam(partName = "body", name = "Get_Organizations_Request", targetNamespace = "urn:com.workday/bsvc")
        GetOrganizationsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Recurring Journal Templates for the specified criteria.  Recurring Journal Templates allow you to create a journal template that can be used later to manually periodically create journals based off that template.  Recurring Journal Template data includes Recurring Journal Template ID, Template Name, Currency, Currency Rate Type, Ledger Reference, Template Start Date, Template End Date, flag indicating if journals created from a template should be automatically submitted, control total amount, journal source, company, and Journal Line Data. Journal Line Data includes Line Ordering, inter-company affiliate, ledger account, debit amount, credit amount, currency, ledger debit amount, ledger credit amount, memo and worktags.
     */
    @WebResult(name = "Put_Recurring_Journal_Template_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Recurring_Journal_Template")
    public PutRecurringJournalTemplateResponseType putRecurringJournalTemplate(
        @WebParam(partName = "body", name = "Put_Recurring_Journal_Template_Request", targetNamespace = "urn:com.workday/bsvc")
        PutRecurringJournalTemplateRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Receivable Writeoff Categories for the specified criteria. Receivable Writeoff Categories allow you to designate categories to describe receivables that you write off.  Receivable Writeoff Category data includes the Receivable Writeoff Category ID and the Receivable Writeoff Category Name.  The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     * 
     * In v14, Receivable Writeoff Category was renamed to Receivable Writeoff Reason. This name change is only reflected in the Workday application. The web service API still uses the name Receivable Writeoff Category.
     */
    @WebResult(name = "Get_Receivable_Writeoff_Categories_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Receivable_Writeoff_Categories")
    public GetReceivableWriteoffCategoriesResponseType getReceivableWriteoffCategories(
        @WebParam(partName = "body", name = "Get_Receivable_Writeoff_Categories_Request", targetNamespace = "urn:com.workday/bsvc")
        GetReceivableWriteoffCategoriesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Used to retrieve Award Personnel Responsibilities from the Workday system.
     */
    @WebResult(name = "Get_Award_Personnel_Responsibilities_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Award_Personnel_Responsibilities")
    public GetAwardPersonnelResponsibilitiesResponseType getAwardPersonnelResponsibilities(
        @WebParam(partName = "body", name = "Get_Award_Personnel_Responsibilities_Request", targetNamespace = "urn:com.workday/bsvc")
        GetAwardPersonnelResponsibilitiesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Loans. The Loan data includes a Loan Number, Customer, Vintage Date, First Referral Date, Property ID,  Investor Type, Referral Type, Country Region and the ability to create an Inactive loan.
     */
    @WebResult(name = "Put_Loan_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Loan")
    public PutLoanResponseType putLoan(
        @WebParam(partName = "body", name = "Put_Loan_Request", targetNamespace = "urn:com.workday/bsvc")
        PutLoanRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Object Class Sets for the specified criteria. This service will return the Object Class Set and the Object Classes included in the Object Class Set. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no reference is specified.
     */
    @WebResult(name = "Get_Object_Class_Sets_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Object_Class_Sets")
    public GetObjectClassSetsResponseType getObjectClassSets(
        @WebParam(partName = "body", name = "Get_Object_Class_Sets_Request", targetNamespace = "urn:com.workday/bsvc")
        GetObjectClassSetsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Tax Applicability.  Data includes Tax Applicability ID, Tax Applicability Code, Taxable, and Recoverable.
     */
    @WebResult(name = "Put_Tax_Applicability_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Tax_Applicability")
    public PutTaxApplicabilityResponseType putTaxApplicability(
        @WebParam(partName = "body", name = "Put_Tax_Applicability_Request", targetNamespace = "urn:com.workday/bsvc")
        PutTaxApplicabilityRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service provides the ability to get all of the translated beginning balance amounts for a tenant. 
     * 
     * The Translated Beginning Balance Amounts are broken out based on the translation currency of the lines for the combination of Company, Fiscal Year, Ledger Type, and Book Code.
     */
    @WebResult(name = "Get_Beginning_Balance_Translation_Amounts_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Beginning_Balance_Translation_Amounts")
    public GetBeginningBalanceTranslationAmountsResponseType getBeginningBalanceTranslationAmounts(
        @WebParam(partName = "body", name = "Get_Beginning_Balance_Translation_Amounts_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBeginningBalanceTranslationAmountsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service operation will retrieve instances of Custom Validation Rules. The response contains the reference to the Custom Validation Rules returned, the Label, and Classification. Each Custom Valiation Rule can contain many Condition Rules, which are made up of Condition Items that make up the logic used in the Custom Validations for each Rule type. On the web service request, you can specify a specific reference to a Custom Validation Rule to return. Condition Rules can refer to other Condition Rules, creating a nested structure of rules. This operation will ONLY return the top-most Condition Rules, and will not include any other rules referred to in the "Source Condition Rule" field.
     */
    @WebResult(name = "Get_Custom_Validation_Rules_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Custom_Validation_Rules_without_Dependencies")
    public GetCustomValidationRulesResponseType getCustomValidationRulesWithoutDependencies(
        @WebParam(partName = "body", name = "Get_Custom_Validation_Rules_without_Dependencies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetCustomValidationRulesWithoutDependenciesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Tax Rates for the specified criteria. Tax Rates designate a tax percentage to apply to a tax authority and tax category. For example, you can establish a rate for California State sales tax of 6%.   Tax Rate data includes Tax Rate ID, Tax Rate Name, Tax Rate, Tax Authority and Tax Category.  The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Tax_Rates_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Tax_Rates")
    public GetTaxRatesResponseType getTaxRates(
        @WebParam(partName = "body", name = "Get_Tax_Rates_Request", targetNamespace = "urn:com.workday/bsvc")
        GetTaxRatesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service allows you to add or update an Investor object. Data in the request includes Name, ID, Default Payment Type, Contact Information, Contacts, Attachments, Settlement Bank Account, and Alternate Names. When creating a new Investor, an existing Customer, Supplier, Tax Authority, or Financial Institution can be provided. If so, the existing Business Entity will be used in creating the new Investor.
     */
    @WebResult(name = "Put_Investor_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Investor")
    public PutInvestorResponseType putInvestor(
        @WebParam(partName = "body", name = "Put_Investor_Request", targetNamespace = "urn:com.workday/bsvc")
        PutInvestorRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update basic Suppliers that can be used as worktags only.  Basic supplier data includes Supplier ID, Supplier Name and an Inactive boolean.   Basic suppliers will be available as worktags, but can not be used on many financial transactions such as Supplier Invoices that require full supplier information. Use the Get Suppliers and Put Suppliers web services for maintaining full supplier information.
     */
    @WebResult(name = "Put_Supplier_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Basic_Supplier")
    public PutSupplierResponseType putBasicSupplier(
        @WebParam(partName = "body", name = "Put_Basic_Supplier_Request", targetNamespace = "urn:com.workday/bsvc")
        PutBasicSupplierRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Companies for the specified criteria. The company data includes Company Tax ID, Industry Code, Organization data, Contact Information data, Accounting data, and company specific Sequence Generators. Contact Information data includes Address, Phone, Email, Instance Messenger and Web Address data. Accounting data includes Fiscal Schedule, Account Set, Currency, Account Control Rule Set, Account Posting rule Set, Account Translation Rule Set, and the option to Reverse Debit/Credit or Keep Debit/Credit and Reverse sign.
     */
    @WebResult(name = "Get_Workday_Companies_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Workday_Companies")
    public GetWorkdayCompaniesResponseType getWorkdayCompanies(
        @WebParam(partName = "body", name = "Get_Workday_Companies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetWorkdayCompaniesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Business Unit Hierarchies. This service will return the Business Unit Hierarchies and its associated information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no Reference is specified.
     */
    @WebResult(name = "Get_Business_Unit_Hierarchies_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Business_Unit_Hierarchies")
    public GetBusinessUnitHierarchiesResponseType getBusinessUnitHierarchies(
        @WebParam(partName = "body", name = "Get_Business_Unit_Hierarchies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetBusinessUnitHierarchiesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Tax Categories.  Tax Category data includes Tax Category ID and Name.
     */
    @WebResult(name = "Put_Tax_Category_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Tax_Category")
    public PutTaxCategoryResponseType putTaxCategory(
        @WebParam(partName = "body", name = "Put_Tax_Category_Request", targetNamespace = "urn:com.workday/bsvc")
        PutTaxCategoryRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates multiple Currency Conversion Rates in a single request.
     * This operation is similar to the Put Currency Conversion Rate task, which adds or updates only a single currency per request.  
     * Currency Conversion Rate data includes the Effective Timestamp, the From and Target Currencies, the Rate Type, and the Currency Rate.
     */
    @WebResult(name = "Put_Currency_Conversion_Rates_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Currency_Conversion_Rates")
    public PutCurrencyConversionRatesResponseType putCurrencyConversionRates(
        @WebParam(partName = "body", name = "Put_Currency_Conversion_Rates_Request", targetNamespace = "urn:com.workday/bsvc")
        PutCurrencyConversionRatesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Currency Conversion Rates for the specified criteria. Currency Conversion Rate data includes the Effective Timestamp, the From and Target Currencies, the Rate Type, and the Currency Rate.  The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Currency_Conversion_Rates_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Currency_Conversion_Rates")
    public GetCurrencyConversionRatesResponseType getCurrencyConversionRates(
        @WebParam(partName = "body", name = "Get_Currency_Conversion_Rates_Request", targetNamespace = "urn:com.workday/bsvc")
        GetCurrencyConversionRatesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will add or update Position Budgets. 
     * 1. Web service to submit position budgets for a company, business plan structure, fiscal year, fiscal period and position. If an approved position budget exists, this service will create an amendment for the existing budget. When creating an amendment, enter the total amounts of the new budget for the compensation and fringe benefit amounts.
     * 2. If the latest position budget for the combination of company, business plan structure, fiscal year, fiscal period and position entered is In Progress or Draft, the service will update the existing position budget and not create an amendment. If Add Only is true, the service will not create a new amendment, the existing In Progress or Draft budget will first have to be approved.
     */
    @WebResult(name = "Submit_Position_Budget_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Submit_Position_Budget")
    public SubmitPositionBudgetResponseType submitPositionBudget(
        @WebParam(partName = "body", name = "Submit_Position_Budget_Request", targetNamespace = "urn:com.workday/bsvc")
        SubmitPositionBudgetRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This web service allows you to update Tax Authority Form Type for a ~Contingent Worker~ . Data in the request includes ID and Tax Authority Form Type Reference.
     */
    @WebResult(name = "Put_Contingent_Worker_Tax_Authority_Form_Type_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Contingent_Worker_Tax_Authority_Form_Type")
    public PutContingentWorkerTaxAuthorityFormTypeResponseType putContingentWorkerTaxAuthorityFormType(
        @WebParam(partName = "body", name = "Put_Contingent_Worker_Tax_Authority_Form_Type_Request", targetNamespace = "urn:com.workday/bsvc")
        PutContingentWorkerTaxAuthorityFormTypeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates Grants. Grant data includes a grant Name, ID, Include Grant ID in Name flag, Object Class Set, Facilities, and Administration Cost Schedule. The operation also gives you the ability to create an Inactive Grant.
     */
    @WebResult(name = "Put_Grant_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Grant")
    public PutGrantResponseType putGrant(
        @WebParam(partName = "body", name = "Put_Grant_Request", targetNamespace = "urn:com.workday/bsvc")
        PutGrantRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Account Sets for the specified criteria. This service will return the Account Set, the Ledger Accounts included in the Account Set, any included Account Sets, and the Chart of Accounts designation. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified. This Get request does not include the reflexive relationship to account set.
     */
    @WebResult(name = "Get_Account_Sets_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Account_Sets_Without_Dependencies")
    public GetAccountSetsResponseType getAccountSetsWithoutDependencies(
        @WebParam(partName = "body", name = "Get_Account_Sets_without_Dependencies_Request", targetNamespace = "urn:com.workday/bsvc")
        GetAccountSetsWithoutDependenciesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will import high volume Budget Amendments.
     */
    @WebResult(name = "Put_Import_Process_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Import_Budget_Amendment")
    public PutImportProcessResponseType importBudgetAmendment(
        @WebParam(partName = "body", name = "Import_Budget_Amendment_Request", targetNamespace = "urn:com.workday/bsvc")
        ImportBudgetAmendmentRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This service operation will get Customer Categories Types for the specified criteria.  Customer Category includes the Customer Category ID and Customer Category Name.   Customer categories are used to help determine accounting for transactions beyond what is defined in the posting rules. When processing a transaction, Workday finds the category on a customer and applies the accounting based on the category. You can also use customer categories when selecting or searching for customers. Each customer must have one customer category. You assign a customer to a customer categories when creating or editing a customer. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.
     */
    @WebResult(name = "Get_Customer_Categories_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Customer_Categories")
    public GetCustomerCategoriesResponseType getCustomerCategories(
        @WebParam(partName = "body", name = "Get_Customer_Categories_Request", targetNamespace = "urn:com.workday/bsvc")
        GetCustomerCategoriesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;
}
