
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains Effort Certification Type Data
 * 
 * <p>Java class for Effort_Certification_Type_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Effort_Certification_Type_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Effort_Certification_Type_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Effort_Certification_Type_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Effort_Certification_Type_Description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Group_By_Reference" type="{urn:com.workday/bsvc}Accounting_Worktag_TypeObjectType" maxOccurs="unbounded"/>
 *         &lt;element name="Subtotal_By_Accounting_Worktag_Type_Reference" type="{urn:com.workday/bsvc}Accounting_Worktag_TypeObjectType"/>
 *         &lt;element name="Hierarchy_Reference" type="{urn:com.workday/bsvc}Accounting_Worktag_Aggregation_DimensionObjectType" minOccurs="0"/>
 *         &lt;element name="Effort_Certifying_Text_Reference" type="{urn:com.workday/bsvc}Effort_Certifying_TextObjectType" minOccurs="0"/>
 *         &lt;element name="Display_Compensation_Amounts" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Use_Full_Worktags" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Survey_Reference" type="{urn:com.workday/bsvc}SurveyObjectType" minOccurs="0"/>
 *         &lt;element name="Employee_Eligibility_Rule_Reference" type="{urn:com.workday/bsvc}Effort_Certification_Eligibility_RuleObjectType"/>
 *         &lt;element name="Pay_Component_Group_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Payroll_Actuals_Costed_To_Selection" type="{urn:com.workday/bsvc}Payroll_Costed_Actuals_Filter_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Effort_Certification_Type_DataType", propOrder = {
    "effortCertificationTypeID",
    "effortCertificationTypeName",
    "effortCertificationTypeDescription",
    "groupByReference",
    "subtotalByAccountingWorktagTypeReference",
    "hierarchyReference",
    "effortCertifyingTextReference",
    "displayCompensationAmounts",
    "useFullWorktags",
    "surveyReference",
    "employeeEligibilityRuleReference",
    "payComponentGroupReference",
    "payrollActualsCostedToSelection"
})
public class EffortCertificationTypeDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Effort_Certification_Type_ID")
    protected String effortCertificationTypeID;
    @XmlElement(name = "Effort_Certification_Type_Name", required = true)
    protected String effortCertificationTypeName;
    @XmlElement(name = "Effort_Certification_Type_Description")
    protected String effortCertificationTypeDescription;
    @XmlElement(name = "Group_By_Reference", required = true)
    protected List<AccountingWorktagTypeObjectType> groupByReference;
    @XmlElement(name = "Subtotal_By_Accounting_Worktag_Type_Reference", required = true)
    protected AccountingWorktagTypeObjectType subtotalByAccountingWorktagTypeReference;
    @XmlElement(name = "Hierarchy_Reference")
    protected AccountingWorktagAggregationDimensionObjectType hierarchyReference;
    @XmlElement(name = "Effort_Certifying_Text_Reference")
    protected EffortCertifyingTextObjectType effortCertifyingTextReference;
    @XmlElement(name = "Display_Compensation_Amounts")
    protected Boolean displayCompensationAmounts;
    @XmlElement(name = "Use_Full_Worktags")
    protected Boolean useFullWorktags;
    @XmlElement(name = "Survey_Reference")
    protected SurveyObjectType surveyReference;
    @XmlElement(name = "Employee_Eligibility_Rule_Reference", required = true)
    protected EffortCertificationEligibilityRuleObjectType employeeEligibilityRuleReference;
    @XmlElement(name = "Pay_Component_Group_Reference")
    protected UniqueIdentifierObjectType payComponentGroupReference;
    @XmlElement(name = "Payroll_Actuals_Costed_To_Selection")
    protected List<PayrollCostedActualsFilterDataType> payrollActualsCostedToSelection;

    /**
     * Gets the value of the effortCertificationTypeID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEffortCertificationTypeID() {
        return effortCertificationTypeID;
    }

    /**
     * Sets the value of the effortCertificationTypeID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEffortCertificationTypeID(String value) {
        this.effortCertificationTypeID = value;
    }

    /**
     * Gets the value of the effortCertificationTypeName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEffortCertificationTypeName() {
        return effortCertificationTypeName;
    }

    /**
     * Sets the value of the effortCertificationTypeName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEffortCertificationTypeName(String value) {
        this.effortCertificationTypeName = value;
    }

    /**
     * Gets the value of the effortCertificationTypeDescription property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEffortCertificationTypeDescription() {
        return effortCertificationTypeDescription;
    }

    /**
     * Sets the value of the effortCertificationTypeDescription property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEffortCertificationTypeDescription(String value) {
        this.effortCertificationTypeDescription = value;
    }

    /**
     * Gets the value of the groupByReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the groupByReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGroupByReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagTypeObjectType }
     * 
     * 
     */
    public List<AccountingWorktagTypeObjectType> getGroupByReference() {
        if (groupByReference == null) {
            groupByReference = new ArrayList<AccountingWorktagTypeObjectType>();
        }
        return this.groupByReference;
    }

    /**
     * Gets the value of the subtotalByAccountingWorktagTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountingWorktagTypeObjectType }
     *     
     */
    public AccountingWorktagTypeObjectType getSubtotalByAccountingWorktagTypeReference() {
        return subtotalByAccountingWorktagTypeReference;
    }

    /**
     * Sets the value of the subtotalByAccountingWorktagTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountingWorktagTypeObjectType }
     *     
     */
    public void setSubtotalByAccountingWorktagTypeReference(AccountingWorktagTypeObjectType value) {
        this.subtotalByAccountingWorktagTypeReference = value;
    }

    /**
     * Gets the value of the hierarchyReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountingWorktagAggregationDimensionObjectType }
     *     
     */
    public AccountingWorktagAggregationDimensionObjectType getHierarchyReference() {
        return hierarchyReference;
    }

    /**
     * Sets the value of the hierarchyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountingWorktagAggregationDimensionObjectType }
     *     
     */
    public void setHierarchyReference(AccountingWorktagAggregationDimensionObjectType value) {
        this.hierarchyReference = value;
    }

    /**
     * Gets the value of the effortCertifyingTextReference property.
     * 
     * @return
     *     possible object is
     *     {@link EffortCertifyingTextObjectType }
     *     
     */
    public EffortCertifyingTextObjectType getEffortCertifyingTextReference() {
        return effortCertifyingTextReference;
    }

    /**
     * Sets the value of the effortCertifyingTextReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EffortCertifyingTextObjectType }
     *     
     */
    public void setEffortCertifyingTextReference(EffortCertifyingTextObjectType value) {
        this.effortCertifyingTextReference = value;
    }

    /**
     * Gets the value of the displayCompensationAmounts property.
     * This getter has been renamed from isDisplayCompensationAmounts() to getDisplayCompensationAmounts() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getDisplayCompensationAmounts() {
        return displayCompensationAmounts;
    }

    /**
     * Sets the value of the displayCompensationAmounts property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDisplayCompensationAmounts(Boolean value) {
        this.displayCompensationAmounts = value;
    }

    /**
     * Gets the value of the useFullWorktags property.
     * This getter has been renamed from isUseFullWorktags() to getUseFullWorktags() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getUseFullWorktags() {
        return useFullWorktags;
    }

    /**
     * Sets the value of the useFullWorktags property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setUseFullWorktags(Boolean value) {
        this.useFullWorktags = value;
    }

    /**
     * Gets the value of the surveyReference property.
     * 
     * @return
     *     possible object is
     *     {@link SurveyObjectType }
     *     
     */
    public SurveyObjectType getSurveyReference() {
        return surveyReference;
    }

    /**
     * Sets the value of the surveyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SurveyObjectType }
     *     
     */
    public void setSurveyReference(SurveyObjectType value) {
        this.surveyReference = value;
    }

    /**
     * Gets the value of the employeeEligibilityRuleReference property.
     * 
     * @return
     *     possible object is
     *     {@link EffortCertificationEligibilityRuleObjectType }
     *     
     */
    public EffortCertificationEligibilityRuleObjectType getEmployeeEligibilityRuleReference() {
        return employeeEligibilityRuleReference;
    }

    /**
     * Sets the value of the employeeEligibilityRuleReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EffortCertificationEligibilityRuleObjectType }
     *     
     */
    public void setEmployeeEligibilityRuleReference(EffortCertificationEligibilityRuleObjectType value) {
        this.employeeEligibilityRuleReference = value;
    }

    /**
     * Gets the value of the payComponentGroupReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getPayComponentGroupReference() {
        return payComponentGroupReference;
    }

    /**
     * Sets the value of the payComponentGroupReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setPayComponentGroupReference(UniqueIdentifierObjectType value) {
        this.payComponentGroupReference = value;
    }

    /**
     * Gets the value of the payrollActualsCostedToSelection property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the payrollActualsCostedToSelection property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayrollActualsCostedToSelection().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollCostedActualsFilterDataType }
     * 
     * 
     */
    public List<PayrollCostedActualsFilterDataType> getPayrollActualsCostedToSelection() {
        if (payrollActualsCostedToSelection == null) {
            payrollActualsCostedToSelection = new ArrayList<PayrollCostedActualsFilterDataType>();
        }
        return this.payrollActualsCostedToSelection;
    }

    /**
     * Sets the value of the groupByReference property.
     * 
     * @param groupByReference
     *     allowed object is
     *     {@link AccountingWorktagTypeObjectType }
     *     
     */
    public void setGroupByReference(List<AccountingWorktagTypeObjectType> groupByReference) {
        this.groupByReference = groupByReference;
    }

    /**
     * Sets the value of the payrollActualsCostedToSelection property.
     * 
     * @param payrollActualsCostedToSelection
     *     allowed object is
     *     {@link PayrollCostedActualsFilterDataType }
     *     
     */
    public void setPayrollActualsCostedToSelection(List<PayrollCostedActualsFilterDataType> payrollActualsCostedToSelection) {
        this.payrollActualsCostedToSelection = payrollActualsCostedToSelection;
    }

}
