
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Customer Reference element contains the specific instance set containing the requested Customer.  The ID is either the Lookup ID or the Workday ID (GUID).
 * 
 * <p>Java class for Customer_Request_ReferencesType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Customer_Request_ReferencesType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Customer_Reference" type="{urn:com.workday/bsvc}CustomerObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Customer_Request_ReferencesType", propOrder = {
    "customerReference"
})
public class CustomerRequestReferencesType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Customer_Reference")
    protected List<CustomerObjectType> customerReference;

    /**
     * Gets the value of the customerReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the customerReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCustomerReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CustomerObjectType }
     * 
     * 
     */
    public List<CustomerObjectType> getCustomerReference() {
        if (customerReference == null) {
            customerReference = new ArrayList<CustomerObjectType>();
        }
        return this.customerReference;
    }

    /**
     * Sets the value of the customerReference property.
     * 
     * @param customerReference
     *     allowed object is
     *     {@link CustomerObjectType }
     *     
     */
    public void setCustomerReference(List<CustomerObjectType> customerReference) {
        this.customerReference = customerReference;
    }

}
