
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Element containing Currency Conversion Rate reference for update and all Currency Conversion Rate data items
 * 
 * <p>Java class for Currency_Conversion_Rate_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Currency_Conversion_Rate_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Effective_Timestamp" type="{http://www.w3.org/2001/XMLSchema}dateTime"/>
 *         &lt;element name="From_Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType"/>
 *         &lt;element name="Target_Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType"/>
 *         &lt;element name="Currency_Rate_Type_Reference" type="{urn:com.workday/bsvc}Currency_Rate_TypeObjectType"/>
 *         &lt;element name="Currency_Rate">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Currency_Conversion_Rate_DataType", propOrder = {
    "effectiveTimestamp",
    "fromCurrencyReference",
    "targetCurrencyReference",
    "currencyRateTypeReference",
    "currencyRate"
})
public class CurrencyConversionRateDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Effective_Timestamp", required = true)
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar effectiveTimestamp;
    @XmlElement(name = "From_Currency_Reference", required = true)
    protected CurrencyObjectType fromCurrencyReference;
    @XmlElement(name = "Target_Currency_Reference", required = true)
    protected CurrencyObjectType targetCurrencyReference;
    @XmlElement(name = "Currency_Rate_Type_Reference", required = true)
    protected CurrencyRateTypeObjectType currencyRateTypeReference;
    @XmlElement(name = "Currency_Rate", required = true)
    protected BigDecimal currencyRate;

    /**
     * Gets the value of the effectiveTimestamp property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEffectiveTimestamp() {
        return effectiveTimestamp;
    }

    /**
     * Sets the value of the effectiveTimestamp property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEffectiveTimestamp(XMLGregorianCalendar value) {
        this.effectiveTimestamp = value;
    }

    /**
     * Gets the value of the fromCurrencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getFromCurrencyReference() {
        return fromCurrencyReference;
    }

    /**
     * Sets the value of the fromCurrencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setFromCurrencyReference(CurrencyObjectType value) {
        this.fromCurrencyReference = value;
    }

    /**
     * Gets the value of the targetCurrencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getTargetCurrencyReference() {
        return targetCurrencyReference;
    }

    /**
     * Sets the value of the targetCurrencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setTargetCurrencyReference(CurrencyObjectType value) {
        this.targetCurrencyReference = value;
    }

    /**
     * Gets the value of the currencyRateTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyRateTypeObjectType }
     *     
     */
    public CurrencyRateTypeObjectType getCurrencyRateTypeReference() {
        return currencyRateTypeReference;
    }

    /**
     * Sets the value of the currencyRateTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyRateTypeObjectType }
     *     
     */
    public void setCurrencyRateTypeReference(CurrencyRateTypeObjectType value) {
        this.currencyRateTypeReference = value;
    }

    /**
     * Gets the value of the currencyRate property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getCurrencyRate() {
        return currencyRate;
    }

    /**
     * Sets the value of the currencyRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setCurrencyRate(BigDecimal value) {
        this.currencyRate = value;
    }

}
