
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Element containing all Cost Center data.
 * 
 * <p>Java class for Cost_Center_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Cost_Center_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Organization_Data" type="{urn:com.workday/bsvc}Organization_Common_DataType"/>
 *         &lt;element name="Organization_Subtype_Reference" type="{urn:com.workday/bsvc}Organization_SubtypeObjectType"/>
 *         &lt;element name="Organization_Container_Reference" type="{urn:com.workday/bsvc}Custom_OrganizationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Related_Worktags_for_Cost_Center_Data" type="{urn:com.workday/bsvc}Related_Worktags_for_Webservices_EditType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="Effective_Date" type="{http://www.w3.org/2001/XMLSchema}date" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Cost_Center_DataType", propOrder = {
    "organizationData",
    "organizationSubtypeReference",
    "organizationContainerReference",
    "relatedWorktagsForCostCenterData"
})
public class CostCenterDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Organization_Data", required = true)
    protected OrganizationCommonDataType organizationData;
    @XmlElement(name = "Organization_Subtype_Reference", required = true)
    protected OrganizationSubtypeObjectType organizationSubtypeReference;
    @XmlElement(name = "Organization_Container_Reference")
    protected List<CustomOrganizationObjectType> organizationContainerReference;
    @XmlElement(name = "Related_Worktags_for_Cost_Center_Data")
    protected List<RelatedWorktagsForWebservicesEditType> relatedWorktagsForCostCenterData;
    @XmlAttribute(name = "Effective_Date", namespace = "urn:com.workday/bsvc")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar effectiveDate;

    /**
     * Gets the value of the organizationData property.
     * 
     * @return
     *     possible object is
     *     {@link OrganizationCommonDataType }
     *     
     */
    public OrganizationCommonDataType getOrganizationData() {
        return organizationData;
    }

    /**
     * Sets the value of the organizationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrganizationCommonDataType }
     *     
     */
    public void setOrganizationData(OrganizationCommonDataType value) {
        this.organizationData = value;
    }

    /**
     * Gets the value of the organizationSubtypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public OrganizationSubtypeObjectType getOrganizationSubtypeReference() {
        return organizationSubtypeReference;
    }

    /**
     * Sets the value of the organizationSubtypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public void setOrganizationSubtypeReference(OrganizationSubtypeObjectType value) {
        this.organizationSubtypeReference = value;
    }

    /**
     * Gets the value of the organizationContainerReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the organizationContainerReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOrganizationContainerReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CustomOrganizationObjectType }
     * 
     * 
     */
    public List<CustomOrganizationObjectType> getOrganizationContainerReference() {
        if (organizationContainerReference == null) {
            organizationContainerReference = new ArrayList<CustomOrganizationObjectType>();
        }
        return this.organizationContainerReference;
    }

    /**
     * Gets the value of the relatedWorktagsForCostCenterData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the relatedWorktagsForCostCenterData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRelatedWorktagsForCostCenterData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RelatedWorktagsForWebservicesEditType }
     * 
     * 
     */
    public List<RelatedWorktagsForWebservicesEditType> getRelatedWorktagsForCostCenterData() {
        if (relatedWorktagsForCostCenterData == null) {
            relatedWorktagsForCostCenterData = new ArrayList<RelatedWorktagsForWebservicesEditType>();
        }
        return this.relatedWorktagsForCostCenterData;
    }

    /**
     * Gets the value of the effectiveDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * Sets the value of the effectiveDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEffectiveDate(XMLGregorianCalendar value) {
        this.effectiveDate = value;
    }

    /**
     * Sets the value of the organizationContainerReference property.
     * 
     * @param organizationContainerReference
     *     allowed object is
     *     {@link CustomOrganizationObjectType }
     *     
     */
    public void setOrganizationContainerReference(List<CustomOrganizationObjectType> organizationContainerReference) {
        this.organizationContainerReference = organizationContainerReference;
    }

    /**
     * Sets the value of the relatedWorktagsForCostCenterData property.
     * 
     * @param relatedWorktagsForCostCenterData
     *     allowed object is
     *     {@link RelatedWorktagsForWebservicesEditType }
     *     
     */
    public void setRelatedWorktagsForCostCenterData(List<RelatedWorktagsForWebservicesEditType> relatedWorktagsForCostCenterData) {
        this.relatedWorktagsForCostCenterData = relatedWorktagsForCostCenterData;
    }

}
