
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper element containing data for each Condition Item.
 * 
 * <p>Java class for Condition_Item_Data_WWSType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Condition_Item_Data_WWSType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Order">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *               &lt;maxLength value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="And_Or_Operator_Reference" type="{urn:com.workday/bsvc}And_Or_OperatorsObjectType"/>
 *         &lt;element name="Open_Parentheses" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Relational_Operator_Reference" type="{urn:com.workday/bsvc}Relational_OperatorObjectType"/>
 *         &lt;element name="Condition_Entry_Option_Reference" type="{urn:com.workday/bsvc}Condition_Entry_OptionObjectType" minOccurs="0"/>
 *         &lt;element name="Close_Parentheses" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Source_External_Field_Reference" type="{urn:com.workday/bsvc}External_FieldObjectType" minOccurs="0"/>
 *           &lt;element name="Source_Condition_Rule_Reference" type="{urn:com.workday/bsvc}Condition_RuleObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;choice>
 *           &lt;element name="Filter_Boolean" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *           &lt;element name="Filter_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *           &lt;element name="Filter_DateTimeZone" type="{urn:com.workday/bsvc}Filter_DateTimeZone_DataType" minOccurs="0"/>
 *           &lt;element name="Filter_Time" type="{http://www.w3.org/2001/XMLSchema}time" minOccurs="0"/>
 *           &lt;element name="Filter_Number" minOccurs="0">
 *             &lt;simpleType>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *                 &lt;totalDigits value="16"/>
 *                 &lt;fractionDigits value="4"/>
 *               &lt;/restriction>
 *             &lt;/simpleType>
 *           &lt;/element>
 *           &lt;element name="Filter_Text" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *           &lt;element name="Target_External_Field_Reference" type="{urn:com.workday/bsvc}External_FieldObjectType" minOccurs="0"/>
 *           &lt;element name="Target_Instance_Reference" type="{urn:com.workday/bsvc}InstanceObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Condition_Item_Data_WWSType", propOrder = {
    "order",
    "andOrOperatorReference",
    "openParentheses",
    "relationalOperatorReference",
    "conditionEntryOptionReference",
    "closeParentheses",
    "sourceExternalFieldReference",
    "sourceConditionRuleReference",
    "filterBoolean",
    "filterDate",
    "filterDateTimeZone",
    "filterTime",
    "filterNumber",
    "filterText",
    "targetExternalFieldReference",
    "targetInstanceReference"
})
public class ConditionItemDataWWSType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Order", required = true)
    protected String order;
    @XmlElement(name = "And_Or_Operator_Reference", required = true)
    protected AndOrOperatorsObjectType andOrOperatorReference;
    @XmlElement(name = "Open_Parentheses")
    protected String openParentheses;
    @XmlElement(name = "Relational_Operator_Reference", required = true)
    protected RelationalOperatorObjectType relationalOperatorReference;
    @XmlElement(name = "Condition_Entry_Option_Reference")
    protected ConditionEntryOptionObjectType conditionEntryOptionReference;
    @XmlElement(name = "Close_Parentheses")
    protected String closeParentheses;
    @XmlElement(name = "Source_External_Field_Reference")
    protected ExternalFieldObjectType sourceExternalFieldReference;
    @XmlElement(name = "Source_Condition_Rule_Reference")
    protected ConditionRuleObjectType sourceConditionRuleReference;
    @XmlElement(name = "Filter_Boolean")
    protected Boolean filterBoolean;
    @XmlElement(name = "Filter_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar filterDate;
    @XmlElement(name = "Filter_DateTimeZone")
    protected FilterDateTimeZoneDataType filterDateTimeZone;
    @XmlElement(name = "Filter_Time")
    @XmlSchemaType(name = "time")
    protected XMLGregorianCalendar filterTime;
    @XmlElement(name = "Filter_Number")
    protected BigDecimal filterNumber;
    @XmlElement(name = "Filter_Text")
    protected String filterText;
    @XmlElement(name = "Target_External_Field_Reference")
    protected ExternalFieldObjectType targetExternalFieldReference;
    @XmlElement(name = "Target_Instance_Reference")
    protected List<InstanceObjectType> targetInstanceReference;

    /**
     * Gets the value of the order property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrder() {
        return order;
    }

    /**
     * Sets the value of the order property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrder(String value) {
        this.order = value;
    }

    /**
     * Gets the value of the andOrOperatorReference property.
     * 
     * @return
     *     possible object is
     *     {@link AndOrOperatorsObjectType }
     *     
     */
    public AndOrOperatorsObjectType getAndOrOperatorReference() {
        return andOrOperatorReference;
    }

    /**
     * Sets the value of the andOrOperatorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AndOrOperatorsObjectType }
     *     
     */
    public void setAndOrOperatorReference(AndOrOperatorsObjectType value) {
        this.andOrOperatorReference = value;
    }

    /**
     * Gets the value of the openParentheses property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOpenParentheses() {
        return openParentheses;
    }

    /**
     * Sets the value of the openParentheses property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOpenParentheses(String value) {
        this.openParentheses = value;
    }

    /**
     * Gets the value of the relationalOperatorReference property.
     * 
     * @return
     *     possible object is
     *     {@link RelationalOperatorObjectType }
     *     
     */
    public RelationalOperatorObjectType getRelationalOperatorReference() {
        return relationalOperatorReference;
    }

    /**
     * Sets the value of the relationalOperatorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link RelationalOperatorObjectType }
     *     
     */
    public void setRelationalOperatorReference(RelationalOperatorObjectType value) {
        this.relationalOperatorReference = value;
    }

    /**
     * Gets the value of the conditionEntryOptionReference property.
     * 
     * @return
     *     possible object is
     *     {@link ConditionEntryOptionObjectType }
     *     
     */
    public ConditionEntryOptionObjectType getConditionEntryOptionReference() {
        return conditionEntryOptionReference;
    }

    /**
     * Sets the value of the conditionEntryOptionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConditionEntryOptionObjectType }
     *     
     */
    public void setConditionEntryOptionReference(ConditionEntryOptionObjectType value) {
        this.conditionEntryOptionReference = value;
    }

    /**
     * Gets the value of the closeParentheses property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCloseParentheses() {
        return closeParentheses;
    }

    /**
     * Sets the value of the closeParentheses property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCloseParentheses(String value) {
        this.closeParentheses = value;
    }

    /**
     * Gets the value of the sourceExternalFieldReference property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalFieldObjectType }
     *     
     */
    public ExternalFieldObjectType getSourceExternalFieldReference() {
        return sourceExternalFieldReference;
    }

    /**
     * Sets the value of the sourceExternalFieldReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalFieldObjectType }
     *     
     */
    public void setSourceExternalFieldReference(ExternalFieldObjectType value) {
        this.sourceExternalFieldReference = value;
    }

    /**
     * Gets the value of the sourceConditionRuleReference property.
     * 
     * @return
     *     possible object is
     *     {@link ConditionRuleObjectType }
     *     
     */
    public ConditionRuleObjectType getSourceConditionRuleReference() {
        return sourceConditionRuleReference;
    }

    /**
     * Sets the value of the sourceConditionRuleReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConditionRuleObjectType }
     *     
     */
    public void setSourceConditionRuleReference(ConditionRuleObjectType value) {
        this.sourceConditionRuleReference = value;
    }

    /**
     * Gets the value of the filterBoolean property.
     * This getter has been renamed from isFilterBoolean() to getFilterBoolean() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getFilterBoolean() {
        return filterBoolean;
    }

    /**
     * Sets the value of the filterBoolean property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setFilterBoolean(Boolean value) {
        this.filterBoolean = value;
    }

    /**
     * Gets the value of the filterDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getFilterDate() {
        return filterDate;
    }

    /**
     * Sets the value of the filterDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setFilterDate(XMLGregorianCalendar value) {
        this.filterDate = value;
    }

    /**
     * Gets the value of the filterDateTimeZone property.
     * 
     * @return
     *     possible object is
     *     {@link FilterDateTimeZoneDataType }
     *     
     */
    public FilterDateTimeZoneDataType getFilterDateTimeZone() {
        return filterDateTimeZone;
    }

    /**
     * Sets the value of the filterDateTimeZone property.
     * 
     * @param value
     *     allowed object is
     *     {@link FilterDateTimeZoneDataType }
     *     
     */
    public void setFilterDateTimeZone(FilterDateTimeZoneDataType value) {
        this.filterDateTimeZone = value;
    }

    /**
     * Gets the value of the filterTime property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getFilterTime() {
        return filterTime;
    }

    /**
     * Sets the value of the filterTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setFilterTime(XMLGregorianCalendar value) {
        this.filterTime = value;
    }

    /**
     * Gets the value of the filterNumber property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFilterNumber() {
        return filterNumber;
    }

    /**
     * Sets the value of the filterNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFilterNumber(BigDecimal value) {
        this.filterNumber = value;
    }

    /**
     * Gets the value of the filterText property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFilterText() {
        return filterText;
    }

    /**
     * Sets the value of the filterText property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFilterText(String value) {
        this.filterText = value;
    }

    /**
     * Gets the value of the targetExternalFieldReference property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalFieldObjectType }
     *     
     */
    public ExternalFieldObjectType getTargetExternalFieldReference() {
        return targetExternalFieldReference;
    }

    /**
     * Sets the value of the targetExternalFieldReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalFieldObjectType }
     *     
     */
    public void setTargetExternalFieldReference(ExternalFieldObjectType value) {
        this.targetExternalFieldReference = value;
    }

    /**
     * Gets the value of the targetInstanceReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the targetInstanceReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTargetInstanceReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link InstanceObjectType }
     * 
     * 
     */
    public List<InstanceObjectType> getTargetInstanceReference() {
        if (targetInstanceReference == null) {
            targetInstanceReference = new ArrayList<InstanceObjectType>();
        }
        return this.targetInstanceReference;
    }

    /**
     * Sets the value of the targetInstanceReference property.
     * 
     * @param targetInstanceReference
     *     allowed object is
     *     {@link InstanceObjectType }
     *     
     */
    public void setTargetInstanceReference(List<InstanceObjectType> targetInstanceReference) {
        this.targetInstanceReference = targetInstanceReference;
    }

}
