
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Element containing all Company data
 * 
 * <p>Java class for Company_WWS_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Company_WWS_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Transaction_Tax_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Tax_ID_Data" type="{urn:com.workday/bsvc}Tax_ID_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Industry_Code_Data" type="{urn:com.workday/bsvc}Industry_Code_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Workers_Compensation_Carrier_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Organization_Data" type="{urn:com.workday/bsvc}Organization_Common_DataType"/>
 *         &lt;element name="Organization_Subtype_Reference" type="{urn:com.workday/bsvc}Organization_SubtypeObjectType"/>
 *         &lt;element name="Organization_Container_Reference" type="{urn:com.workday/bsvc}Custom_OrganizationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Contact_Data" type="{urn:com.workday/bsvc}Contact_Information_DataType" minOccurs="0"/>
 *         &lt;element name="Accounting_Data" type="{urn:com.workday/bsvc}Company_Accounting_Details_DataType" minOccurs="0"/>
 *         &lt;element name="Customer_Payment_Auto_Application_Configuration_Data" type="{urn:com.workday/bsvc}Company_Customer_Payment_Auto_Application_Configuration_DataType" minOccurs="0"/>
 *         &lt;element name="Customer_Contract_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Award_Contract_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Award_Proposal_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Customer_Invoice_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Supplier_Invoice_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Customer_Refund_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Journal_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Requisition_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Purchase_Order_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Receipt_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Spend_Authorization_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Expense_Reports_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Supplier_Contracts_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Settlement_Run_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Prenote_Run_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Receipt_Accrual_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Outsourced_Payment_Group_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *         &lt;element name="Procurement_Card_Transaction_Verification_Sequence_Generator_Reference" type="{urn:com.workday/bsvc}Sequence_GeneratorObjectType" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="Effective_Date" type="{http://www.w3.org/2001/XMLSchema}date" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Company_WWS_DataType", propOrder = {
    "transactionTaxID",
    "taxIDData",
    "industryCodeData",
    "workersCompensationCarrierReference",
    "organizationData",
    "organizationSubtypeReference",
    "organizationContainerReference",
    "contactData",
    "accountingData",
    "customerPaymentAutoApplicationConfigurationData",
    "customerContractSequenceGeneratorReference",
    "awardContractSequenceGeneratorReference",
    "awardProposalSequenceGeneratorReference",
    "customerInvoiceSequenceGeneratorReference",
    "supplierInvoiceSequenceGeneratorReference",
    "customerRefundSequenceGeneratorReference",
    "journalSequenceGeneratorReference",
    "requisitionSequenceGeneratorReference",
    "purchaseOrderSequenceGeneratorReference",
    "receiptSequenceGeneratorReference",
    "spendAuthorizationSequenceGeneratorReference",
    "expenseReportsSequenceGeneratorReference",
    "supplierContractsSequenceGeneratorReference",
    "settlementRunSequenceGeneratorReference",
    "prenoteRunSequenceGeneratorReference",
    "receiptAccrualSequenceGeneratorReference",
    "outsourcedPaymentGroupSequenceGeneratorReference",
    "procurementCardTransactionVerificationSequenceGeneratorReference"
})
public class CompanyWWSDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Transaction_Tax_ID")
    protected String transactionTaxID;
    @XmlElement(name = "Tax_ID_Data")
    protected List<TaxIDDataType> taxIDData;
    @XmlElement(name = "Industry_Code_Data")
    protected List<IndustryCodeDataType> industryCodeData;
    @XmlElement(name = "Workers_Compensation_Carrier_Reference")
    protected UniqueIdentifierObjectType workersCompensationCarrierReference;
    @XmlElement(name = "Organization_Data", required = true)
    protected OrganizationCommonDataType organizationData;
    @XmlElement(name = "Organization_Subtype_Reference", required = true)
    protected OrganizationSubtypeObjectType organizationSubtypeReference;
    @XmlElement(name = "Organization_Container_Reference")
    protected List<CustomOrganizationObjectType> organizationContainerReference;
    @XmlElement(name = "Contact_Data")
    protected ContactInformationDataType contactData;
    @XmlElement(name = "Accounting_Data")
    protected CompanyAccountingDetailsDataType accountingData;
    @XmlElement(name = "Customer_Payment_Auto_Application_Configuration_Data")
    protected CompanyCustomerPaymentAutoApplicationConfigurationDataType customerPaymentAutoApplicationConfigurationData;
    @XmlElement(name = "Customer_Contract_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType customerContractSequenceGeneratorReference;
    @XmlElement(name = "Award_Contract_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType awardContractSequenceGeneratorReference;
    @XmlElement(name = "Award_Proposal_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType awardProposalSequenceGeneratorReference;
    @XmlElement(name = "Customer_Invoice_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType customerInvoiceSequenceGeneratorReference;
    @XmlElement(name = "Supplier_Invoice_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType supplierInvoiceSequenceGeneratorReference;
    @XmlElement(name = "Customer_Refund_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType customerRefundSequenceGeneratorReference;
    @XmlElement(name = "Journal_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType journalSequenceGeneratorReference;
    @XmlElement(name = "Requisition_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType requisitionSequenceGeneratorReference;
    @XmlElement(name = "Purchase_Order_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType purchaseOrderSequenceGeneratorReference;
    @XmlElement(name = "Receipt_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType receiptSequenceGeneratorReference;
    @XmlElement(name = "Spend_Authorization_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType spendAuthorizationSequenceGeneratorReference;
    @XmlElement(name = "Expense_Reports_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType expenseReportsSequenceGeneratorReference;
    @XmlElement(name = "Supplier_Contracts_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType supplierContractsSequenceGeneratorReference;
    @XmlElement(name = "Settlement_Run_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType settlementRunSequenceGeneratorReference;
    @XmlElement(name = "Prenote_Run_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType prenoteRunSequenceGeneratorReference;
    @XmlElement(name = "Receipt_Accrual_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType receiptAccrualSequenceGeneratorReference;
    @XmlElement(name = "Outsourced_Payment_Group_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType outsourcedPaymentGroupSequenceGeneratorReference;
    @XmlElement(name = "Procurement_Card_Transaction_Verification_Sequence_Generator_Reference")
    protected SequenceGeneratorObjectType procurementCardTransactionVerificationSequenceGeneratorReference;
    @XmlAttribute(name = "Effective_Date", namespace = "urn:com.workday/bsvc")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar effectiveDate;

    /**
     * Gets the value of the transactionTaxID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTransactionTaxID() {
        return transactionTaxID;
    }

    /**
     * Sets the value of the transactionTaxID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTransactionTaxID(String value) {
        this.transactionTaxID = value;
    }

    /**
     * Gets the value of the taxIDData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the taxIDData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTaxIDData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TaxIDDataType }
     * 
     * 
     */
    public List<TaxIDDataType> getTaxIDData() {
        if (taxIDData == null) {
            taxIDData = new ArrayList<TaxIDDataType>();
        }
        return this.taxIDData;
    }

    /**
     * Gets the value of the industryCodeData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the industryCodeData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIndustryCodeData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IndustryCodeDataType }
     * 
     * 
     */
    public List<IndustryCodeDataType> getIndustryCodeData() {
        if (industryCodeData == null) {
            industryCodeData = new ArrayList<IndustryCodeDataType>();
        }
        return this.industryCodeData;
    }

    /**
     * Gets the value of the workersCompensationCarrierReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getWorkersCompensationCarrierReference() {
        return workersCompensationCarrierReference;
    }

    /**
     * Sets the value of the workersCompensationCarrierReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setWorkersCompensationCarrierReference(UniqueIdentifierObjectType value) {
        this.workersCompensationCarrierReference = value;
    }

    /**
     * Gets the value of the organizationData property.
     * 
     * @return
     *     possible object is
     *     {@link OrganizationCommonDataType }
     *     
     */
    public OrganizationCommonDataType getOrganizationData() {
        return organizationData;
    }

    /**
     * Sets the value of the organizationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrganizationCommonDataType }
     *     
     */
    public void setOrganizationData(OrganizationCommonDataType value) {
        this.organizationData = value;
    }

    /**
     * Gets the value of the organizationSubtypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public OrganizationSubtypeObjectType getOrganizationSubtypeReference() {
        return organizationSubtypeReference;
    }

    /**
     * Sets the value of the organizationSubtypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public void setOrganizationSubtypeReference(OrganizationSubtypeObjectType value) {
        this.organizationSubtypeReference = value;
    }

    /**
     * Gets the value of the organizationContainerReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the organizationContainerReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOrganizationContainerReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CustomOrganizationObjectType }
     * 
     * 
     */
    public List<CustomOrganizationObjectType> getOrganizationContainerReference() {
        if (organizationContainerReference == null) {
            organizationContainerReference = new ArrayList<CustomOrganizationObjectType>();
        }
        return this.organizationContainerReference;
    }

    /**
     * Gets the value of the contactData property.
     * 
     * @return
     *     possible object is
     *     {@link ContactInformationDataType }
     *     
     */
    public ContactInformationDataType getContactData() {
        return contactData;
    }

    /**
     * Sets the value of the contactData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactInformationDataType }
     *     
     */
    public void setContactData(ContactInformationDataType value) {
        this.contactData = value;
    }

    /**
     * Gets the value of the accountingData property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyAccountingDetailsDataType }
     *     
     */
    public CompanyAccountingDetailsDataType getAccountingData() {
        return accountingData;
    }

    /**
     * Sets the value of the accountingData property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyAccountingDetailsDataType }
     *     
     */
    public void setAccountingData(CompanyAccountingDetailsDataType value) {
        this.accountingData = value;
    }

    /**
     * Gets the value of the customerPaymentAutoApplicationConfigurationData property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyCustomerPaymentAutoApplicationConfigurationDataType }
     *     
     */
    public CompanyCustomerPaymentAutoApplicationConfigurationDataType getCustomerPaymentAutoApplicationConfigurationData() {
        return customerPaymentAutoApplicationConfigurationData;
    }

    /**
     * Sets the value of the customerPaymentAutoApplicationConfigurationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyCustomerPaymentAutoApplicationConfigurationDataType }
     *     
     */
    public void setCustomerPaymentAutoApplicationConfigurationData(CompanyCustomerPaymentAutoApplicationConfigurationDataType value) {
        this.customerPaymentAutoApplicationConfigurationData = value;
    }

    /**
     * Gets the value of the customerContractSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getCustomerContractSequenceGeneratorReference() {
        return customerContractSequenceGeneratorReference;
    }

    /**
     * Sets the value of the customerContractSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setCustomerContractSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.customerContractSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the awardContractSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getAwardContractSequenceGeneratorReference() {
        return awardContractSequenceGeneratorReference;
    }

    /**
     * Sets the value of the awardContractSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setAwardContractSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.awardContractSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the awardProposalSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getAwardProposalSequenceGeneratorReference() {
        return awardProposalSequenceGeneratorReference;
    }

    /**
     * Sets the value of the awardProposalSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setAwardProposalSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.awardProposalSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the customerInvoiceSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getCustomerInvoiceSequenceGeneratorReference() {
        return customerInvoiceSequenceGeneratorReference;
    }

    /**
     * Sets the value of the customerInvoiceSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setCustomerInvoiceSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.customerInvoiceSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the supplierInvoiceSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getSupplierInvoiceSequenceGeneratorReference() {
        return supplierInvoiceSequenceGeneratorReference;
    }

    /**
     * Sets the value of the supplierInvoiceSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setSupplierInvoiceSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.supplierInvoiceSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the customerRefundSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getCustomerRefundSequenceGeneratorReference() {
        return customerRefundSequenceGeneratorReference;
    }

    /**
     * Sets the value of the customerRefundSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setCustomerRefundSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.customerRefundSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the journalSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getJournalSequenceGeneratorReference() {
        return journalSequenceGeneratorReference;
    }

    /**
     * Sets the value of the journalSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setJournalSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.journalSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the requisitionSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getRequisitionSequenceGeneratorReference() {
        return requisitionSequenceGeneratorReference;
    }

    /**
     * Sets the value of the requisitionSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setRequisitionSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.requisitionSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the purchaseOrderSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getPurchaseOrderSequenceGeneratorReference() {
        return purchaseOrderSequenceGeneratorReference;
    }

    /**
     * Sets the value of the purchaseOrderSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setPurchaseOrderSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.purchaseOrderSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the receiptSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getReceiptSequenceGeneratorReference() {
        return receiptSequenceGeneratorReference;
    }

    /**
     * Sets the value of the receiptSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setReceiptSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.receiptSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the spendAuthorizationSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getSpendAuthorizationSequenceGeneratorReference() {
        return spendAuthorizationSequenceGeneratorReference;
    }

    /**
     * Sets the value of the spendAuthorizationSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setSpendAuthorizationSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.spendAuthorizationSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the expenseReportsSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getExpenseReportsSequenceGeneratorReference() {
        return expenseReportsSequenceGeneratorReference;
    }

    /**
     * Sets the value of the expenseReportsSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setExpenseReportsSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.expenseReportsSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the supplierContractsSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getSupplierContractsSequenceGeneratorReference() {
        return supplierContractsSequenceGeneratorReference;
    }

    /**
     * Sets the value of the supplierContractsSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setSupplierContractsSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.supplierContractsSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the settlementRunSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getSettlementRunSequenceGeneratorReference() {
        return settlementRunSequenceGeneratorReference;
    }

    /**
     * Sets the value of the settlementRunSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setSettlementRunSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.settlementRunSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the prenoteRunSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getPrenoteRunSequenceGeneratorReference() {
        return prenoteRunSequenceGeneratorReference;
    }

    /**
     * Sets the value of the prenoteRunSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setPrenoteRunSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.prenoteRunSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the receiptAccrualSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getReceiptAccrualSequenceGeneratorReference() {
        return receiptAccrualSequenceGeneratorReference;
    }

    /**
     * Sets the value of the receiptAccrualSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setReceiptAccrualSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.receiptAccrualSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the outsourcedPaymentGroupSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getOutsourcedPaymentGroupSequenceGeneratorReference() {
        return outsourcedPaymentGroupSequenceGeneratorReference;
    }

    /**
     * Sets the value of the outsourcedPaymentGroupSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setOutsourcedPaymentGroupSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.outsourcedPaymentGroupSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the procurementCardTransactionVerificationSequenceGeneratorReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public SequenceGeneratorObjectType getProcurementCardTransactionVerificationSequenceGeneratorReference() {
        return procurementCardTransactionVerificationSequenceGeneratorReference;
    }

    /**
     * Sets the value of the procurementCardTransactionVerificationSequenceGeneratorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceGeneratorObjectType }
     *     
     */
    public void setProcurementCardTransactionVerificationSequenceGeneratorReference(SequenceGeneratorObjectType value) {
        this.procurementCardTransactionVerificationSequenceGeneratorReference = value;
    }

    /**
     * Gets the value of the effectiveDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * Sets the value of the effectiveDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEffectiveDate(XMLGregorianCalendar value) {
        this.effectiveDate = value;
    }

    /**
     * Sets the value of the taxIDData property.
     * 
     * @param taxIDData
     *     allowed object is
     *     {@link TaxIDDataType }
     *     
     */
    public void setTaxIDData(List<TaxIDDataType> taxIDData) {
        this.taxIDData = taxIDData;
    }

    /**
     * Sets the value of the industryCodeData property.
     * 
     * @param industryCodeData
     *     allowed object is
     *     {@link IndustryCodeDataType }
     *     
     */
    public void setIndustryCodeData(List<IndustryCodeDataType> industryCodeData) {
        this.industryCodeData = industryCodeData;
    }

    /**
     * Sets the value of the organizationContainerReference property.
     * 
     * @param organizationContainerReference
     *     allowed object is
     *     {@link CustomOrganizationObjectType }
     *     
     */
    public void setOrganizationContainerReference(List<CustomOrganizationObjectType> organizationContainerReference) {
        this.organizationContainerReference = organizationContainerReference;
    }

}
