
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Company data
 * 
 * <p>Java class for Company_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Company_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Organization_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Transaction_Tax_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Tax_ID_Data" type="{urn:com.workday/bsvc}Tax_ID_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Integration_ID" type="{urn:com.workday/bsvc}External_Integration_ID_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Address_Data" type="{urn:com.workday/bsvc}Address_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Company_DataType", propOrder = {
    "organizationName",
    "transactionTaxID",
    "taxIDData",
    "integrationID",
    "addressData"
})
public class CompanyDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Organization_Name")
    protected String organizationName;
    @XmlElement(name = "Transaction_Tax_ID")
    protected String transactionTaxID;
    @XmlElement(name = "Tax_ID_Data")
    protected List<TaxIDDataType> taxIDData;
    @XmlElement(name = "Integration_ID")
    protected List<ExternalIntegrationIDDataType> integrationID;
    @XmlElement(name = "Address_Data")
    protected List<AddressDataType> addressData;

    /**
     * Gets the value of the organizationName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrganizationName() {
        return organizationName;
    }

    /**
     * Sets the value of the organizationName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrganizationName(String value) {
        this.organizationName = value;
    }

    /**
     * Gets the value of the transactionTaxID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTransactionTaxID() {
        return transactionTaxID;
    }

    /**
     * Sets the value of the transactionTaxID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTransactionTaxID(String value) {
        this.transactionTaxID = value;
    }

    /**
     * Gets the value of the taxIDData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the taxIDData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTaxIDData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TaxIDDataType }
     * 
     * 
     */
    public List<TaxIDDataType> getTaxIDData() {
        if (taxIDData == null) {
            taxIDData = new ArrayList<TaxIDDataType>();
        }
        return this.taxIDData;
    }

    /**
     * Gets the value of the integrationID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the integrationID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIntegrationID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExternalIntegrationIDDataType }
     * 
     * 
     */
    public List<ExternalIntegrationIDDataType> getIntegrationID() {
        if (integrationID == null) {
            integrationID = new ArrayList<ExternalIntegrationIDDataType>();
        }
        return this.integrationID;
    }

    /**
     * Gets the value of the addressData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressDataType }
     * 
     * 
     */
    public List<AddressDataType> getAddressData() {
        if (addressData == null) {
            addressData = new ArrayList<AddressDataType>();
        }
        return this.addressData;
    }

    /**
     * Sets the value of the taxIDData property.
     * 
     * @param taxIDData
     *     allowed object is
     *     {@link TaxIDDataType }
     *     
     */
    public void setTaxIDData(List<TaxIDDataType> taxIDData) {
        this.taxIDData = taxIDData;
    }

    /**
     * Sets the value of the integrationID property.
     * 
     * @param integrationID
     *     allowed object is
     *     {@link ExternalIntegrationIDDataType }
     *     
     */
    public void setIntegrationID(List<ExternalIntegrationIDDataType> integrationID) {
        this.integrationID = integrationID;
    }

    /**
     * Sets the value of the addressData property.
     * 
     * @param addressData
     *     allowed object is
     *     {@link AddressDataType }
     *     
     */
    public void setAddressData(List<AddressDataType> addressData) {
        this.addressData = addressData;
    }

}
