
package com.workday.financial;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Element containing Company Accounting Detail data
 * 
 * <p>Java class for Company_Accounting_Details_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Company_Accounting_Details_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Fiscal_Schedule_Reference" type="{urn:com.workday/bsvc}Fiscal_ScheduleObjectType" minOccurs="0"/>
 *         &lt;element name="Account_Set_Reference" type="{urn:com.workday/bsvc}Account_SetObjectType" minOccurs="0"/>
 *         &lt;element name="Alternate_Account_Set_Reference" type="{urn:com.workday/bsvc}Account_SetObjectType" minOccurs="0"/>
 *         &lt;element name="Default_Account_Set_Reference" type="{urn:com.workday/bsvc}Account_SetObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType"/>
 *         &lt;element name="Account_Control_Rule_Set_Reference" type="{urn:com.workday/bsvc}Account_Control_Rule_SetObjectType" minOccurs="0"/>
 *         &lt;element name="Account_Posting_Rule_Set_Reference" type="{urn:com.workday/bsvc}Account_Posting_Rule_SetObjectType" minOccurs="0"/>
 *         &lt;element name="Account_Translation_Rule_Set_Reference" type="{urn:com.workday/bsvc}Account_Translation_Rule_SetObjectType" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Reverse_Debit_Credit" type="{http://www.w3.org/2001/XMLSchema}boolean"/>
 *           &lt;element name="Keep_Debit_Credit_and_Reverse_Sign" type="{http://www.w3.org/2001/XMLSchema}boolean"/>
 *         &lt;/choice>
 *         &lt;element name="Default_Reporting_Book_Reference" type="{urn:com.workday/bsvc}BookObjectType" minOccurs="0"/>
 *         &lt;element name="Average_Daily_Balance_Rule_Reference" type="{urn:com.workday/bsvc}Average_Daily_Balance_RuleObjectType" minOccurs="0"/>
 *         &lt;element name="Average_Daily_Balance_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Use_Third_Party_Tax_Service" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Tax_Service_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Company_Accounting_Details_DataType", propOrder = {
    "fiscalScheduleReference",
    "accountSetReference",
    "alternateAccountSetReference",
    "defaultAccountSetReference",
    "currencyReference",
    "accountControlRuleSetReference",
    "accountPostingRuleSetReference",
    "accountTranslationRuleSetReference",
    "reverseDebitCredit",
    "keepDebitCreditAndReverseSign",
    "defaultReportingBookReference",
    "averageDailyBalanceRuleReference",
    "averageDailyBalanceStartDate",
    "useThirdPartyTaxService",
    "taxServiceName"
})
public class CompanyAccountingDetailsDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Fiscal_Schedule_Reference")
    protected FiscalScheduleObjectType fiscalScheduleReference;
    @XmlElement(name = "Account_Set_Reference")
    protected AccountSetObjectType accountSetReference;
    @XmlElement(name = "Alternate_Account_Set_Reference")
    protected AccountSetObjectType alternateAccountSetReference;
    @XmlElement(name = "Default_Account_Set_Reference")
    protected AccountSetObjectType defaultAccountSetReference;
    @XmlElement(name = "Currency_Reference", required = true)
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Account_Control_Rule_Set_Reference")
    protected AccountControlRuleSetObjectType accountControlRuleSetReference;
    @XmlElement(name = "Account_Posting_Rule_Set_Reference")
    protected AccountPostingRuleSetObjectType accountPostingRuleSetReference;
    @XmlElement(name = "Account_Translation_Rule_Set_Reference")
    protected AccountTranslationRuleSetObjectType accountTranslationRuleSetReference;
    @XmlElement(name = "Reverse_Debit_Credit")
    protected Boolean reverseDebitCredit;
    @XmlElement(name = "Keep_Debit_Credit_and_Reverse_Sign")
    protected Boolean keepDebitCreditAndReverseSign;
    @XmlElement(name = "Default_Reporting_Book_Reference")
    protected BookObjectType defaultReportingBookReference;
    @XmlElement(name = "Average_Daily_Balance_Rule_Reference")
    protected AverageDailyBalanceRuleObjectType averageDailyBalanceRuleReference;
    @XmlElement(name = "Average_Daily_Balance_Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar averageDailyBalanceStartDate;
    @XmlElement(name = "Use_Third_Party_Tax_Service")
    protected Boolean useThirdPartyTaxService;
    @XmlElement(name = "Tax_Service_Name")
    protected String taxServiceName;

    /**
     * Gets the value of the fiscalScheduleReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalScheduleObjectType }
     *     
     */
    public FiscalScheduleObjectType getFiscalScheduleReference() {
        return fiscalScheduleReference;
    }

    /**
     * Sets the value of the fiscalScheduleReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalScheduleObjectType }
     *     
     */
    public void setFiscalScheduleReference(FiscalScheduleObjectType value) {
        this.fiscalScheduleReference = value;
    }

    /**
     * Gets the value of the accountSetReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountSetObjectType }
     *     
     */
    public AccountSetObjectType getAccountSetReference() {
        return accountSetReference;
    }

    /**
     * Sets the value of the accountSetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountSetObjectType }
     *     
     */
    public void setAccountSetReference(AccountSetObjectType value) {
        this.accountSetReference = value;
    }

    /**
     * Gets the value of the alternateAccountSetReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountSetObjectType }
     *     
     */
    public AccountSetObjectType getAlternateAccountSetReference() {
        return alternateAccountSetReference;
    }

    /**
     * Sets the value of the alternateAccountSetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountSetObjectType }
     *     
     */
    public void setAlternateAccountSetReference(AccountSetObjectType value) {
        this.alternateAccountSetReference = value;
    }

    /**
     * Gets the value of the defaultAccountSetReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountSetObjectType }
     *     
     */
    public AccountSetObjectType getDefaultAccountSetReference() {
        return defaultAccountSetReference;
    }

    /**
     * Sets the value of the defaultAccountSetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountSetObjectType }
     *     
     */
    public void setDefaultAccountSetReference(AccountSetObjectType value) {
        this.defaultAccountSetReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the accountControlRuleSetReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountControlRuleSetObjectType }
     *     
     */
    public AccountControlRuleSetObjectType getAccountControlRuleSetReference() {
        return accountControlRuleSetReference;
    }

    /**
     * Sets the value of the accountControlRuleSetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountControlRuleSetObjectType }
     *     
     */
    public void setAccountControlRuleSetReference(AccountControlRuleSetObjectType value) {
        this.accountControlRuleSetReference = value;
    }

    /**
     * Gets the value of the accountPostingRuleSetReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountPostingRuleSetObjectType }
     *     
     */
    public AccountPostingRuleSetObjectType getAccountPostingRuleSetReference() {
        return accountPostingRuleSetReference;
    }

    /**
     * Sets the value of the accountPostingRuleSetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountPostingRuleSetObjectType }
     *     
     */
    public void setAccountPostingRuleSetReference(AccountPostingRuleSetObjectType value) {
        this.accountPostingRuleSetReference = value;
    }

    /**
     * Gets the value of the accountTranslationRuleSetReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountTranslationRuleSetObjectType }
     *     
     */
    public AccountTranslationRuleSetObjectType getAccountTranslationRuleSetReference() {
        return accountTranslationRuleSetReference;
    }

    /**
     * Sets the value of the accountTranslationRuleSetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountTranslationRuleSetObjectType }
     *     
     */
    public void setAccountTranslationRuleSetReference(AccountTranslationRuleSetObjectType value) {
        this.accountTranslationRuleSetReference = value;
    }

    /**
     * Gets the value of the reverseDebitCredit property.
     * This getter has been renamed from isReverseDebitCredit() to getReverseDebitCredit() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getReverseDebitCredit() {
        return reverseDebitCredit;
    }

    /**
     * Sets the value of the reverseDebitCredit property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setReverseDebitCredit(Boolean value) {
        this.reverseDebitCredit = value;
    }

    /**
     * Gets the value of the keepDebitCreditAndReverseSign property.
     * This getter has been renamed from isKeepDebitCreditAndReverseSign() to getKeepDebitCreditAndReverseSign() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getKeepDebitCreditAndReverseSign() {
        return keepDebitCreditAndReverseSign;
    }

    /**
     * Sets the value of the keepDebitCreditAndReverseSign property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setKeepDebitCreditAndReverseSign(Boolean value) {
        this.keepDebitCreditAndReverseSign = value;
    }

    /**
     * Gets the value of the defaultReportingBookReference property.
     * 
     * @return
     *     possible object is
     *     {@link BookObjectType }
     *     
     */
    public BookObjectType getDefaultReportingBookReference() {
        return defaultReportingBookReference;
    }

    /**
     * Sets the value of the defaultReportingBookReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BookObjectType }
     *     
     */
    public void setDefaultReportingBookReference(BookObjectType value) {
        this.defaultReportingBookReference = value;
    }

    /**
     * Gets the value of the averageDailyBalanceRuleReference property.
     * 
     * @return
     *     possible object is
     *     {@link AverageDailyBalanceRuleObjectType }
     *     
     */
    public AverageDailyBalanceRuleObjectType getAverageDailyBalanceRuleReference() {
        return averageDailyBalanceRuleReference;
    }

    /**
     * Sets the value of the averageDailyBalanceRuleReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AverageDailyBalanceRuleObjectType }
     *     
     */
    public void setAverageDailyBalanceRuleReference(AverageDailyBalanceRuleObjectType value) {
        this.averageDailyBalanceRuleReference = value;
    }

    /**
     * Gets the value of the averageDailyBalanceStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getAverageDailyBalanceStartDate() {
        return averageDailyBalanceStartDate;
    }

    /**
     * Sets the value of the averageDailyBalanceStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setAverageDailyBalanceStartDate(XMLGregorianCalendar value) {
        this.averageDailyBalanceStartDate = value;
    }

    /**
     * Gets the value of the useThirdPartyTaxService property.
     * This getter has been renamed from isUseThirdPartyTaxService() to getUseThirdPartyTaxService() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getUseThirdPartyTaxService() {
        return useThirdPartyTaxService;
    }

    /**
     * Sets the value of the useThirdPartyTaxService property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setUseThirdPartyTaxService(Boolean value) {
        this.useThirdPartyTaxService = value;
    }

    /**
     * Gets the value of the taxServiceName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxServiceName() {
        return taxServiceName;
    }

    /**
     * Sets the value of the taxServiceName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxServiceName(String value) {
        this.taxServiceName = value;
    }

}
