
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains data for a Business Plan Entry Line.  A Business Plan Entry may have multple Business Plan Entry Lines.
 * 
 * <p>Java class for Business_Plan_Entry_Line_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Business_Plan_Entry_Line_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Line_Order" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Ledger_Account_Reference" type="{urn:com.workday/bsvc}Ledger_AccountObjectType" minOccurs="0"/>
 *         &lt;element name="Ledger_Account_Summary_Reference" type="{urn:com.workday/bsvc}Ledger_Account_SummaryObjectType" minOccurs="0"/>
 *         &lt;element name="Debit_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="3"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Credit_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="3"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Line_Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Accounting_Worktag_Reference" type="{urn:com.workday/bsvc}Accounting_Worktag_and_Aggregation_DimensionObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Business_Plan_Entry_Line_DataType", propOrder = {
    "lineOrder",
    "ledgerAccountReference",
    "ledgerAccountSummaryReference",
    "debitAmount",
    "creditAmount",
    "lineMemo",
    "accountingWorktagReference"
})
public class BusinessPlanEntryLineDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Line_Order")
    protected String lineOrder;
    @XmlElement(name = "Ledger_Account_Reference")
    protected LedgerAccountObjectType ledgerAccountReference;
    @XmlElement(name = "Ledger_Account_Summary_Reference")
    protected LedgerAccountSummaryObjectType ledgerAccountSummaryReference;
    @XmlElement(name = "Debit_Amount")
    protected BigDecimal debitAmount;
    @XmlElement(name = "Credit_Amount")
    protected BigDecimal creditAmount;
    @XmlElement(name = "Line_Memo")
    protected String lineMemo;
    @XmlElement(name = "Accounting_Worktag_Reference")
    protected List<AccountingWorktagAndAggregationDimensionObjectType> accountingWorktagReference;

    /**
     * Gets the value of the lineOrder property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLineOrder() {
        return lineOrder;
    }

    /**
     * Sets the value of the lineOrder property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLineOrder(String value) {
        this.lineOrder = value;
    }

    /**
     * Gets the value of the ledgerAccountReference property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public LedgerAccountObjectType getLedgerAccountReference() {
        return ledgerAccountReference;
    }

    /**
     * Sets the value of the ledgerAccountReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public void setLedgerAccountReference(LedgerAccountObjectType value) {
        this.ledgerAccountReference = value;
    }

    /**
     * Gets the value of the ledgerAccountSummaryReference property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerAccountSummaryObjectType }
     *     
     */
    public LedgerAccountSummaryObjectType getLedgerAccountSummaryReference() {
        return ledgerAccountSummaryReference;
    }

    /**
     * Sets the value of the ledgerAccountSummaryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerAccountSummaryObjectType }
     *     
     */
    public void setLedgerAccountSummaryReference(LedgerAccountSummaryObjectType value) {
        this.ledgerAccountSummaryReference = value;
    }

    /**
     * Gets the value of the debitAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getDebitAmount() {
        return debitAmount;
    }

    /**
     * Sets the value of the debitAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setDebitAmount(BigDecimal value) {
        this.debitAmount = value;
    }

    /**
     * Gets the value of the creditAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getCreditAmount() {
        return creditAmount;
    }

    /**
     * Sets the value of the creditAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setCreditAmount(BigDecimal value) {
        this.creditAmount = value;
    }

    /**
     * Gets the value of the lineMemo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLineMemo() {
        return lineMemo;
    }

    /**
     * Sets the value of the lineMemo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLineMemo(String value) {
        this.lineMemo = value;
    }

    /**
     * Gets the value of the accountingWorktagReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the accountingWorktagReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAccountingWorktagReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagAndAggregationDimensionObjectType }
     * 
     * 
     */
    public List<AccountingWorktagAndAggregationDimensionObjectType> getAccountingWorktagReference() {
        if (accountingWorktagReference == null) {
            accountingWorktagReference = new ArrayList<AccountingWorktagAndAggregationDimensionObjectType>();
        }
        return this.accountingWorktagReference;
    }

    /**
     * Sets the value of the accountingWorktagReference property.
     * 
     * @param accountingWorktagReference
     *     allowed object is
     *     {@link AccountingWorktagAndAggregationDimensionObjectType }
     *     
     */
    public void setAccountingWorktagReference(List<AccountingWorktagAndAggregationDimensionObjectType> accountingWorktagReference) {
        this.accountingWorktagReference = accountingWorktagReference;
    }

}
