
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing Business Plan Entry data
 * 
 * <p>Java class for Business_Plan_Details_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Business_Plan_Details_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType"/>
 *         &lt;element name="Business_Plan_Structure_Reference" type="{urn:com.workday/bsvc}Budget_StructureObjectType"/>
 *         &lt;element name="Organizing_Dimension_Reference" type="{urn:com.workday/bsvc}Accounting_Worktag_and_Aggregation_DimensionObjectType" minOccurs="0"/>
 *         &lt;element name="Award_Contract_Reference" type="{urn:com.workday/bsvc}Budget_ActivityObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Year">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="4"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Fiscal_Time_Interval_Reference" type="{urn:com.workday/bsvc}Fiscal_Time_IntervalObjectType"/>
 *         &lt;element name="Plan_Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Business_Plan_Entry_Line_Replacement_Data" type="{urn:com.workday/bsvc}Business_Plan_Entry_Line_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Business_Plan_Details_DataType", propOrder = {
    "companyReference",
    "businessPlanStructureReference",
    "organizingDimensionReference",
    "awardContractReference",
    "currencyReference",
    "year",
    "fiscalTimeIntervalReference",
    "planMemo",
    "businessPlanEntryLineReplacementData"
})
public class BusinessPlanDetailsDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Company_Reference", required = true)
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Business_Plan_Structure_Reference", required = true)
    protected BudgetStructureObjectType businessPlanStructureReference;
    @XmlElement(name = "Organizing_Dimension_Reference")
    protected AccountingWorktagAndAggregationDimensionObjectType organizingDimensionReference;
    @XmlElement(name = "Award_Contract_Reference")
    protected BudgetActivityObjectType awardContractReference;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Year", required = true)
    protected BigDecimal year;
    @XmlElement(name = "Fiscal_Time_Interval_Reference", required = true)
    protected FiscalTimeIntervalObjectType fiscalTimeIntervalReference;
    @XmlElement(name = "Plan_Memo")
    protected String planMemo;
    @XmlElement(name = "Business_Plan_Entry_Line_Replacement_Data")
    protected List<BusinessPlanEntryLineDataType> businessPlanEntryLineReplacementData;

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the businessPlanStructureReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetStructureObjectType }
     *     
     */
    public BudgetStructureObjectType getBusinessPlanStructureReference() {
        return businessPlanStructureReference;
    }

    /**
     * Sets the value of the businessPlanStructureReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetStructureObjectType }
     *     
     */
    public void setBusinessPlanStructureReference(BudgetStructureObjectType value) {
        this.businessPlanStructureReference = value;
    }

    /**
     * Gets the value of the organizingDimensionReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountingWorktagAndAggregationDimensionObjectType }
     *     
     */
    public AccountingWorktagAndAggregationDimensionObjectType getOrganizingDimensionReference() {
        return organizingDimensionReference;
    }

    /**
     * Sets the value of the organizingDimensionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountingWorktagAndAggregationDimensionObjectType }
     *     
     */
    public void setOrganizingDimensionReference(AccountingWorktagAndAggregationDimensionObjectType value) {
        this.organizingDimensionReference = value;
    }

    /**
     * Gets the value of the awardContractReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetActivityObjectType }
     *     
     */
    public BudgetActivityObjectType getAwardContractReference() {
        return awardContractReference;
    }

    /**
     * Sets the value of the awardContractReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetActivityObjectType }
     *     
     */
    public void setAwardContractReference(BudgetActivityObjectType value) {
        this.awardContractReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the year property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getYear() {
        return year;
    }

    /**
     * Sets the value of the year property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setYear(BigDecimal value) {
        this.year = value;
    }

    /**
     * Gets the value of the fiscalTimeIntervalReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalTimeIntervalObjectType }
     *     
     */
    public FiscalTimeIntervalObjectType getFiscalTimeIntervalReference() {
        return fiscalTimeIntervalReference;
    }

    /**
     * Sets the value of the fiscalTimeIntervalReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalTimeIntervalObjectType }
     *     
     */
    public void setFiscalTimeIntervalReference(FiscalTimeIntervalObjectType value) {
        this.fiscalTimeIntervalReference = value;
    }

    /**
     * Gets the value of the planMemo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPlanMemo() {
        return planMemo;
    }

    /**
     * Sets the value of the planMemo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPlanMemo(String value) {
        this.planMemo = value;
    }

    /**
     * Gets the value of the businessPlanEntryLineReplacementData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the businessPlanEntryLineReplacementData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBusinessPlanEntryLineReplacementData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BusinessPlanEntryLineDataType }
     * 
     * 
     */
    public List<BusinessPlanEntryLineDataType> getBusinessPlanEntryLineReplacementData() {
        if (businessPlanEntryLineReplacementData == null) {
            businessPlanEntryLineReplacementData = new ArrayList<BusinessPlanEntryLineDataType>();
        }
        return this.businessPlanEntryLineReplacementData;
    }

    /**
     * Sets the value of the businessPlanEntryLineReplacementData property.
     * 
     * @param businessPlanEntryLineReplacementData
     *     allowed object is
     *     {@link BusinessPlanEntryLineDataType }
     *     
     */
    public void setBusinessPlanEntryLineReplacementData(List<BusinessPlanEntryLineDataType> businessPlanEntryLineReplacementData) {
        this.businessPlanEntryLineReplacementData = businessPlanEntryLineReplacementData;
    }

}
