
package com.workday.financial;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing Business Entity Contact reference for update and all Business Entity Contact data items
 * 
 * <p>Java class for Business_Entity_Contact_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Business_Entity_Contact_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Business_Entity_Contact_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Supplier_Reference" type="{urn:com.workday/bsvc}SupplierObjectType"/>
 *           &lt;element name="Customer_Reference" type="{urn:com.workday/bsvc}Billable_EntityObjectType"/>
 *           &lt;element name="Financial_Institution_Reference" type="{urn:com.workday/bsvc}Financial_InstitutionObjectType"/>
 *           &lt;element name="Tax_Authority_Reference" type="{urn:com.workday/bsvc}Tax_AuthorityObjectType"/>
 *         &lt;/choice>
 *         &lt;element name="Business_Entity_Contact_Personal_Data" type="{urn:com.workday/bsvc}Business_Entity_Contact_Personal_DataType"/>
 *         &lt;element name="External_ID_Data" type="{urn:com.workday/bsvc}External_Integration_ID_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Business_Entity_Contact_DataType", propOrder = {
    "businessEntityContactID",
    "supplierReference",
    "customerReference",
    "financialInstitutionReference",
    "taxAuthorityReference",
    "businessEntityContactPersonalData",
    "externalIDData"
})
public class BusinessEntityContactDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Business_Entity_Contact_ID")
    protected String businessEntityContactID;
    @XmlElement(name = "Supplier_Reference")
    protected SupplierObjectType supplierReference;
    @XmlElement(name = "Customer_Reference")
    protected BillableEntityObjectType customerReference;
    @XmlElement(name = "Financial_Institution_Reference")
    protected FinancialInstitutionObjectType financialInstitutionReference;
    @XmlElement(name = "Tax_Authority_Reference")
    protected TaxAuthorityObjectType taxAuthorityReference;
    @XmlElement(name = "Business_Entity_Contact_Personal_Data", required = true)
    protected BusinessEntityContactPersonalDataType businessEntityContactPersonalData;
    @XmlElement(name = "External_ID_Data")
    protected ExternalIntegrationIDDataType externalIDData;

    /**
     * Gets the value of the businessEntityContactID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessEntityContactID() {
        return businessEntityContactID;
    }

    /**
     * Sets the value of the businessEntityContactID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessEntityContactID(String value) {
        this.businessEntityContactID = value;
    }

    /**
     * Gets the value of the supplierReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupplierObjectType }
     *     
     */
    public SupplierObjectType getSupplierReference() {
        return supplierReference;
    }

    /**
     * Sets the value of the supplierReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplierObjectType }
     *     
     */
    public void setSupplierReference(SupplierObjectType value) {
        this.supplierReference = value;
    }

    /**
     * Gets the value of the customerReference property.
     * 
     * @return
     *     possible object is
     *     {@link BillableEntityObjectType }
     *     
     */
    public BillableEntityObjectType getCustomerReference() {
        return customerReference;
    }

    /**
     * Sets the value of the customerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BillableEntityObjectType }
     *     
     */
    public void setCustomerReference(BillableEntityObjectType value) {
        this.customerReference = value;
    }

    /**
     * Gets the value of the financialInstitutionReference property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialInstitutionObjectType }
     *     
     */
    public FinancialInstitutionObjectType getFinancialInstitutionReference() {
        return financialInstitutionReference;
    }

    /**
     * Sets the value of the financialInstitutionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialInstitutionObjectType }
     *     
     */
    public void setFinancialInstitutionReference(FinancialInstitutionObjectType value) {
        this.financialInstitutionReference = value;
    }

    /**
     * Gets the value of the taxAuthorityReference property.
     * 
     * @return
     *     possible object is
     *     {@link TaxAuthorityObjectType }
     *     
     */
    public TaxAuthorityObjectType getTaxAuthorityReference() {
        return taxAuthorityReference;
    }

    /**
     * Sets the value of the taxAuthorityReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxAuthorityObjectType }
     *     
     */
    public void setTaxAuthorityReference(TaxAuthorityObjectType value) {
        this.taxAuthorityReference = value;
    }

    /**
     * Gets the value of the businessEntityContactPersonalData property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessEntityContactPersonalDataType }
     *     
     */
    public BusinessEntityContactPersonalDataType getBusinessEntityContactPersonalData() {
        return businessEntityContactPersonalData;
    }

    /**
     * Sets the value of the businessEntityContactPersonalData property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessEntityContactPersonalDataType }
     *     
     */
    public void setBusinessEntityContactPersonalData(BusinessEntityContactPersonalDataType value) {
        this.businessEntityContactPersonalData = value;
    }

    /**
     * Gets the value of the externalIDData property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalIntegrationIDDataType }
     *     
     */
    public ExternalIntegrationIDDataType getExternalIDData() {
        return externalIDData;
    }

    /**
     * Sets the value of the externalIDData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalIntegrationIDDataType }
     *     
     */
    public void setExternalIDData(ExternalIntegrationIDDataType value) {
        this.externalIDData = value;
    }

}
