
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing Budget Entry data
 * 
 * <p>Java class for Budget_Details__HV__DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Budget_Details__HV__DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType"/>
 *         &lt;element name="Budget_Structure_Reference" type="{urn:com.workday/bsvc}Budget_StructureObjectType"/>
 *         &lt;element name="Organizing_Dimension_Reference" type="{urn:com.workday/bsvc}Accounting_Worktag_and_Aggregation_DimensionObjectType" minOccurs="0"/>
 *         &lt;element name="Budget_Name_Reference" type="{urn:com.workday/bsvc}Budget_ActivityObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Year">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="4"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Fiscal_Time_Interval_Reference" type="{urn:com.workday/bsvc}Fiscal_Time_IntervalObjectType"/>
 *         &lt;element name="Plan_Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Budget_Entry_Line_Replacement_Data" type="{urn:com.workday/bsvc}Budget_Entry_Line__HV__DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Budget_Details__HV__DataType", propOrder = {
    "companyReference",
    "budgetStructureReference",
    "organizingDimensionReference",
    "budgetNameReference",
    "currencyReference",
    "year",
    "fiscalTimeIntervalReference",
    "planMemo",
    "budgetEntryLineReplacementData"
})
public class BudgetDetailsHVDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Company_Reference", required = true)
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Budget_Structure_Reference", required = true)
    protected BudgetStructureObjectType budgetStructureReference;
    @XmlElement(name = "Organizing_Dimension_Reference")
    protected AccountingWorktagAndAggregationDimensionObjectType organizingDimensionReference;
    @XmlElement(name = "Budget_Name_Reference")
    protected BudgetActivityObjectType budgetNameReference;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Year", required = true)
    protected BigDecimal year;
    @XmlElement(name = "Fiscal_Time_Interval_Reference", required = true)
    protected FiscalTimeIntervalObjectType fiscalTimeIntervalReference;
    @XmlElement(name = "Plan_Memo")
    protected String planMemo;
    @XmlElement(name = "Budget_Entry_Line_Replacement_Data")
    protected List<BudgetEntryLineHVDataType> budgetEntryLineReplacementData;

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the budgetStructureReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetStructureObjectType }
     *     
     */
    public BudgetStructureObjectType getBudgetStructureReference() {
        return budgetStructureReference;
    }

    /**
     * Sets the value of the budgetStructureReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetStructureObjectType }
     *     
     */
    public void setBudgetStructureReference(BudgetStructureObjectType value) {
        this.budgetStructureReference = value;
    }

    /**
     * Gets the value of the organizingDimensionReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountingWorktagAndAggregationDimensionObjectType }
     *     
     */
    public AccountingWorktagAndAggregationDimensionObjectType getOrganizingDimensionReference() {
        return organizingDimensionReference;
    }

    /**
     * Sets the value of the organizingDimensionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountingWorktagAndAggregationDimensionObjectType }
     *     
     */
    public void setOrganizingDimensionReference(AccountingWorktagAndAggregationDimensionObjectType value) {
        this.organizingDimensionReference = value;
    }

    /**
     * Gets the value of the budgetNameReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetActivityObjectType }
     *     
     */
    public BudgetActivityObjectType getBudgetNameReference() {
        return budgetNameReference;
    }

    /**
     * Sets the value of the budgetNameReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetActivityObjectType }
     *     
     */
    public void setBudgetNameReference(BudgetActivityObjectType value) {
        this.budgetNameReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the year property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getYear() {
        return year;
    }

    /**
     * Sets the value of the year property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setYear(BigDecimal value) {
        this.year = value;
    }

    /**
     * Gets the value of the fiscalTimeIntervalReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalTimeIntervalObjectType }
     *     
     */
    public FiscalTimeIntervalObjectType getFiscalTimeIntervalReference() {
        return fiscalTimeIntervalReference;
    }

    /**
     * Sets the value of the fiscalTimeIntervalReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalTimeIntervalObjectType }
     *     
     */
    public void setFiscalTimeIntervalReference(FiscalTimeIntervalObjectType value) {
        this.fiscalTimeIntervalReference = value;
    }

    /**
     * Gets the value of the planMemo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPlanMemo() {
        return planMemo;
    }

    /**
     * Sets the value of the planMemo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPlanMemo(String value) {
        this.planMemo = value;
    }

    /**
     * Gets the value of the budgetEntryLineReplacementData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the budgetEntryLineReplacementData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBudgetEntryLineReplacementData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BudgetEntryLineHVDataType }
     * 
     * 
     */
    public List<BudgetEntryLineHVDataType> getBudgetEntryLineReplacementData() {
        if (budgetEntryLineReplacementData == null) {
            budgetEntryLineReplacementData = new ArrayList<BudgetEntryLineHVDataType>();
        }
        return this.budgetEntryLineReplacementData;
    }

    /**
     * Sets the value of the budgetEntryLineReplacementData property.
     * 
     * @param budgetEntryLineReplacementData
     *     allowed object is
     *     {@link BudgetEntryLineHVDataType }
     *     
     */
    public void setBudgetEntryLineReplacementData(List<BudgetEntryLineHVDataType> budgetEntryLineReplacementData) {
        this.budgetEntryLineReplacementData = budgetEntryLineReplacementData;
    }

}
