
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Budget Amendment High Volume Data
 * 
 * <p>Java class for Budget_Amendment_High_Volume_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Budget_Amendment_High_Volume_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Submit" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType"/>
 *         &lt;element name="Budget_Structure_Reference" type="{urn:com.workday/bsvc}Budget_StructureObjectType"/>
 *         &lt;element name="Budget_Name_Reference" type="{urn:com.workday/bsvc}Budget_ActivityObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Fiscal_Year">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="4"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Amendment_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="Description" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Budget_Amendment_Type_Reference" type="{urn:com.workday/bsvc}Budget_Amendment_TypeObjectType"/>
 *         &lt;element name="Amendment_Entry_Data" type="{urn:com.workday/bsvc}Budget_Amendment_Entry_High_Volume_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Attachment_Data" type="{urn:com.workday/bsvc}Financials_Attachment_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Budget_Amendment_High_Volume_DataType", propOrder = {
    "id",
    "submit",
    "companyReference",
    "budgetStructureReference",
    "budgetNameReference",
    "currencyReference",
    "fiscalYear",
    "amendmentDate",
    "description",
    "budgetAmendmentTypeReference",
    "amendmentEntryData",
    "attachmentData"
})
public class BudgetAmendmentHighVolumeDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "ID")
    protected String id;
    @XmlElement(name = "Submit")
    protected Boolean submit;
    @XmlElement(name = "Company_Reference", required = true)
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Budget_Structure_Reference", required = true)
    protected BudgetStructureObjectType budgetStructureReference;
    @XmlElement(name = "Budget_Name_Reference")
    protected BudgetActivityObjectType budgetNameReference;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Fiscal_Year", required = true)
    protected BigDecimal fiscalYear;
    @XmlElement(name = "Amendment_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar amendmentDate;
    @XmlElement(name = "Description", required = true)
    protected String description;
    @XmlElement(name = "Budget_Amendment_Type_Reference", required = true)
    protected BudgetAmendmentTypeObjectType budgetAmendmentTypeReference;
    @XmlElement(name = "Amendment_Entry_Data")
    protected List<BudgetAmendmentEntryHighVolumeDataType> amendmentEntryData;
    @XmlElement(name = "Attachment_Data")
    protected List<FinancialsAttachmentDataType> attachmentData;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setID(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the submit property.
     * This getter has been renamed from isSubmit() to getSubmit() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getSubmit() {
        return submit;
    }

    /**
     * Sets the value of the submit property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setSubmit(Boolean value) {
        this.submit = value;
    }

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the budgetStructureReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetStructureObjectType }
     *     
     */
    public BudgetStructureObjectType getBudgetStructureReference() {
        return budgetStructureReference;
    }

    /**
     * Sets the value of the budgetStructureReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetStructureObjectType }
     *     
     */
    public void setBudgetStructureReference(BudgetStructureObjectType value) {
        this.budgetStructureReference = value;
    }

    /**
     * Gets the value of the budgetNameReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetActivityObjectType }
     *     
     */
    public BudgetActivityObjectType getBudgetNameReference() {
        return budgetNameReference;
    }

    /**
     * Sets the value of the budgetNameReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetActivityObjectType }
     *     
     */
    public void setBudgetNameReference(BudgetActivityObjectType value) {
        this.budgetNameReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the fiscalYear property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFiscalYear() {
        return fiscalYear;
    }

    /**
     * Sets the value of the fiscalYear property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFiscalYear(BigDecimal value) {
        this.fiscalYear = value;
    }

    /**
     * Gets the value of the amendmentDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getAmendmentDate() {
        return amendmentDate;
    }

    /**
     * Sets the value of the amendmentDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setAmendmentDate(XMLGregorianCalendar value) {
        this.amendmentDate = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the budgetAmendmentTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetAmendmentTypeObjectType }
     *     
     */
    public BudgetAmendmentTypeObjectType getBudgetAmendmentTypeReference() {
        return budgetAmendmentTypeReference;
    }

    /**
     * Sets the value of the budgetAmendmentTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetAmendmentTypeObjectType }
     *     
     */
    public void setBudgetAmendmentTypeReference(BudgetAmendmentTypeObjectType value) {
        this.budgetAmendmentTypeReference = value;
    }

    /**
     * Gets the value of the amendmentEntryData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the amendmentEntryData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAmendmentEntryData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BudgetAmendmentEntryHighVolumeDataType }
     * 
     * 
     */
    public List<BudgetAmendmentEntryHighVolumeDataType> getAmendmentEntryData() {
        if (amendmentEntryData == null) {
            amendmentEntryData = new ArrayList<BudgetAmendmentEntryHighVolumeDataType>();
        }
        return this.amendmentEntryData;
    }

    /**
     * Gets the value of the attachmentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the attachmentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttachmentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialsAttachmentDataType }
     * 
     * 
     */
    public List<FinancialsAttachmentDataType> getAttachmentData() {
        if (attachmentData == null) {
            attachmentData = new ArrayList<FinancialsAttachmentDataType>();
        }
        return this.attachmentData;
    }

    /**
     * Sets the value of the amendmentEntryData property.
     * 
     * @param amendmentEntryData
     *     allowed object is
     *     {@link BudgetAmendmentEntryHighVolumeDataType }
     *     
     */
    public void setAmendmentEntryData(List<BudgetAmendmentEntryHighVolumeDataType> amendmentEntryData) {
        this.amendmentEntryData = amendmentEntryData;
    }

    /**
     * Sets the value of the attachmentData property.
     * 
     * @param attachmentData
     *     allowed object is
     *     {@link FinancialsAttachmentDataType }
     *     
     */
    public void setAttachmentData(List<FinancialsAttachmentDataType> attachmentData) {
        this.attachmentData = attachmentData;
    }

}
