
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Budget Amendment
 * 
 * <p>Java class for Budget_Amendment_Entry_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Budget_Amendment_Entry_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Fiscal_Time_Interval_Reference" type="{urn:com.workday/bsvc}Fiscal_Time_IntervalObjectType"/>
 *         &lt;element name="Accounting_Worktag_Reference" type="{urn:com.workday/bsvc}Accounting_Worktag_and_Aggregation_DimensionObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Ledger_Account_Reference" type="{urn:com.workday/bsvc}Ledger_AccountObjectType"/>
 *           &lt;element name="Ledger_Account_Summary_Reference" type="{urn:com.workday/bsvc}Ledger_Account_SummaryObjectType"/>
 *         &lt;/choice>
 *         &lt;element name="Ledger_Debit_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="3"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Ledger_Credit_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="3"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Budget_Amendment_Entry_DataType", propOrder = {
    "fiscalTimeIntervalReference",
    "accountingWorktagReference",
    "ledgerAccountReference",
    "ledgerAccountSummaryReference",
    "ledgerDebitAmount",
    "ledgerCreditAmount",
    "memo"
})
public class BudgetAmendmentEntryDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Fiscal_Time_Interval_Reference", required = true)
    protected FiscalTimeIntervalObjectType fiscalTimeIntervalReference;
    @XmlElement(name = "Accounting_Worktag_Reference")
    protected List<AccountingWorktagAndAggregationDimensionObjectType> accountingWorktagReference;
    @XmlElement(name = "Ledger_Account_Reference")
    protected LedgerAccountObjectType ledgerAccountReference;
    @XmlElement(name = "Ledger_Account_Summary_Reference")
    protected LedgerAccountSummaryObjectType ledgerAccountSummaryReference;
    @XmlElement(name = "Ledger_Debit_Amount")
    protected BigDecimal ledgerDebitAmount;
    @XmlElement(name = "Ledger_Credit_Amount")
    protected BigDecimal ledgerCreditAmount;
    @XmlElement(name = "Memo")
    protected String memo;

    /**
     * Gets the value of the fiscalTimeIntervalReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalTimeIntervalObjectType }
     *     
     */
    public FiscalTimeIntervalObjectType getFiscalTimeIntervalReference() {
        return fiscalTimeIntervalReference;
    }

    /**
     * Sets the value of the fiscalTimeIntervalReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalTimeIntervalObjectType }
     *     
     */
    public void setFiscalTimeIntervalReference(FiscalTimeIntervalObjectType value) {
        this.fiscalTimeIntervalReference = value;
    }

    /**
     * Gets the value of the accountingWorktagReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the accountingWorktagReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAccountingWorktagReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagAndAggregationDimensionObjectType }
     * 
     * 
     */
    public List<AccountingWorktagAndAggregationDimensionObjectType> getAccountingWorktagReference() {
        if (accountingWorktagReference == null) {
            accountingWorktagReference = new ArrayList<AccountingWorktagAndAggregationDimensionObjectType>();
        }
        return this.accountingWorktagReference;
    }

    /**
     * Gets the value of the ledgerAccountReference property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public LedgerAccountObjectType getLedgerAccountReference() {
        return ledgerAccountReference;
    }

    /**
     * Sets the value of the ledgerAccountReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public void setLedgerAccountReference(LedgerAccountObjectType value) {
        this.ledgerAccountReference = value;
    }

    /**
     * Gets the value of the ledgerAccountSummaryReference property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerAccountSummaryObjectType }
     *     
     */
    public LedgerAccountSummaryObjectType getLedgerAccountSummaryReference() {
        return ledgerAccountSummaryReference;
    }

    /**
     * Sets the value of the ledgerAccountSummaryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerAccountSummaryObjectType }
     *     
     */
    public void setLedgerAccountSummaryReference(LedgerAccountSummaryObjectType value) {
        this.ledgerAccountSummaryReference = value;
    }

    /**
     * Gets the value of the ledgerDebitAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getLedgerDebitAmount() {
        return ledgerDebitAmount;
    }

    /**
     * Sets the value of the ledgerDebitAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setLedgerDebitAmount(BigDecimal value) {
        this.ledgerDebitAmount = value;
    }

    /**
     * Gets the value of the ledgerCreditAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getLedgerCreditAmount() {
        return ledgerCreditAmount;
    }

    /**
     * Sets the value of the ledgerCreditAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setLedgerCreditAmount(BigDecimal value) {
        this.ledgerCreditAmount = value;
    }

    /**
     * Gets the value of the memo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMemo() {
        return memo;
    }

    /**
     * Sets the value of the memo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMemo(String value) {
        this.memo = value;
    }

    /**
     * Sets the value of the accountingWorktagReference property.
     * 
     * @param accountingWorktagReference
     *     allowed object is
     *     {@link AccountingWorktagAndAggregationDimensionObjectType }
     *     
     */
    public void setAccountingWorktagReference(List<AccountingWorktagAndAggregationDimensionObjectType> accountingWorktagReference) {
        this.accountingWorktagReference = accountingWorktagReference;
    }

}
