
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * This Element stores criteria to resolve to a beginning balance journal based on Company, Fiscal Year, Ledger Type, and Book Code. Beginning Balance Translation Amounts are entered for a given Currency via the Beginning Balnace Translation Amount Replacement Data subelement.
 * 
 * <p>Java class for Beginning_Balance_Translation_Amounts_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Beginning_Balance_Translation_Amounts_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType"/>
 *         &lt;element name="Fiscal_Year_Reference" type="{urn:com.workday/bsvc}Fiscal_YearObjectType"/>
 *         &lt;element name="Ledger_Type_Reference" type="{urn:com.workday/bsvc}Ledger_TypeObjectType"/>
 *         &lt;element name="Translation_Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType"/>
 *         &lt;element name="Book_Code_Reference" type="{urn:com.workday/bsvc}Book_CodeObjectType" minOccurs="0"/>
 *         &lt;element name="Beginning_Balance_Translation_Amount_Line_Replacement_Data" type="{urn:com.workday/bsvc}Beginning_Balance_Translation_Amount_Line_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Beginning_Balance_Translation_Amounts_DataType", propOrder = {
    "companyReference",
    "fiscalYearReference",
    "ledgerTypeReference",
    "translationCurrencyReference",
    "bookCodeReference",
    "beginningBalanceTranslationAmountLineReplacementData"
})
public class BeginningBalanceTranslationAmountsDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Company_Reference", required = true)
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Fiscal_Year_Reference", required = true)
    protected FiscalYearObjectType fiscalYearReference;
    @XmlElement(name = "Ledger_Type_Reference", required = true)
    protected LedgerTypeObjectType ledgerTypeReference;
    @XmlElement(name = "Translation_Currency_Reference", required = true)
    protected CurrencyObjectType translationCurrencyReference;
    @XmlElement(name = "Book_Code_Reference")
    protected BookCodeObjectType bookCodeReference;
    @XmlElement(name = "Beginning_Balance_Translation_Amount_Line_Replacement_Data")
    protected List<BeginningBalanceTranslationAmountLineDataType> beginningBalanceTranslationAmountLineReplacementData;

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the fiscalYearReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalYearObjectType }
     *     
     */
    public FiscalYearObjectType getFiscalYearReference() {
        return fiscalYearReference;
    }

    /**
     * Sets the value of the fiscalYearReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalYearObjectType }
     *     
     */
    public void setFiscalYearReference(FiscalYearObjectType value) {
        this.fiscalYearReference = value;
    }

    /**
     * Gets the value of the ledgerTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerTypeObjectType }
     *     
     */
    public LedgerTypeObjectType getLedgerTypeReference() {
        return ledgerTypeReference;
    }

    /**
     * Sets the value of the ledgerTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerTypeObjectType }
     *     
     */
    public void setLedgerTypeReference(LedgerTypeObjectType value) {
        this.ledgerTypeReference = value;
    }

    /**
     * Gets the value of the translationCurrencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getTranslationCurrencyReference() {
        return translationCurrencyReference;
    }

    /**
     * Sets the value of the translationCurrencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setTranslationCurrencyReference(CurrencyObjectType value) {
        this.translationCurrencyReference = value;
    }

    /**
     * Gets the value of the bookCodeReference property.
     * 
     * @return
     *     possible object is
     *     {@link BookCodeObjectType }
     *     
     */
    public BookCodeObjectType getBookCodeReference() {
        return bookCodeReference;
    }

    /**
     * Sets the value of the bookCodeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BookCodeObjectType }
     *     
     */
    public void setBookCodeReference(BookCodeObjectType value) {
        this.bookCodeReference = value;
    }

    /**
     * Gets the value of the beginningBalanceTranslationAmountLineReplacementData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the beginningBalanceTranslationAmountLineReplacementData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBeginningBalanceTranslationAmountLineReplacementData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BeginningBalanceTranslationAmountLineDataType }
     * 
     * 
     */
    public List<BeginningBalanceTranslationAmountLineDataType> getBeginningBalanceTranslationAmountLineReplacementData() {
        if (beginningBalanceTranslationAmountLineReplacementData == null) {
            beginningBalanceTranslationAmountLineReplacementData = new ArrayList<BeginningBalanceTranslationAmountLineDataType>();
        }
        return this.beginningBalanceTranslationAmountLineReplacementData;
    }

    /**
     * Sets the value of the beginningBalanceTranslationAmountLineReplacementData property.
     * 
     * @param beginningBalanceTranslationAmountLineReplacementData
     *     allowed object is
     *     {@link BeginningBalanceTranslationAmountLineDataType }
     *     
     */
    public void setBeginningBalanceTranslationAmountLineReplacementData(List<BeginningBalanceTranslationAmountLineDataType> beginningBalanceTranslationAmountLineReplacementData) {
        this.beginningBalanceTranslationAmountLineReplacementData = beginningBalanceTranslationAmountLineReplacementData;
    }

}
