
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Beginning Balance Translation Amount Line Replacement Data represents a translated beginning balance amount to be created for the beginning balance journal resolved from the criteria in the parent element.
 * 
 * <p>Java class for Beginning_Balance_Translation_Amount_Line_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Beginning_Balance_Translation_Amount_Line_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Ledger_Account_Reference" type="{urn:com.workday/bsvc}Ledger_AccountObjectType" minOccurs="0"/>
 *         &lt;element name="Accounting_Worktags_Reference" type="{urn:com.workday/bsvc}Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Affiliate_Balancing_Worktag_Reference" type="{urn:com.workday/bsvc}Balancing_WorktagObjectType" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Translated_Debit_Amount">
 *             &lt;simpleType>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *                 &lt;totalDigits value="18"/>
 *                 &lt;fractionDigits value="3"/>
 *               &lt;/restriction>
 *             &lt;/simpleType>
 *           &lt;/element>
 *           &lt;element name="Translated_Credit_Amount">
 *             &lt;simpleType>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *                 &lt;totalDigits value="26"/>
 *                 &lt;fractionDigits value="6"/>
 *               &lt;/restriction>
 *             &lt;/simpleType>
 *           &lt;/element>
 *         &lt;/choice>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Beginning_Balance_Translation_Amount_Line_DataType", propOrder = {
    "currencyReference",
    "ledgerAccountReference",
    "accountingWorktagsReference",
    "affiliateBalancingWorktagReference",
    "translatedDebitAmount",
    "translatedCreditAmount"
})
public class BeginningBalanceTranslationAmountLineDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Ledger_Account_Reference")
    protected LedgerAccountObjectType ledgerAccountReference;
    @XmlElement(name = "Accounting_Worktags_Reference")
    protected List<AccountingWorktagObjectType> accountingWorktagsReference;
    @XmlElement(name = "Affiliate_Balancing_Worktag_Reference")
    protected BalancingWorktagObjectType affiliateBalancingWorktagReference;
    @XmlElement(name = "Translated_Debit_Amount")
    protected BigDecimal translatedDebitAmount;
    @XmlElement(name = "Translated_Credit_Amount")
    protected BigDecimal translatedCreditAmount;

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the ledgerAccountReference property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public LedgerAccountObjectType getLedgerAccountReference() {
        return ledgerAccountReference;
    }

    /**
     * Sets the value of the ledgerAccountReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public void setLedgerAccountReference(LedgerAccountObjectType value) {
        this.ledgerAccountReference = value;
    }

    /**
     * Gets the value of the accountingWorktagsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the accountingWorktagsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAccountingWorktagsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagObjectType }
     * 
     * 
     */
    public List<AccountingWorktagObjectType> getAccountingWorktagsReference() {
        if (accountingWorktagsReference == null) {
            accountingWorktagsReference = new ArrayList<AccountingWorktagObjectType>();
        }
        return this.accountingWorktagsReference;
    }

    /**
     * Gets the value of the affiliateBalancingWorktagReference property.
     * 
     * @return
     *     possible object is
     *     {@link BalancingWorktagObjectType }
     *     
     */
    public BalancingWorktagObjectType getAffiliateBalancingWorktagReference() {
        return affiliateBalancingWorktagReference;
    }

    /**
     * Sets the value of the affiliateBalancingWorktagReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BalancingWorktagObjectType }
     *     
     */
    public void setAffiliateBalancingWorktagReference(BalancingWorktagObjectType value) {
        this.affiliateBalancingWorktagReference = value;
    }

    /**
     * Gets the value of the translatedDebitAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getTranslatedDebitAmount() {
        return translatedDebitAmount;
    }

    /**
     * Sets the value of the translatedDebitAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setTranslatedDebitAmount(BigDecimal value) {
        this.translatedDebitAmount = value;
    }

    /**
     * Gets the value of the translatedCreditAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getTranslatedCreditAmount() {
        return translatedCreditAmount;
    }

    /**
     * Sets the value of the translatedCreditAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setTranslatedCreditAmount(BigDecimal value) {
        this.translatedCreditAmount = value;
    }

    /**
     * Sets the value of the accountingWorktagsReference property.
     * 
     * @param accountingWorktagsReference
     *     allowed object is
     *     {@link AccountingWorktagObjectType }
     *     
     */
    public void setAccountingWorktagsReference(List<AccountingWorktagObjectType> accountingWorktagsReference) {
        this.accountingWorktagsReference = accountingWorktagsReference;
    }

}
