
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Beginning Balance Journal data
 * 
 * <p>Java class for Beginning_Balance_Journal_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Beginning_Balance_Journal_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Accounting_Journal_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType"/>
 *         &lt;element name="Currency_Rate_Type_Reference" type="{urn:com.workday/bsvc}Currency_Rate_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Ledger_Year_Reference_Data" type="{urn:com.workday/bsvc}Ledger_Year_ReferenceType"/>
 *         &lt;element name="Journal_Entry_Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Journal_Source_Reference" type="{urn:com.workday/bsvc}Journal_SourceObjectType"/>
 *         &lt;element name="Book_Code_Reference" type="{urn:com.workday/bsvc}Book_CodeObjectType" minOccurs="0"/>
 *         &lt;element name="Journal_Entry_Line_Replacement_Data" type="{urn:com.workday/bsvc}Journal_Entry_Line_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Beginning_Balance_Journal_DataType", propOrder = {
    "accountingJournalID",
    "companyReference",
    "currencyReference",
    "currencyRateTypeReference",
    "ledgerYearReferenceData",
    "journalEntryMemo",
    "journalSourceReference",
    "bookCodeReference",
    "journalEntryLineReplacementData"
})
public class BeginningBalanceJournalDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Accounting_Journal_ID")
    protected String accountingJournalID;
    @XmlElement(name = "Company_Reference", required = true)
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Currency_Reference", required = true)
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Currency_Rate_Type_Reference")
    protected CurrencyRateTypeObjectType currencyRateTypeReference;
    @XmlElement(name = "Ledger_Year_Reference_Data", required = true)
    protected LedgerYearReferenceType ledgerYearReferenceData;
    @XmlElement(name = "Journal_Entry_Memo")
    protected String journalEntryMemo;
    @XmlElement(name = "Journal_Source_Reference", required = true)
    protected JournalSourceObjectType journalSourceReference;
    @XmlElement(name = "Book_Code_Reference")
    protected BookCodeObjectType bookCodeReference;
    @XmlElement(name = "Journal_Entry_Line_Replacement_Data")
    protected List<JournalEntryLineDataType> journalEntryLineReplacementData;

    /**
     * Gets the value of the accountingJournalID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccountingJournalID() {
        return accountingJournalID;
    }

    /**
     * Sets the value of the accountingJournalID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccountingJournalID(String value) {
        this.accountingJournalID = value;
    }

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the currencyRateTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyRateTypeObjectType }
     *     
     */
    public CurrencyRateTypeObjectType getCurrencyRateTypeReference() {
        return currencyRateTypeReference;
    }

    /**
     * Sets the value of the currencyRateTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyRateTypeObjectType }
     *     
     */
    public void setCurrencyRateTypeReference(CurrencyRateTypeObjectType value) {
        this.currencyRateTypeReference = value;
    }

    /**
     * Gets the value of the ledgerYearReferenceData property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerYearReferenceType }
     *     
     */
    public LedgerYearReferenceType getLedgerYearReferenceData() {
        return ledgerYearReferenceData;
    }

    /**
     * Sets the value of the ledgerYearReferenceData property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerYearReferenceType }
     *     
     */
    public void setLedgerYearReferenceData(LedgerYearReferenceType value) {
        this.ledgerYearReferenceData = value;
    }

    /**
     * Gets the value of the journalEntryMemo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJournalEntryMemo() {
        return journalEntryMemo;
    }

    /**
     * Sets the value of the journalEntryMemo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJournalEntryMemo(String value) {
        this.journalEntryMemo = value;
    }

    /**
     * Gets the value of the journalSourceReference property.
     * 
     * @return
     *     possible object is
     *     {@link JournalSourceObjectType }
     *     
     */
    public JournalSourceObjectType getJournalSourceReference() {
        return journalSourceReference;
    }

    /**
     * Sets the value of the journalSourceReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JournalSourceObjectType }
     *     
     */
    public void setJournalSourceReference(JournalSourceObjectType value) {
        this.journalSourceReference = value;
    }

    /**
     * Gets the value of the bookCodeReference property.
     * 
     * @return
     *     possible object is
     *     {@link BookCodeObjectType }
     *     
     */
    public BookCodeObjectType getBookCodeReference() {
        return bookCodeReference;
    }

    /**
     * Sets the value of the bookCodeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BookCodeObjectType }
     *     
     */
    public void setBookCodeReference(BookCodeObjectType value) {
        this.bookCodeReference = value;
    }

    /**
     * Gets the value of the journalEntryLineReplacementData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the journalEntryLineReplacementData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJournalEntryLineReplacementData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JournalEntryLineDataType }
     * 
     * 
     */
    public List<JournalEntryLineDataType> getJournalEntryLineReplacementData() {
        if (journalEntryLineReplacementData == null) {
            journalEntryLineReplacementData = new ArrayList<JournalEntryLineDataType>();
        }
        return this.journalEntryLineReplacementData;
    }

    /**
     * Sets the value of the journalEntryLineReplacementData property.
     * 
     * @param journalEntryLineReplacementData
     *     allowed object is
     *     {@link JournalEntryLineDataType }
     *     
     */
    public void setJournalEntryLineReplacementData(List<JournalEntryLineDataType> journalEntryLineReplacementData) {
        this.journalEntryLineReplacementData = journalEntryLineReplacementData;
    }

}
