
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Wrapper Element that includes Basic Gift and Data
 * 
 * <p>Java class for Basic_Gift_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Basic_Gift_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Gift_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Include_Gift_ID_in_Name" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Gift_Type_Reference" type="{urn:com.workday/bsvc}Gift_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Gift_Purpose_Reference" type="{urn:com.workday/bsvc}Gift_PurposeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Related_Worktags_Reference" type="{urn:com.workday/bsvc}Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Gift_is_Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Basic_Gift_DataType", propOrder = {
    "id",
    "giftName",
    "includeGiftIDInName",
    "giftTypeReference",
    "giftPurposeReference",
    "relatedWorktagsReference",
    "giftIsInactive"
})
public class BasicGiftDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "ID")
    protected String id;
    @XmlElement(name = "Gift_Name", required = true)
    protected String giftName;
    @XmlElement(name = "Include_Gift_ID_in_Name")
    protected Boolean includeGiftIDInName;
    @XmlElement(name = "Gift_Type_Reference")
    protected GiftTypeObjectType giftTypeReference;
    @XmlElement(name = "Gift_Purpose_Reference")
    protected List<GiftPurposeObjectType> giftPurposeReference;
    @XmlElement(name = "Related_Worktags_Reference")
    protected List<AccountingWorktagObjectType> relatedWorktagsReference;
    @XmlElement(name = "Gift_is_Inactive")
    protected Boolean giftIsInactive;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setID(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the giftName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGiftName() {
        return giftName;
    }

    /**
     * Sets the value of the giftName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGiftName(String value) {
        this.giftName = value;
    }

    /**
     * Gets the value of the includeGiftIDInName property.
     * This getter has been renamed from isIncludeGiftIDInName() to getIncludeGiftIDInName() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeGiftIDInName() {
        return includeGiftIDInName;
    }

    /**
     * Sets the value of the includeGiftIDInName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeGiftIDInName(Boolean value) {
        this.includeGiftIDInName = value;
    }

    /**
     * Gets the value of the giftTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link GiftTypeObjectType }
     *     
     */
    public GiftTypeObjectType getGiftTypeReference() {
        return giftTypeReference;
    }

    /**
     * Sets the value of the giftTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link GiftTypeObjectType }
     *     
     */
    public void setGiftTypeReference(GiftTypeObjectType value) {
        this.giftTypeReference = value;
    }

    /**
     * Gets the value of the giftPurposeReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the giftPurposeReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGiftPurposeReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GiftPurposeObjectType }
     * 
     * 
     */
    public List<GiftPurposeObjectType> getGiftPurposeReference() {
        if (giftPurposeReference == null) {
            giftPurposeReference = new ArrayList<GiftPurposeObjectType>();
        }
        return this.giftPurposeReference;
    }

    /**
     * Gets the value of the relatedWorktagsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the relatedWorktagsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRelatedWorktagsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagObjectType }
     * 
     * 
     */
    public List<AccountingWorktagObjectType> getRelatedWorktagsReference() {
        if (relatedWorktagsReference == null) {
            relatedWorktagsReference = new ArrayList<AccountingWorktagObjectType>();
        }
        return this.relatedWorktagsReference;
    }

    /**
     * Gets the value of the giftIsInactive property.
     * This getter has been renamed from isGiftIsInactive() to getGiftIsInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getGiftIsInactive() {
        return giftIsInactive;
    }

    /**
     * Sets the value of the giftIsInactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setGiftIsInactive(Boolean value) {
        this.giftIsInactive = value;
    }

    /**
     * Sets the value of the giftPurposeReference property.
     * 
     * @param giftPurposeReference
     *     allowed object is
     *     {@link GiftPurposeObjectType }
     *     
     */
    public void setGiftPurposeReference(List<GiftPurposeObjectType> giftPurposeReference) {
        this.giftPurposeReference = giftPurposeReference;
    }

    /**
     * Sets the value of the relatedWorktagsReference property.
     * 
     * @param relatedWorktagsReference
     *     allowed object is
     *     {@link AccountingWorktagObjectType }
     *     
     */
    public void setRelatedWorktagsReference(List<AccountingWorktagObjectType> relatedWorktagsReference) {
        this.relatedWorktagsReference = relatedWorktagsReference;
    }

}
