
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Accounting Journal Data
 * 
 * <p>Java class for Accounting_Journal__HV__DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Accounting_Journal__HV__DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Accounting_Journal_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Submit" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Locked_in_Workday" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Round_Ledger_Amounts" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Journal_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType"/>
 *         &lt;element name="Ledger_Type_Reference" type="{urn:com.workday/bsvc}Ledger_TypeObjectType"/>
 *         &lt;element name="Book_Code_Reference" type="{urn:com.workday/bsvc}Book_CodeObjectType" minOccurs="0"/>
 *         &lt;element name="Accounting_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="Journal_Source_Reference" type="{urn:com.workday/bsvc}Journal_SourceObjectType"/>
 *         &lt;element name="Balancing_Worktag_Reference" type="{urn:com.workday/bsvc}Balancing_WorktagObjectType" minOccurs="0"/>
 *         &lt;element name="Journal_Entry_Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Adjustment_Journal" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Create_Reversal" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Control_Total_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Currency_Rate_Type_Reference" type="{urn:com.workday/bsvc}Currency_Rate_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Display_Account_Set_Reference" type="{urn:com.workday/bsvc}Account_SetObjectType" minOccurs="0"/>
 *         &lt;element name="Journal_Entry_Line_Replacement_Data" type="{urn:com.workday/bsvc}Journal_Entry_Line__HV__DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Attachment_Data" type="{urn:com.workday/bsvc}Financials_Attachment_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Accounting_Journal_Intercompany_Sub_Process" type="{urn:com.workday/bsvc}Accounting_Journal_Intercompany_Sub_ProcessType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Accounting_Journal__HV__DataType", propOrder = {
    "accountingJournalID",
    "submit",
    "lockedInWorkday",
    "roundLedgerAmounts",
    "journalNumber",
    "companyReference",
    "currencyReference",
    "ledgerTypeReference",
    "bookCodeReference",
    "accountingDate",
    "journalSourceReference",
    "balancingWorktagReference",
    "journalEntryMemo",
    "adjustmentJournal",
    "createReversal",
    "controlTotalAmount",
    "currencyRateTypeReference",
    "displayAccountSetReference",
    "journalEntryLineReplacementData",
    "attachmentData",
    "accountingJournalIntercompanySubProcess"
})
public class AccountingJournalHVDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Accounting_Journal_ID")
    protected String accountingJournalID;
    @XmlElement(name = "Submit")
    protected Boolean submit;
    @XmlElement(name = "Locked_in_Workday")
    protected Boolean lockedInWorkday;
    @XmlElement(name = "Round_Ledger_Amounts")
    protected Boolean roundLedgerAmounts;
    @XmlElement(name = "Journal_Number")
    protected String journalNumber;
    @XmlElement(name = "Company_Reference", required = true)
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Currency_Reference", required = true)
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Ledger_Type_Reference", required = true)
    protected LedgerTypeObjectType ledgerTypeReference;
    @XmlElement(name = "Book_Code_Reference")
    protected BookCodeObjectType bookCodeReference;
    @XmlElement(name = "Accounting_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar accountingDate;
    @XmlElement(name = "Journal_Source_Reference", required = true)
    protected JournalSourceObjectType journalSourceReference;
    @XmlElement(name = "Balancing_Worktag_Reference")
    protected BalancingWorktagObjectType balancingWorktagReference;
    @XmlElement(name = "Journal_Entry_Memo")
    protected String journalEntryMemo;
    @XmlElement(name = "Adjustment_Journal")
    protected Boolean adjustmentJournal;
    @XmlElement(name = "Create_Reversal")
    protected Boolean createReversal;
    @XmlElement(name = "Control_Total_Amount")
    protected BigDecimal controlTotalAmount;
    @XmlElement(name = "Currency_Rate_Type_Reference")
    protected CurrencyRateTypeObjectType currencyRateTypeReference;
    @XmlElement(name = "Display_Account_Set_Reference")
    protected AccountSetObjectType displayAccountSetReference;
    @XmlElement(name = "Journal_Entry_Line_Replacement_Data")
    protected List<JournalEntryLineHVDataType> journalEntryLineReplacementData;
    @XmlElement(name = "Attachment_Data")
    protected List<FinancialsAttachmentDataType> attachmentData;
    @XmlElement(name = "Accounting_Journal_Intercompany_Sub_Process")
    protected AccountingJournalIntercompanySubProcessType accountingJournalIntercompanySubProcess;

    /**
     * Gets the value of the accountingJournalID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccountingJournalID() {
        return accountingJournalID;
    }

    /**
     * Sets the value of the accountingJournalID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccountingJournalID(String value) {
        this.accountingJournalID = value;
    }

    /**
     * Gets the value of the submit property.
     * This getter has been renamed from isSubmit() to getSubmit() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getSubmit() {
        return submit;
    }

    /**
     * Sets the value of the submit property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setSubmit(Boolean value) {
        this.submit = value;
    }

    /**
     * Gets the value of the lockedInWorkday property.
     * This getter has been renamed from isLockedInWorkday() to getLockedInWorkday() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getLockedInWorkday() {
        return lockedInWorkday;
    }

    /**
     * Sets the value of the lockedInWorkday property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setLockedInWorkday(Boolean value) {
        this.lockedInWorkday = value;
    }

    /**
     * Gets the value of the roundLedgerAmounts property.
     * This getter has been renamed from isRoundLedgerAmounts() to getRoundLedgerAmounts() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getRoundLedgerAmounts() {
        return roundLedgerAmounts;
    }

    /**
     * Sets the value of the roundLedgerAmounts property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRoundLedgerAmounts(Boolean value) {
        this.roundLedgerAmounts = value;
    }

    /**
     * Gets the value of the journalNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJournalNumber() {
        return journalNumber;
    }

    /**
     * Sets the value of the journalNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJournalNumber(String value) {
        this.journalNumber = value;
    }

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the ledgerTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerTypeObjectType }
     *     
     */
    public LedgerTypeObjectType getLedgerTypeReference() {
        return ledgerTypeReference;
    }

    /**
     * Sets the value of the ledgerTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerTypeObjectType }
     *     
     */
    public void setLedgerTypeReference(LedgerTypeObjectType value) {
        this.ledgerTypeReference = value;
    }

    /**
     * Gets the value of the bookCodeReference property.
     * 
     * @return
     *     possible object is
     *     {@link BookCodeObjectType }
     *     
     */
    public BookCodeObjectType getBookCodeReference() {
        return bookCodeReference;
    }

    /**
     * Sets the value of the bookCodeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BookCodeObjectType }
     *     
     */
    public void setBookCodeReference(BookCodeObjectType value) {
        this.bookCodeReference = value;
    }

    /**
     * Gets the value of the accountingDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getAccountingDate() {
        return accountingDate;
    }

    /**
     * Sets the value of the accountingDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setAccountingDate(XMLGregorianCalendar value) {
        this.accountingDate = value;
    }

    /**
     * Gets the value of the journalSourceReference property.
     * 
     * @return
     *     possible object is
     *     {@link JournalSourceObjectType }
     *     
     */
    public JournalSourceObjectType getJournalSourceReference() {
        return journalSourceReference;
    }

    /**
     * Sets the value of the journalSourceReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JournalSourceObjectType }
     *     
     */
    public void setJournalSourceReference(JournalSourceObjectType value) {
        this.journalSourceReference = value;
    }

    /**
     * Gets the value of the balancingWorktagReference property.
     * 
     * @return
     *     possible object is
     *     {@link BalancingWorktagObjectType }
     *     
     */
    public BalancingWorktagObjectType getBalancingWorktagReference() {
        return balancingWorktagReference;
    }

    /**
     * Sets the value of the balancingWorktagReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BalancingWorktagObjectType }
     *     
     */
    public void setBalancingWorktagReference(BalancingWorktagObjectType value) {
        this.balancingWorktagReference = value;
    }

    /**
     * Gets the value of the journalEntryMemo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJournalEntryMemo() {
        return journalEntryMemo;
    }

    /**
     * Sets the value of the journalEntryMemo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJournalEntryMemo(String value) {
        this.journalEntryMemo = value;
    }

    /**
     * Gets the value of the adjustmentJournal property.
     * This getter has been renamed from isAdjustmentJournal() to getAdjustmentJournal() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAdjustmentJournal() {
        return adjustmentJournal;
    }

    /**
     * Sets the value of the adjustmentJournal property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAdjustmentJournal(Boolean value) {
        this.adjustmentJournal = value;
    }

    /**
     * Gets the value of the createReversal property.
     * This getter has been renamed from isCreateReversal() to getCreateReversal() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getCreateReversal() {
        return createReversal;
    }

    /**
     * Sets the value of the createReversal property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCreateReversal(Boolean value) {
        this.createReversal = value;
    }

    /**
     * Gets the value of the controlTotalAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getControlTotalAmount() {
        return controlTotalAmount;
    }

    /**
     * Sets the value of the controlTotalAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setControlTotalAmount(BigDecimal value) {
        this.controlTotalAmount = value;
    }

    /**
     * Gets the value of the currencyRateTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyRateTypeObjectType }
     *     
     */
    public CurrencyRateTypeObjectType getCurrencyRateTypeReference() {
        return currencyRateTypeReference;
    }

    /**
     * Sets the value of the currencyRateTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyRateTypeObjectType }
     *     
     */
    public void setCurrencyRateTypeReference(CurrencyRateTypeObjectType value) {
        this.currencyRateTypeReference = value;
    }

    /**
     * Gets the value of the displayAccountSetReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountSetObjectType }
     *     
     */
    public AccountSetObjectType getDisplayAccountSetReference() {
        return displayAccountSetReference;
    }

    /**
     * Sets the value of the displayAccountSetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountSetObjectType }
     *     
     */
    public void setDisplayAccountSetReference(AccountSetObjectType value) {
        this.displayAccountSetReference = value;
    }

    /**
     * Gets the value of the journalEntryLineReplacementData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the journalEntryLineReplacementData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJournalEntryLineReplacementData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JournalEntryLineHVDataType }
     * 
     * 
     */
    public List<JournalEntryLineHVDataType> getJournalEntryLineReplacementData() {
        if (journalEntryLineReplacementData == null) {
            journalEntryLineReplacementData = new ArrayList<JournalEntryLineHVDataType>();
        }
        return this.journalEntryLineReplacementData;
    }

    /**
     * Gets the value of the attachmentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the attachmentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttachmentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialsAttachmentDataType }
     * 
     * 
     */
    public List<FinancialsAttachmentDataType> getAttachmentData() {
        if (attachmentData == null) {
            attachmentData = new ArrayList<FinancialsAttachmentDataType>();
        }
        return this.attachmentData;
    }

    /**
     * Gets the value of the accountingJournalIntercompanySubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AccountingJournalIntercompanySubProcessType }
     *     
     */
    public AccountingJournalIntercompanySubProcessType getAccountingJournalIntercompanySubProcess() {
        return accountingJournalIntercompanySubProcess;
    }

    /**
     * Sets the value of the accountingJournalIntercompanySubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountingJournalIntercompanySubProcessType }
     *     
     */
    public void setAccountingJournalIntercompanySubProcess(AccountingJournalIntercompanySubProcessType value) {
        this.accountingJournalIntercompanySubProcess = value;
    }

    /**
     * Sets the value of the journalEntryLineReplacementData property.
     * 
     * @param journalEntryLineReplacementData
     *     allowed object is
     *     {@link JournalEntryLineHVDataType }
     *     
     */
    public void setJournalEntryLineReplacementData(List<JournalEntryLineHVDataType> journalEntryLineReplacementData) {
        this.journalEntryLineReplacementData = journalEntryLineReplacementData;
    }

    /**
     * Sets the value of the attachmentData property.
     * 
     * @param attachmentData
     *     allowed object is
     *     {@link FinancialsAttachmentDataType }
     *     
     */
    public void setAttachmentData(List<FinancialsAttachmentDataType> attachmentData) {
        this.attachmentData = attachmentData;
    }

}
