
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Account Set data
 * 
 * <p>Java class for Account_Set_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Account_Set_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Account_Set_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Account_Set_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Chart_of_Accounts" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Account_Set_Reference" type="{urn:com.workday/bsvc}Account_SetObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Ledger_Account_Data" type="{urn:com.workday/bsvc}Ledger_Account_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Account_Set_DataType", propOrder = {
    "accountSetID",
    "accountSetName",
    "chartOfAccounts",
    "accountSetReference",
    "ledgerAccountData"
})
public class AccountSetDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Account_Set_ID")
    protected String accountSetID;
    @XmlElement(name = "Account_Set_Name", required = true)
    protected String accountSetName;
    @XmlElement(name = "Chart_of_Accounts")
    protected Boolean chartOfAccounts;
    @XmlElement(name = "Account_Set_Reference")
    protected List<AccountSetObjectType> accountSetReference;
    @XmlElement(name = "Ledger_Account_Data")
    protected List<LedgerAccountDataType> ledgerAccountData;

    /**
     * Gets the value of the accountSetID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccountSetID() {
        return accountSetID;
    }

    /**
     * Sets the value of the accountSetID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccountSetID(String value) {
        this.accountSetID = value;
    }

    /**
     * Gets the value of the accountSetName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccountSetName() {
        return accountSetName;
    }

    /**
     * Sets the value of the accountSetName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccountSetName(String value) {
        this.accountSetName = value;
    }

    /**
     * Gets the value of the chartOfAccounts property.
     * This getter has been renamed from isChartOfAccounts() to getChartOfAccounts() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getChartOfAccounts() {
        return chartOfAccounts;
    }

    /**
     * Sets the value of the chartOfAccounts property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setChartOfAccounts(Boolean value) {
        this.chartOfAccounts = value;
    }

    /**
     * Gets the value of the accountSetReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the accountSetReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAccountSetReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountSetObjectType }
     * 
     * 
     */
    public List<AccountSetObjectType> getAccountSetReference() {
        if (accountSetReference == null) {
            accountSetReference = new ArrayList<AccountSetObjectType>();
        }
        return this.accountSetReference;
    }

    /**
     * Gets the value of the ledgerAccountData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the ledgerAccountData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLedgerAccountData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LedgerAccountDataType }
     * 
     * 
     */
    public List<LedgerAccountDataType> getLedgerAccountData() {
        if (ledgerAccountData == null) {
            ledgerAccountData = new ArrayList<LedgerAccountDataType>();
        }
        return this.ledgerAccountData;
    }

    /**
     * Sets the value of the accountSetReference property.
     * 
     * @param accountSetReference
     *     allowed object is
     *     {@link AccountSetObjectType }
     *     
     */
    public void setAccountSetReference(List<AccountSetObjectType> accountSetReference) {
        this.accountSetReference = accountSetReference;
    }

    /**
     * Sets the value of the ledgerAccountData property.
     * 
     * @param ledgerAccountData
     *     allowed object is
     *     {@link LedgerAccountDataType }
     *     
     */
    public void setLedgerAccountData(List<LedgerAccountDataType> ledgerAccountData) {
        this.ledgerAccountData = ledgerAccountData;
    }

}
