/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.academicfoundation.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.workday.academicfoundation.adapters.AcademicFoundationModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.academicfoundation.connection.ConnectionManager;
import org.mule.modules.workday.academicfoundation.connection.UnableToAcquireConnectionException;
import org.mule.modules.workday.academicfoundation.connection.UnableToReleaseConnectionException;
import org.mule.modules.workday.academicfoundation.connectivity.AcademicFoundationModuleConnectionKey;
import org.mule.modules.workday.academicfoundation.process.ProcessCallback;
import org.mule.modules.workday.academicfoundation.process.ProcessInterceptor;
import org.mule.modules.workday.academicfoundation.processors.AbstractConnectedProcessor;
import org.mule.modules.workday.academicfoundation.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcademicFoundationModuleManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, AcademicFoundationModuleConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(AcademicFoundationModuleManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<AcademicFoundationModuleConnectionKey, AcademicFoundationModuleConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, AcademicFoundationModuleConnectionIdentifierAdapter> next;

    public AcademicFoundationModuleManagedConnectionProcessInterceptor(ProcessInterceptor<T, AcademicFoundationModuleConnectionIdentifierAdapter> next, ConnectionManager<AcademicFoundationModuleConnectionKey, AcademicFoundationModuleConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    @Override
    public T execute(ProcessCallback<T, AcademicFoundationModuleConnectionIdentifierAdapter> processCallback, AcademicFoundationModuleConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        String _transformedAcademicFoundationUser;
        AcademicFoundationModuleConnectionIdentifierAdapter connection = null;
        AcademicFoundationModuleConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getAcademicFoundationUser() != null) {
            _transformedAcademicFoundationUser = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_academicFoundationUserType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAcademicFoundationUser());
            if (_transformedAcademicFoundationUser == null) {
                throw new UnableToAcquireConnectionException("Parameter academicFoundationUser in method connect can't be null because is not @Optional");
            }
            String _transformedAcademicFoundationPassword = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_academicFoundationPasswordType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAcademicFoundationPassword());
            if (_transformedAcademicFoundationPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter academicFoundationPassword in method connect can't be null because is not @Optional");
            }
            String _transformedAcademicFoundationEndpoint = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_academicFoundationEndpointType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAcademicFoundationEndpoint());
            if (_transformedAcademicFoundationEndpoint == null) {
                throw new UnableToAcquireConnectionException("Parameter academicFoundationEndpoint in method connect can't be null because is not @Optional");
            }
            String _transformedAcademicFoundationWsdlLocation = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_academicFoundationWsdlLocationType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAcademicFoundationWsdlLocation());
            key = new AcademicFoundationModuleConnectionKey(_transformedAcademicFoundationUser, _transformedAcademicFoundationPassword, _transformedAcademicFoundationEndpoint, _transformedAcademicFoundationWsdlLocation);
        } else {
            key = this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedAcademicFoundationUser = this.next.execute(processCallback, connection, messageProcessor, event);
            return (T)_transformedAcademicFoundationUser;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        if (connection == null) continue;
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    @Override
    public T execute(ProcessCallback<T, AcademicFoundationModuleConnectionIdentifierAdapter> processCallback, AcademicFoundationModuleConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

