/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.academicfoundation.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.workday.academicfoundation.adapters.AcademicFoundationModuleLicenseChecker;
import org.mule.modules.workday.academicfoundation.connectivity.AcademicFoundationModuleConnectionKey;
import org.mule.modules.workday.academicfoundation.connectivity.AcademicFoundationModuleConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcademicFoundationModuleConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(AcademicFoundationModuleConnectionFactory.class);
    private AcademicFoundationModuleConnectionManager connectionManager;

    public AcademicFoundationModuleConnectionFactory(AcademicFoundationModuleConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof AcademicFoundationModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.academicfoundation.connectivity.AcademicFoundationModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        AcademicFoundationModuleLicenseChecker connector = new AcademicFoundationModuleLicenseChecker();
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.validateConnection()) {
            connector.connect(((AcademicFoundationModuleConnectionKey)key).getAcademicFoundationUser(), ((AcademicFoundationModuleConnectionKey)key).getAcademicFoundationPassword(), ((AcademicFoundationModuleConnectionKey)key).getAcademicFoundationEndpoint(), ((AcademicFoundationModuleConnectionKey)key).getAcademicFoundationWsdlLocation());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof AcademicFoundationModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.academicfoundation.connectivity.AcademicFoundationModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof AcademicFoundationModuleLicenseChecker)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.academicfoundation.adapters.AcademicFoundationModuleLicenseChecker")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((AcademicFoundationModuleLicenseChecker)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((AcademicFoundationModuleLicenseChecker)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((AcademicFoundationModuleLicenseChecker)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof AcademicFoundationModuleLicenseChecker)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.academicfoundation.adapters.AcademicFoundationModuleLicenseChecker")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((AcademicFoundationModuleLicenseChecker)obj).validateConnection();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof AcademicFoundationModuleConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof AcademicFoundationModuleLicenseChecker)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((AcademicFoundationModuleLicenseChecker)obj).validateConnection()) {
            ((AcademicFoundationModuleLicenseChecker)obj).connect(((AcademicFoundationModuleConnectionKey)key).getAcademicFoundationUser(), ((AcademicFoundationModuleConnectionKey)key).getAcademicFoundationPassword(), ((AcademicFoundationModuleConnectionKey)key).getAcademicFoundationEndpoint(), ((AcademicFoundationModuleConnectionKey)key).getAcademicFoundationWsdlLocation());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

