/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sugarcrm.cxf.interceptors;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.cxf.interceptor.DocLiteralInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.mule.modules.utils.MuleSoftException;
import org.w3c.dom.Node;
import org.xmlsoap.schemas.soap.encoding.Array;

public class UnmarshalAnyElementsArrayInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private Unmarshaller unmarshaller;

    public UnmarshalAnyElementsArrayInInterceptor() {
        super("unmarshal");
        this.addAfter(DocLiteralInInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        try {
            List messageList = (List)message.getContent(List.class);
            Object value = messageList.get(0);
            Object returnValue = value.getClass().getMethod("getReturn", null).invoke(value, new Object[0]);
            this.replaceListsInObject(returnValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void replaceListsInObject(Object object) {
        Unmarshaller unmarshaller = this.createUnmarshaller();
        if (this.isArrayClass(object.getClass())) {
            this.unMarshallListItems(unmarshaller, ((Array)object).getAny());
        } else {
            this.processBean(object, unmarshaller);
        }
    }

    private void processBean(Object object, Unmarshaller unmarshaller) {
        List<Method> methods = this.filterMethodsWithArrayReturn(object);
        for (Method method : methods) {
            try {
                this.unMarshallListItems(unmarshaller, ((Array)method.invoke(object, new Object[0])).getAny());
            }
            catch (Exception e) {
                throw MuleSoftException.soften((Throwable)e);
            }
        }
    }

    private Unmarshaller createUnmarshaller() {
        try {
            return JAXBContext.newInstance((String)"com.sugarcrm.sugarcrm:org.xmlsoap.schemas.soap.encoding:org.xmlsoap.schemas.wsdl").createUnmarshaller();
        }
        catch (JAXBException e) {
            throw MuleSoftException.soften((Throwable)e);
        }
    }

    private List<Method> filterMethodsWithArrayReturn(Object object) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Method m : object.getClass().getDeclaredMethods()) {
            if (!this.isArrayClass(m.getReturnType())) continue;
            methods.add(m);
        }
        return methods;
    }

    private boolean isArrayClass(Class<?> type) {
        return Array.class.isAssignableFrom(type);
    }

    private void unMarshallListItems(Unmarshaller unmarshaller, List<Object> anyList) {
        LinkedList<Object> marshalledObjects = new LinkedList<Object>();
        Iterator<Object> iter = anyList.iterator();
        while (iter.hasNext()) {
            try {
                Object value = ((JAXBElement)unmarshaller.unmarshal((Node)iter.next())).getValue();
                this.replaceListsInObject(value);
                marshalledObjects.add(value);
                iter.remove();
            }
            catch (JAXBException e) {
                throw MuleSoftException.soften((Throwable)e);
            }
        }
        anyList.addAll(marshalledObjects);
    }
}

