/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sugarcrm.cxf.interceptors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.mule.modules.sugarcrm.cxf.interceptors.transformer.TransformerXMlSugarToCxfValid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNamespacesForLaterUnmarshalInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger logger = LoggerFactory.getLogger(AddNamespacesForLaterUnmarshalInInterceptor.class);

    public AddNamespacesForLaterUnmarshalInInterceptor() {
        super("receive");
        this.addAfter(LoggingInInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        try {
            String xml = IOUtils.toString((InputStream)((InputStream)message.getContent(InputStream.class)), (String)"UTF-8");
            logger.trace("Response to Replace {}", (Object)xml);
            String xmlResult = new TransformerXMlSugarToCxfValid().transform(xml);
            logger.trace("Result {}", (Object)xmlResult);
            ByteArrayInputStream responseStream = new ByteArrayInputStream(xmlResult.getBytes("UTF-8"));
            message.setContent(InputStream.class, (Object)responseStream);
        }
        catch (Exception e) {
            throw new UnhandledException((Throwable)e);
        }
    }
}

