/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sugarcrm.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.Capabilities;
import org.mule.api.Capability;
import org.mule.api.ConnectionManager;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.PoolingProfile;
import org.mule.modules.sugarcrm.adapters.SugarConnectorConnectionIdentifierAdapter;
import org.mule.modules.sugarcrm.connectivity.ManagedConnectionProcessTemplate;
import org.mule.modules.sugarcrm.connectivity.SugarConnectorConnectionFactory;
import org.mule.modules.sugarcrm.connectivity.SugarConnectorConnectionKey;

public class SugarConnectorConnectionManager
implements Capabilities,
ConnectionManager<SugarConnectorConnectionKey, SugarConnectorConnectionIdentifierAdapter>,
MetadataAware,
MuleContextAware,
Initialisable,
ProcessAdapter<SugarConnectorConnectionIdentifierAdapter> {
    private String username;
    private String password;
    private String endpoint;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Sugar";
    private static final String MODULE_VERSION = "1.0-beta4";
    private static final String DEVKIT_VERSION = "3.3.1";
    private static final String DEVKIT_BUILD = "UNNAMED.1297.150f2c9";

    public void setEndpoint(String value) {
        this.endpoint = value;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new SugarConnectorConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public SugarConnectorConnectionIdentifierAdapter acquireConnection(SugarConnectorConnectionKey key) throws Exception {
        return (SugarConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    public void releaseConnection(SugarConnectorConnectionKey key, SugarConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    public void destroyConnection(SugarConnectorConnectionKey key, SugarConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, SugarConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, this.muleContext);
    }

    public SugarConnectorConnectionKey getDefaultConnectionKey() {
        return new SugarConnectorConnectionKey(this.getUsername(), this.getPassword());
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }
}

