/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sugarcrm.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.sugarcrm.adapters.SugarConnectorConnectionIdentifierAdapter;
import org.mule.modules.sugarcrm.connectivity.SugarConnectorConnectionKey;
import org.mule.modules.sugarcrm.connectivity.SugarConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SugarConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(SugarConnectorConnectionFactory.class);
    private SugarConnectorConnectionManager connectionManager;

    public SugarConnectorConnectionFactory(SugarConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof SugarConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        SugarConnectorConnectionIdentifierAdapter connector = new SugarConnectorConnectionIdentifierAdapter();
        connector.setEndpoint(this.connectionManager.getEndpoint());
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof SugarConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof SugarConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            ((SugarConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((SugarConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((SugarConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof SugarConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            return ((SugarConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof SugarConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof SugarConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((SugarConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((SugarConnectorConnectionIdentifierAdapter)obj).connect(((SugarConnectorConnectionKey)key).getUsername(), ((SugarConnectorConnectionKey)key).getPassword());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

