/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sugarcrm;

import com.sugarcrm.sugarcrm.EntryValue;
import com.sugarcrm.sugarcrm.GetAvailableModulesRequestType;
import com.sugarcrm.sugarcrm.GetEntriesCountRequestType;
import com.sugarcrm.sugarcrm.GetEntriesCountResult;
import com.sugarcrm.sugarcrm.GetEntriesRequestType;
import com.sugarcrm.sugarcrm.GetEntryListRequestType;
import com.sugarcrm.sugarcrm.GetEntryListResultVersion2;
import com.sugarcrm.sugarcrm.GetEntryRequestType;
import com.sugarcrm.sugarcrm.GetEntryResultVersion2;
import com.sugarcrm.sugarcrm.GetModuleFieldsRequestType;
import com.sugarcrm.sugarcrm.LoginRequestType;
import com.sugarcrm.sugarcrm.LogoutRequestType;
import com.sugarcrm.sugarcrm.ModuleList;
import com.sugarcrm.sugarcrm.NewModuleFields;
import com.sugarcrm.sugarcrm.NewSetEntriesResult;
import com.sugarcrm.sugarcrm.NewSetEntryResult;
import com.sugarcrm.sugarcrm.NewSetRelationshipListResult;
import com.sugarcrm.sugarcrm.ReturnSearchResult;
import com.sugarcrm.sugarcrm.SearchByModuleRequestType;
import com.sugarcrm.sugarcrm.SetEntriesRequestType;
import com.sugarcrm.sugarcrm.SetEntryRequestType;
import com.sugarcrm.sugarcrm.SetRelationshipRequestType;
import com.sugarcrm.sugarcrm.SetRelationshipsRequestType;
import com.sugarcrm.sugarcrm.UserAuth;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.display.Password;
import org.mule.api.annotations.licensing.RequiresEnterpriseLicense;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.modules.sugarcrm.api.SugarCrmClient;
import org.mule.modules.sugarcrm.api.SugarCrmClientSoap;
import org.mule.modules.sugarcrm.api.exceptions.InvalidLoginException;
import org.mule.modules.sugarcrm.requests.GetAvailableModulesRequest;
import org.mule.modules.sugarcrm.requests.GetEntriesCountRequest;
import org.mule.modules.sugarcrm.requests.GetEntriesRequest;
import org.mule.modules.sugarcrm.requests.GetEntryListRequest;
import org.mule.modules.sugarcrm.requests.GetEntryRequest;
import org.mule.modules.sugarcrm.requests.GetModuleFieldsRequest;
import org.mule.modules.sugarcrm.requests.SearchByModuleRequest;
import org.mule.modules.sugarcrm.requests.SetEntriesRequest;
import org.mule.modules.sugarcrm.requests.SetEntryRequest;
import org.mule.modules.sugarcrm.requests.SetRelationshipRequest;
import org.mule.modules.sugarcrm.requests.SetRelationshipsRequest;
import org.mule.modules.sugarcrm.utils.CryptoUtils;
import org.springframework.remoting.soap.SoapFaultException;

@Connector(name="sugar", friendlyName="Sugar")
@RequiresEnterpriseLicense
public class SugarConnector {
    private SugarCrmClient client;
    @Configurable
    private String endpoint;
    private String sessionId;

    @Connect
    public void connect(@ConnectionKey String username, @Password String password) throws ConnectionException {
        LoginRequestType request = new LoginRequestType();
        UserAuth userAuth = new UserAuth();
        userAuth.setUserName(username);
        userAuth.setPassword(CryptoUtils.getMd5(password));
        request.setUserAuth(userAuth);
        try {
            EntryValue response = this.getClient().login(request).getReturn();
            this.sessionId = response.getId();
        }
        catch (InvalidLoginException e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, e.getMessage(), "Invalid username or password");
        }
        catch (SoapFaultException e) {
            String causeMessage = e.getCause().getMessage();
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, causeMessage, causeMessage);
        }
    }

    @Disconnect
    public void disconnect() {
        if (this.isConnected()) {
            LogoutRequestType request = new LogoutRequestType();
            request.setSession(this.sessionId);
            this.getClient().logout(request);
            this.sessionId = null;
        }
    }

    @ValidateConnection
    public boolean isConnected() {
        return this.sessionId != null;
    }

    @ConnectionIdentifier
    public String getSessionId() {
        return this.sessionId;
    }

    @Processor
    public GetEntryListResultVersion2 getEntryList(@Optional @Default(value="#[payload]") GetEntryListRequest request) {
        GetEntryListRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().getEntryList(realRequest).getReturn();
    }

    @Processor
    public GetEntriesCountResult getCountEntries(@Optional @Default(value="#[payload]") GetEntriesCountRequest request) {
        GetEntriesCountRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().getCountEntries(realRequest).getReturn();
    }

    @Processor
    public GetEntryResultVersion2 getEntries(@Optional @Default(value="#[payload]") GetEntriesRequest request) {
        GetEntriesRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().getEntries(realRequest).getReturn();
    }

    @Processor
    public NewSetEntryResult setEntry(@Optional @Default(value="#[payload]") SetEntryRequest request) {
        SetEntryRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().setEntry(realRequest).getReturn();
    }

    @Processor
    public NewSetEntriesResult setEntries(@Optional @Default(value="#[payload]") SetEntriesRequest request) {
        SetEntriesRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().setEntries(realRequest).getReturn();
    }

    @Processor
    public NewModuleFields getModuleFields(@Optional @Default(value="#[payload]") GetModuleFieldsRequest request) {
        GetModuleFieldsRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().getModuleFields(realRequest).getReturn();
    }

    @Processor
    public ModuleList getAvailableModules(@Optional @Default(value="#[payload]") GetAvailableModulesRequest request) {
        GetAvailableModulesRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().getAvailableModules(realRequest).getReturn();
    }

    @Processor
    public ReturnSearchResult searchByModule(@Optional @Default(value="#[payload]") SearchByModuleRequest request) {
        SearchByModuleRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().searchByModule(realRequest).getReturn();
    }

    @Processor
    public NewSetRelationshipListResult setRelationships(@Optional @Default(value="#[payload]") SetRelationshipsRequest request) {
        SetRelationshipsRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().setRelationships(realRequest).getReturn();
    }

    @Processor
    public NewSetRelationshipListResult setRelationship(@Optional @Default(value="#[payload]") SetRelationshipRequest request) {
        SetRelationshipRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().setRelationship(realRequest).getReturn();
    }

    @Processor
    public GetEntryResultVersion2 getEntry(@Optional @Default(value="#[payload]") GetEntryRequest request) {
        GetEntryRequestType realRequest = request.getBean();
        realRequest.setSession(this.sessionId);
        return this.getClient().getEntry(realRequest).getReturn();
    }

    private SugarCrmClient getClient() {
        if (this.client == null) {
            this.client = new SugarCrmClientSoap(this.endpoint);
        }
        return this.client;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setClient(SugarCrmClient client) {
        this.client = client;
    }
}

